/*
 *	for new GOGO-no-coda (1999/09)
 *	Copyright (C) 1999 shigeo
 *	special thanks to Keiichi SAKAI, URURI
 */

/*
 *	1999/08/04
 *		window_filter_subbandւ̓ւ
 *		Cx50%̍ & 3DN by shigeo
 *	1999/09/??
 *		A肳ɂasmœK
 *		LAMEfilter_subband(), window_subband()QƂȂ
 *		full asm
 *	1999/09/15
 *		3D Now![`ɒǏ]
 *	2000/03/08
 *		window_filter_subband_C()I _P6FPUƂĕςȂǁB
 *		mfbuf, sbd_xxx Ƃ܂ɂłȂ̂... by K.SAKAI
 *	2000/04/17
 *		SMPœK̂߂̕z by K.SAKAI
 */

#include "common.h"
#include "haveunit.h"
#include "subband.h"

/* sband*.nas */
void window_filter_subband_3DN(float *win_buf, float *s, int mode_gr);
void window_filter_subband_SSE(float *win_buf, float *s, int mode_gr);
void window_filter_subband_FPU(float *win_buf, float *s, int mode_gr);
#ifdef USE_E3DN
void window_filter_subband_E3DN(float *win_buf, float *s,int mode_gr);
#endif

/* defined in sband*.nas */
extern float	sbd_xxx[2][HAN_SIZE+1152];
extern float	enwindow[16][8][4];
extern float	idct_coefficient[16][32];

void sbd_shiftin_SSE(int (*mfbuf)[1152+576+EXTRADELAY], int stereo, int mode_gr);
void sbd_shiftin_SSE_MULTI(int (*mfbuf)[1152+576+EXTRADELAY], int stereo, int mode_gr);
void sbd_shiftin_3DN(int (*mfbuf)[1152+576+EXTRADELAY], int stereo, int mode_gr);
#ifdef USE_E3DN
void sbd_shiftin_E3DN(int (*mfbuf)[1152+576+EXTRADELAY], int stereo, int mode_gr);
#endif
static void
sbd_shiftin_C(int (*mfbuf)[1152+576+EXTRADELAY], int stereo, int mode_gr)
{
	float	*c;
	int	ch, i, j, *win_buf;

	for(ch = 0; ch < stereo; ch++){
		c = &sbd_xxx[ch][1152-18*32*mode_gr];
		memcpy(&sbd_xxx[ch][1152+32], c+32, (512-32)*sizeof(float));
		c = &sbd_xxx[ch][1152];
		win_buf = mfbuf[ch];
		for(j = 0; j < 18*mode_gr; j++){
			for (i = 31;i >=0;i--){
				c[i] = *win_buf++;
			}
			c -= 32;
		}
	}
}

static void
sbd_shiftin_empty(int (*mfbuf)[1152+576+EXTRADELAY], int stereo, int mode_gr)
{
}

void frame_shiftin_multi_SSE(int (*int_buf)[1152+576+EXTRADELAY], short *frame_buf, float (*flt_buf)[1152+HAN_SIZE], int mode_gr, int stereo);

#define NULL_FUNC (void (*)( int (*)[1784], int, int ) )NULL
#define NULL_FUNC2 (void (*)(int (*)[1784], short *, float (*)[1664], int , int))NULL

void
setup_window_filter_subband(int useUNIT)
{
	static int SCALEflag = 0;

	frame_shiftin_multi = NULL_FUNC2;
#ifdef USE_E3DN
	if(useUNIT & tE3DN){
		SETUP_DSP("use:window_filter_subband_E3DN\n");
		window_filter_subband=window_filter_subband_E3DN;
		SETUP_DSP("use:sbd_shiftin_E3DN\n");
		sbd_shiftin = sbd_shiftin_E3DN;
	}else
#endif
	if(useUNIT & t3DN){
		SETUP_DSP("use:window_filter_subband_3DN\n");
		window_filter_subband=window_filter_subband_3DN;
		SETUP_DSP("use:sbd_shiftin_3DN\n");
		sbd_shiftin = sbd_shiftin_3DN;
	}else
	if(useUNIT & tSSE){
		SETUP_DSP("use:window_filter_subband_SSE\n");
		window_filter_subband=window_filter_subband_SSE;
		if(useUNIT & tMULTI){
			if(useUNIT & tSPC2){
				SETUP_DSP("use:sbd_shiftin_SSE_MULTI\n");
				sbd_shiftin = sbd_shiftin_SSE_MULTI;
				frame_shiftin_multi = NULL_FUNC2;
			}else{
				SETUP_DSP("use:frame_shiftin_multi_SSE\n");
				sbd_shiftin = sbd_shiftin_empty;
				frame_shiftin_multi = frame_shiftin_multi_SSE;
			}
		}else{
			if(useUNIT & tSPC2){
				SETUP_DSP("use:frame_shiftin_multi_SSE\n");
				sbd_shiftin = sbd_shiftin_empty;
				frame_shiftin_multi = frame_shiftin_multi_SSE;
			}else{
				SETUP_DSP("use:sbd_shiftin_SSE\n");
				sbd_shiftin = sbd_shiftin_SSE;
				frame_shiftin_multi = NULL_FUNC2;
			}
		}
	}else
	{
		SETUP_DSP("use:window_filter_subband_FPU\n");
		window_filter_subband=window_filter_subband_FPU;
		SETUP_DSP("use:sbd_shiftin_C\n");
		sbd_shiftin = sbd_shiftin_C;
	}
	if(!SCALEflag){
    int i,j;
    for(i=0; i<16; i++){
	for(j=0; j<8; j++){
	    enwindow[i][j][0] *= SCALER;
	    enwindow[i][j][1] *= SCALER;
	    enwindow[i][j][2] *= SCALER;
	    enwindow[i][j][3] *= SCALER;
	}
    }
    SCALEflag=1;
	}
}

