static char rcsid[] = "$Id: resulthr.c 36300 2011-03-09 05:28:14Z twu $";
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "resulthr.h"
#include <stdlib.h>
#include "mem.h"
#include "stage3hr.h"


#ifdef DEBUG
#define debug(x) x
#else
#define debug(x)
#endif



#define T Result_T
struct T {
  Resulttype_T resulttype;
  int id;
  void **array;
  int npaths;
  void **array2;
  int npaths2;
};


Resulttype_T
Result_resulttype (T this) {
  return this->resulttype;
}

void
Resulttype_print (Resulttype_T resulttype) {
  switch (resulttype) {
  case SINGLEEND_NOMAPPING: printf("singleend_nomapping"); break;
  case PAIREDEND_NOMAPPING: printf("pairedend_nomapping"); break;
  case SINGLEEND_TRANSLOCATION: printf("singleend_translocation"); break;
  case PAIREDEND_TRANSLOCATION: printf("pairedend_translocation"); break;
  case SINGLEEND_UNIQ: printf("singleend_uniq"); break;
  case SINGLEEND_MULT: printf("singleend_mult"); break;
  case PAIRED_UNIQ: printf("paired_uniq"); break;
  case PAIRED_MULT: printf("paired_mult"); break;
  case CONCORDANT_UNIQ: printf("concordant_uniq"); break;
  case CONCORDANT_MULT: printf("concordant_mult"); break;
  case HALFMAPPING_UNIQ: printf("halfmapping_uniq"); break;
  case HALFMAPPING_MULT: printf("halfmapping_mult"); break;
  case UNPAIRED_UNIQ: printf("unpaired_uniq"); break;
  case UNPAIRED_MULT: printf("unpaired_mult"); break;
  default: abort();
  }
  return;
}


int
Result_id (T this) {
  return this->id;
}


void **
Result_array (int *npaths, T this) {
  *npaths = this->npaths;
  return this->array;
}


void **
Result_array2 (int *npaths, T this) {
  *npaths = this->npaths2;
  return this->array2;
}


T
Result_single_read_new (int id, void **resultarray, int npaths) {
  T new = (T) MALLOC(sizeof(*new));

  if (npaths == 0) {
    new->resulttype = SINGLEEND_NOMAPPING;
  } else if (Stage3_chrnum((Stage3_T) resultarray[0]) == 0) {
    new->resulttype = SINGLEEND_TRANSLOCATION;
  } else if (npaths == 1) {
    new->resulttype = SINGLEEND_UNIQ;
  } else {
    new->resulttype = SINGLEEND_MULT;
  }

  new->id = id;
  new->array = resultarray;
  new->npaths = npaths;

  return new;
}

T
Result_paired_read_new (int id, void **resultarray, int npaths, bool concordantp) {
  T new = (T) MALLOC(sizeof(*new));

  if (npaths == 0) {
    abort();

  } else if (Stage3_chrnum(Stage3pair_hit5((Stage3pair_T) resultarray[0])) == 0) {
    new->resulttype = PAIREDEND_TRANSLOCATION;
    
  } else if (Stage3_chrnum(Stage3pair_hit3((Stage3pair_T) resultarray[0])) == 0) {
    new->resulttype = PAIREDEND_TRANSLOCATION;

  } else if (concordantp == false) {
    if (npaths == 1) {
      new->resulttype = PAIRED_UNIQ;
    } else {
      new->resulttype = PAIRED_MULT;
    }

  } else {
    if (npaths == 1) {
      new->resulttype = CONCORDANT_UNIQ;
    } else {
      new->resulttype = CONCORDANT_MULT;
    }
  }

  new->id = id;
  new->array = resultarray;
  new->npaths = npaths;

  return new;
}

T
Result_paired_as_singles_new (int id, void **hits5, int npaths5, void **hits3, int npaths3) {
  T new = (T) MALLOC(sizeof(*new));

  if (npaths5 == 0 && npaths3 == 0) {
    new->resulttype = PAIREDEND_NOMAPPING;
  } else if (npaths5 > 0 && Stage3_chrnum((Stage3_T) hits5[0]) == 0) {
    new->resulttype = PAIREDEND_TRANSLOCATION;
  } else if (npaths3 > 0 && Stage3_chrnum((Stage3_T) hits3[0]) == 0) {
    new->resulttype = PAIREDEND_TRANSLOCATION;
  } else if (npaths5 == 0 && npaths3 == 1) {
    new->resulttype = HALFMAPPING_UNIQ;
  } else if (npaths5 == 1 && npaths3 == 0) {
    new->resulttype = HALFMAPPING_UNIQ;
  } else if (npaths5 == 0 || npaths3 == 0) {
    new->resulttype = HALFMAPPING_MULT;
  } else if (npaths5 == 1 && npaths3 == 1) {
    new->resulttype = UNPAIRED_UNIQ;
  } else {
    new->resulttype = UNPAIRED_MULT;
  }

  new->id = id;
  new->array = hits5;
  new->npaths = npaths5;
  new->array2 = hits3;
  new->npaths2 = npaths3;

  return new;
}

void
Result_free (T *old) {
  int i;
  Stage3_T stage3;
  Stage3pair_T stage3pair;

  switch ((*old)->resulttype) {
  case SINGLEEND_NOMAPPING: case PAIREDEND_NOMAPPING: break;

  case SINGLEEND_UNIQ: case SINGLEEND_MULT: case SINGLEEND_TRANSLOCATION:
    for (i = 0; i < (*old)->npaths; i++) {
      stage3 = (*old)->array[i];
      Stage3_free(&stage3);
    }
    FREE((*old)->array);
    break;

  case PAIRED_UNIQ: case PAIRED_MULT: case CONCORDANT_UNIQ: case CONCORDANT_MULT:
    for (i = 0; i < (*old)->npaths; i++) {
      stage3pair = (*old)->array[i];
      Stage3pair_free(&stage3pair);
    }
    FREE((*old)->array);
    break;

  default:
    for (i = 0; i < (*old)->npaths2; i++) {
      stage3 = (*old)->array2[i];
      Stage3_free(&stage3);
    }
    FREE((*old)->array2);

    for (i = 0; i < (*old)->npaths; i++) {
      stage3 = (*old)->array[i];
      Stage3_free(&stage3);
    }
    FREE((*old)->array);
  }

  FREE(*old);
  return;
}


