/* $Id: inbuffer.h 36019 2011-03-03 16:44:32Z twu $ */
#ifndef INBUFFER_INCLUDED
#define INBUFFER_INCLUDED
#include <stdio.h>
#include "bool.h"
#include "outbuffer.h"
#include "sequence.h"
#include "request.h"

#ifdef HAVE_ZLIB
#include <zlib.h>
#endif


#define T Inbuffer_T
typedef struct T *T;

extern T
Inbuffer_new (int nextchar, FILE *input,
#ifdef GSNAP
	      FILE *input2,
#ifdef HAVE_ZLIB
	      gzFile gzipped, gzFile gzipped2,
#endif
#endif
	      char **files, int nfiles,
#ifdef GSNAP
	      bool fastq_format_p, bool creads_format_p, bool pc_line_feeds_p,
	      int barcode_length, bool invert_first_p, bool invert_second_p,
	      bool chop_primers_p,
#else
	      Sequence_T usersegment, bool maponlyp,
#endif
	      int nspaces, unsigned int maxchars, int part_interval, int part_modulus);

extern void
Inbuffer_set_outbuffer (T this, Outbuffer_T outbuffer);

extern void
Inbuffer_free (T *old);

extern int
Inbuffer_fill_init (T this);

extern Request_T
Inbuffer_get_request (T this);

#undef T
#endif

