<%--
 Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 Use is subject to license terms.
--%>

<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>
<fmt:setBundle basename="LocalStrings"/>
<%@ page import="samples.rmi.simple.ejb.*" %>
<%@ page import="javax.ejb.*" %>
<%@ page import="java.math.*" %>
<%@ page import="javax.naming.*" %>
<%@ page import="javax.rmi.PortableRemoteObject" %>
<%@ page import="java.rmi.RemoteException" %>
<%@ page import='java.util.*' %>

<%!
   private Converter converter = null;

   public void jspInit() { 
      try {
         InitialContext ic = new InitialContext();
         Object objRef = ic.lookup("java:comp/env/ejb/RMIWConverter");
         ConverterHome home = (ConverterHome)PortableRemoteObject.narrow(objRef, ConverterHome.class);
         converter = home.create();
      } catch (RemoteException ex) {
            System.out.println("Couldn't create converter bean."+ ex.getMessage());
      } catch (CreateException ex) {
            System.out.println("Couldn't create converter bean."+ ex.getMessage());
      } catch (NamingException ex) {
            System.out.println("Unable to lookup home: "+ "TheConverter "+ ex.getMessage());
      } 
   }

   public void jspDestroy() {    
         converter = null;
   }
%>
<html>
<head>
    <title><fmt:message key="converter_title"/></title>
</head>

<body bgcolor="white">
<h1><b><center><fmt:message key="converter_title"/></center></b></h1>
<hr>
<p><fmt:message key="enter_amount"/>:</p>
<form method="get">
<input type="text" name=<fmt:message key="amount"/> size="25">
<br>
<p>
<input type="submit" value=<fmt:message key="submit"/> >
<input type="reset" value=<fmt:message key="reset"/> >
</form>

<%
    String amount = request.getParameter("amount");
    if ( amount != null && amount.length() > 0 ) {
       BigDecimal d = new BigDecimal (amount);
%>
   <p>
   <%= amount %> <fmt:message key="dollars_are"/>  <%= converter.dollarToYen(d) %>  <fmt:message key="yen"/> .
   <p>
   <%= amount %> <fmt:message key="yen_are"/>  <%= converter.yenToEuro(d) %>  <fmt:message key="euro"/> .
<%
    }
%>

</body>
</html>
