/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import org.jcp.xml.dsig.internal.dom.ApacheTransform;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class DOMXPathFilter2Transform
extends ApacheTransform {
    public void init(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        if (transformParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("params are required");
        }
        if (!(transformParameterSpec instanceof XPathFilter2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type XPathFilter2ParameterSpec");
        }
        this.params = transformParameterSpec;
    }

    public void init(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws InvalidAlgorithmParameterException {
        super.init(xMLStructure, xMLCryptoContext);
        try {
            this.unmarshalParams(DOMUtils.getFirstChildElement(this.transformElem));
        }
        catch (MarshalException marshalException) {
            throw (InvalidAlgorithmParameterException)new InvalidAlgorithmParameterException().initCause(marshalException);
        }
    }

    private void unmarshalParams(Element element) throws MarshalException {
        ArrayList<XPathType> arrayList = new ArrayList<XPathType>();
        while (element != null) {
            String string2 = element.getFirstChild().getNodeValue();
            String string3 = DOMUtils.getAttributeValue(element, "Filter");
            if (string3 == null) {
                throw new MarshalException("filter cannot be null");
            }
            XPathType.Filter filter = null;
            if (string3.equals("intersect")) {
                filter = XPathType.Filter.INTERSECT;
            } else if (string3.equals("subtract")) {
                filter = XPathType.Filter.SUBTRACT;
            } else if (string3.equals("union")) {
                filter = XPathType.Filter.UNION;
            } else {
                throw new MarshalException("Unknown XPathType filter type" + string3);
            }
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap != null) {
                int n = namedNodeMap.getLength();
                HashMap<String, String> hashMap = new HashMap<String, String>(n);
                for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    String string4 = attr.getPrefix();
                    if (string4 == null || !string4.equals("xmlns")) continue;
                    hashMap.put(attr.getLocalName(), attr.getValue());
                }
                arrayList.add(new XPathType(string2, filter, hashMap));
            } else {
                arrayList.add(new XPathType(string2, filter));
            }
            element = DOMUtils.getNextSiblingElement(element);
        }
        this.params = new XPathFilter2ParameterSpec(arrayList);
    }

    public void marshalParams(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
        super.marshalParams(xMLStructure, xMLCryptoContext);
        XPathFilter2ParameterSpec xPathFilter2ParameterSpec = (XPathFilter2ParameterSpec)this.getParameterSpec();
        String string2 = DOMUtils.getNSPrefix(xMLCryptoContext, "http://www.w3.org/2002/06/xmldsig-filter2");
        String string3 = string2 == null ? "xmlns" : "xmlns:" + string2;
        List list = xPathFilter2ParameterSpec.getXPathList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            XPathType xPathType = (XPathType)list.get(i);
            Element element = DOMUtils.createElement(this.ownerDoc, "XPath", "http://www.w3.org/2002/06/xmldsig-filter2", string2);
            element.appendChild(this.ownerDoc.createTextNode(xPathType.getExpression()));
            DOMUtils.setAttribute(element, "Filter", xPathType.getFilter().toString());
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", string3, "http://www.w3.org/2002/06/xmldsig-filter2");
            Iterator iterator = xPathType.getNamespaceMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)entry.getKey(), (String)entry.getValue());
            }
            this.transformElem.appendChild(element);
        }
    }
}

