/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server.glassfish;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.WebServiceEjbEndpointRegistry;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.webservice.monitoring.EndpointLifecycleListener;
import com.sun.enterprise.webservice.monitoring.WebServiceEngine;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineFactory;
import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.glassfish.WSEndpointDescriptor;
import com.sun.xml.ws.transport.tcp.server.glassfish.WSEndpointLifeCycleListener;
import com.sun.xml.ws.transport.tcp.server.glassfish.WSTCPAdapterRegistryImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AppServWSRegistry {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp.server");
    private static final AppServWSRegistry instance = new AppServWSRegistry();
    private final Map<String, Map<String, WSEndpointDescriptor>> registry = new HashMap<String, Map<String, WSEndpointDescriptor>>();

    public static AppServWSRegistry getInstance() {
        return instance;
    }

    private AppServWSRegistry() {
        WSEndpointLifeCycleListener lifecycleListener = new WSEndpointLifeCycleListener();
        WebServiceEngine engine = WebServiceEngineFactory.getInstance().getEngine();
        engine.addLifecycleListener((EndpointLifecycleListener)lifecycleListener);
        this.populateEndpoints(engine);
    }

    private void populateEndpoints(@NotNull WebServiceEngine engine) {
        Iterator endpoints = engine.getEndpoints();
        while (endpoints.hasNext()) {
            this.registerEndpoint((Endpoint)endpoints.next());
        }
    }

    @Nullable
    public WSEndpointDescriptor get(@NotNull String wsServiceName, @NotNull String endpointName) {
        Map<String, WSEndpointDescriptor> endpointMap = this.registry.get(wsServiceName);
        if (endpointMap != null) {
            return endpointMap.get(endpointName);
        }
        return null;
    }

    @NotNull
    public EjbRuntimeEndpointInfo getEjbRuntimeEndpointInfo(@NotNull String service, @NotNull String endpointName) {
        WSEndpointDescriptor wsEndpointDescriptor = this.get(service, endpointName);
        EjbRuntimeEndpointInfo endpointInfo = null;
        if (wsEndpointDescriptor.isEJB()) {
            endpointInfo = WebServiceEjbEndpointRegistry.getRegistry().getEjbWebServiceEndpoint(wsEndpointDescriptor.getURI(), "POST", null);
        }
        return endpointInfo;
    }

    protected void registerEndpoint(@NotNull Endpoint endpoint) {
        WebServiceEndpoint wsServiceDescriptor = endpoint.getDescriptor();
        if (wsServiceDescriptor != null && this.isTCPEnabled(wsServiceDescriptor)) {
            String contextRoot = this.getEndpointContextRoot(wsServiceDescriptor);
            String urlPattern = this.getEndpointUrlPattern(wsServiceDescriptor);
            String slashedContextRoot = this.ensureSlash(contextRoot);
            String slashedUrlPattern = this.ensureSlash(urlPattern);
            String path = slashedContextRoot + slashedUrlPattern;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1110_APP_SERV_REG_REGISTER_ENDPOINT(wsServiceDescriptor.getServiceName(), path, wsServiceDescriptor.implementedByEjbComponent()));
            }
            WSEndpointDescriptor descriptor = new WSEndpointDescriptor(wsServiceDescriptor, contextRoot, urlPattern, endpoint.getEndpointSelector());
            this.addToRegistry(slashedContextRoot, slashedUrlPattern, descriptor);
        }
    }

    protected void deregisterEndpoint(@NotNull Endpoint endpoint) {
        WebServiceEndpoint wsServiceDescriptor = endpoint.getDescriptor();
        String contextRoot = this.getEndpointContextRoot(wsServiceDescriptor);
        String urlPattern = this.getEndpointUrlPattern(wsServiceDescriptor);
        String slashedContextRoot = this.ensureSlash(contextRoot);
        String slashedUrlPattern = this.ensureSlash(urlPattern);
        String path = slashedContextRoot + slashedUrlPattern;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1111_APP_SERV_REG_DEREGISTER_ENDPOINT(wsServiceDescriptor.getWebService().getName(), path, wsServiceDescriptor.implementedByEjbComponent()));
        }
        this.removeFromRegistry(slashedContextRoot, slashedUrlPattern);
        WSTCPAdapterRegistryImpl.getInstance().deleteTargetFor(path);
    }

    private void addToRegistry(@NotNull String contextRoot, @NotNull String urlPattern, @NotNull WSEndpointDescriptor wsDescriptor) {
        contextRoot = this.ensureSlash(contextRoot);
        urlPattern = this.ensureSlash(urlPattern);
        Map<String, WSEndpointDescriptor> endpointMap = this.registry.get(contextRoot);
        if (endpointMap == null) {
            endpointMap = new HashMap<String, WSEndpointDescriptor>();
            this.registry.put(contextRoot, endpointMap);
        }
        endpointMap.put(urlPattern, wsDescriptor);
    }

    private WSEndpointDescriptor removeFromRegistry(@NotNull String wsServiceName, @NotNull String endpointName) {
        Map<String, WSEndpointDescriptor> endpointMap = this.registry.get(wsServiceName);
        if (endpointMap != null) {
            return endpointMap.remove(endpointName);
        }
        return null;
    }

    @NotNull
    private String getEndpointContextRoot(@NotNull WebServiceEndpoint wsServiceDescriptor) {
        String contextRoot;
        if (!wsServiceDescriptor.implementedByEjbComponent()) {
            contextRoot = wsServiceDescriptor.getWebComponentImpl().getWebBundleDescriptor().getContextRoot();
            logger.log(Level.FINE, MessagesMessages.WSTCP_1112_APP_SERV_REG_GET_ENDP_CR_NON_EJB(contextRoot));
        } else {
            String[] path = wsServiceDescriptor.getEndpointAddressUri().split("/");
            contextRoot = "/" + path[1];
            logger.log(Level.FINE, MessagesMessages.WSTCP_1113_APP_SERV_REG_GET_ENDP_CR_EJB(contextRoot));
        }
        return contextRoot;
    }

    @NotNull
    private String getEndpointUrlPattern(@NotNull WebServiceEndpoint wsServiceDescriptor) {
        String urlPattern;
        if (!wsServiceDescriptor.implementedByEjbComponent()) {
            urlPattern = wsServiceDescriptor.getEndpointAddressUri();
            logger.log(Level.FINE, MessagesMessages.WSTCP_1114_APP_SERV_REG_GET_ENDP_URL_PATTERN_NON_EJB(urlPattern));
        } else {
            String[] path = wsServiceDescriptor.getEndpointAddressUri().split("/");
            if (path.length < 3) {
                return "";
            }
            urlPattern = "/" + path[2];
            logger.log(Level.FINE, MessagesMessages.WSTCP_1115_APP_SERV_REG_GET_ENDP_URL_PATTERN_EJB(urlPattern));
        }
        return urlPattern;
    }

    @Nullable
    private String ensureSlash(@Nullable String s) {
        if (s != null && s.length() > 0 && s.charAt(0) != '/') {
            return "/" + s;
        }
        return s;
    }

    private boolean isTCPEnabled(WebServiceEndpoint webServiceDesc) {
        return true;
    }
}

