/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust;

import com.sun.xml.ws.api.security.trust.STSAttributeProvider;
import com.sun.xml.ws.api.security.trust.STSAuthorizationProvider;
import com.sun.xml.ws.api.security.trust.WSTrustContract;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.config.STSConfiguration;
import com.sun.xml.ws.api.security.trust.config.STSConfigurationProvider;
import com.sun.xml.ws.security.trust.Configuration;
import com.sun.xml.ws.security.trust.TrustPlugin;
import com.sun.xml.ws.security.trust.WSTrustClientContract;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.impl.DefaultSTSAttributeProvider;
import com.sun.xml.ws.security.trust.impl.DefaultSTSAuthorizationProvider;
import com.sun.xml.ws.security.trust.impl.TrustPluginImpl;
import com.sun.xml.ws.security.trust.impl.WSTrustClientContractImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.util.ServiceFinder;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTrustFactory {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");

    public static TrustPlugin newTrustPlugin(Configuration config) {
        return new TrustPluginImpl(config);
    }

    public static WSTrustContract<RequestSecurityToken, RequestSecurityTokenResponse> newWSTrustContract(STSConfiguration config, String appliesTo) throws WSTrustException {
        String type = config.getType();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WST_1002_PROVIDER_TYPE(type));
        }
        WSTrustContract contract = null;
        try {
            Class<?> clazz = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            clazz = loader == null ? Class.forName(type) : loader.loadClass(type);
            if (clazz != null) {
                contract = (WSTrustContract)clazz.newInstance();
                contract.init(config);
            }
        }
        catch (ClassNotFoundException ex) {
            contract = null;
            log.log(Level.SEVERE, LogStringsMessages.WST_0005_CLASSNOTFOUND_NULL_CONTRACT(type), ex);
            throw new WSTrustException(LogStringsMessages.WST_0005_CLASSNOTFOUND_NULL_CONTRACT(type), ex);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0038_INIT_CONTRACT_FAIL(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0038_INIT_CONTRACT_FAIL(), ex);
        }
        return contract;
    }

    public static WSTrustClientContract createWSTrustClientContract(Configuration config) {
        return new WSTrustClientContractImpl(config);
    }

    public static STSAuthorizationProvider getSTSAuthorizationProvider() {
        STSAuthorizationProvider authzProvider = null;
        ServiceFinder<STSAuthorizationProvider> finder = ServiceFinder.find(STSAuthorizationProvider.class);
        authzProvider = finder != null && finder.toArray().length > 0 ? finder.toArray()[0] : new DefaultSTSAuthorizationProvider();
        return authzProvider;
    }

    public static STSAttributeProvider getSTSAttributeProvider() {
        STSAttributeProvider attrProvider = null;
        ServiceFinder<STSAttributeProvider> finder = ServiceFinder.find(STSAttributeProvider.class);
        attrProvider = finder != null && finder.toArray().length > 0 ? finder.toArray()[0] : new DefaultSTSAttributeProvider();
        return attrProvider;
    }

    public static STSConfiguration getRuntimeSTSConfiguration() {
        STSConfigurationProvider configProvider = null;
        ServiceFinder<STSConfigurationProvider> finder = ServiceFinder.find(STSConfigurationProvider.class);
        if (finder != null && finder.toArray().length > 0) {
            configProvider = finder.toArray()[0];
        }
        if (configProvider != null) {
            return configProvider.getSTSConfiguration();
        }
        return null;
    }

    private WSTrustFactory() {
    }
}

