/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.wss.impl.policy.mls.Parameter;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import javax.xml.namespace.QName;

public class SignatureTargetCreator {
    private boolean enforce = false;
    private AlgorithmSuite algorithmSuite = null;
    private boolean contentOnly = false;

    public SignatureTargetCreator(boolean enforce, AlgorithmSuite algorithmSuite, boolean contentOnly) {
        this.enforce = enforce;
        this.algorithmSuite = algorithmSuite;
    }

    public SignatureTarget newURISignatureTarget(String uid) {
        if (uid != null) {
            SignatureTarget target = new SignatureTarget();
            target.setType("uri");
            target.setDigestAlgorithm(this.algorithmSuite.getDigestAlgorithm());
            target.setValue("#" + uid);
            this.addEXC14n(target);
            target.setEnforce(this.enforce);
            return target;
        }
        return null;
    }

    public SignatureTarget newXpathSignatureTarget(String xpathTarget) {
        SignatureTarget target = new SignatureTarget();
        target.setType("xpath");
        target.setDigestAlgorithm(this.algorithmSuite.getDigestAlgorithm());
        this.addEXC14n(target);
        target.setValue(xpathTarget);
        target.setContentOnly(this.contentOnly);
        target.setEnforce(this.enforce);
        return target;
    }

    public SignatureTarget newQNameSignatureTarget(QName name) {
        SignatureTarget target = new SignatureTarget();
        target.setType("qname");
        target.setDigestAlgorithm(this.algorithmSuite.getDigestAlgorithm());
        target.setContentOnly(this.contentOnly);
        target.setEnforce(this.enforce);
        target.setQName(name);
        this.addEXC14n(target);
        return target;
    }

    public void addEXC14n(SignatureTarget target) {
        SignatureTarget.Transform tr = target.newSignatureTransform();
        if (this.algorithmSuite != null && this.algorithmSuite.getAdditionalProps().contains("InclusiveC14N")) {
            tr.setTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        } else {
            tr.setTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        if (this.algorithmSuite != null && this.algorithmSuite.getAdditionalProps().contains("InclusiveC14NWithCommentsForTransforms")) {
            tr.setTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        } else if (this.algorithmSuite != null && this.algorithmSuite.getAdditionalProps().contains("ExclusiveC14NWithCommentsForTransforms")) {
            tr.setTransform("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        }
        target.addTransform(tr);
    }

    public void addSTRTransform(SignatureTarget target) {
        SignatureTarget.Transform tr = target.newSignatureTransform();
        tr.setTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform");
        target.addTransform(tr);
        tr.setAlgorithmParameters(new Parameter("CanonicalizationMethod", "http://www.w3.org/2001/10/xml-exc-c14n#"));
    }
}

