/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy;

import com.sun.xml.ws.policy.PolicyMapKeyHandler;
import com.sun.xml.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import javax.xml.namespace.QName;

public final class PolicyMapKey {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyMapKey.class);
    QName service;
    QName port;
    QName operation;
    QName faultMessage;
    private PolicyMapKeyHandler handler;

    PolicyMapKey(QName service, QName port, QName operation) {
        this.service = service;
        this.port = port;
        this.operation = operation;
    }

    PolicyMapKey(QName service, QName port, QName operation, QName faultMessage) {
        this.service = service;
        this.port = port;
        this.operation = operation;
        this.faultMessage = faultMessage;
    }

    PolicyMapKey(PolicyMapKey that) {
        this.service = that.service;
        this.port = that.port;
        this.operation = that.operation;
        this.faultMessage = that.faultMessage;
        this.handler = that.handler;
    }

    void setHandler(PolicyMapKeyHandler handler) {
        this.handler = handler;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.handler == null) {
            throw LOGGER.logSevereException(new IllegalStateException(LocalizationMessages.WSP_0046_POLICY_MAP_KEY_HANDLER_NOT_SET()));
        }
        if (that instanceof PolicyMapKey) {
            return this.handler.areEqual(this, (PolicyMapKey)that);
        }
        return false;
    }

    public int hashCode() {
        if (this.handler == null) {
            throw LOGGER.logSevereException(new IllegalStateException(LocalizationMessages.WSP_0046_POLICY_MAP_KEY_HANDLER_NOT_SET()));
        }
        return this.handler.generateHashCode(this);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("WsdlPolicyMapKey(");
        result.append(this.service).append(", ").append(this.port).append(", ").append(this.operation).append(", ").append(this.faultMessage);
        return result.append(")").toString();
    }
}

