/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.encryption;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.encryption.AgreementMethod;
import com.sun.org.apache.xml.internal.security.encryption.CipherData;
import com.sun.org.apache.xml.internal.security.encryption.CipherReference;
import com.sun.org.apache.xml.internal.security.encryption.CipherValue;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedData;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.EncryptionMethod;
import com.sun.org.apache.xml.internal.security.encryption.EncryptionProperties;
import com.sun.org.apache.xml.internal.security.encryption.EncryptionProperty;
import com.sun.org.apache.xml.internal.security.encryption.Reference;
import com.sun.org.apache.xml.internal.security.encryption.ReferenceList;
import com.sun.org.apache.xml.internal.security.encryption.Transforms;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipherInput;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.EncryptedKeyResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.utils.URI;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLCipher {
    private static Logger logger = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher == null ? (class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher = XMLCipher.class$("com.sun.org.apache.xml.internal.security.encryption.XMLCipher")) : class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher).getName());
    public static final String TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES_128 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES_256 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String AES_192 = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String RSA_v1dot5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String RSA_OAEP = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    public static final String DIFFIE_HELLMAN = "http://www.w3.org/2001/04/xmlenc#dh";
    public static final String TRIPLEDES_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String AES_128_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String AES_256_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    public static final String AES_192_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String RIPEMD_160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    public static final String XML_DSIG = "http://www.w3.org/2000/09/xmldsig#";
    public static final String N14C_XML = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String N14C_XML_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String EXCL_XML_N14C = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String EXCL_XML_N14C_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String BASE64_ENCODING = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int UNWRAP_MODE = 4;
    public static final int WRAP_MODE = 3;
    private static final String ENC_ALGORITHMS = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n";
    private Cipher _contextCipher;
    private int _cipherMode = Integer.MIN_VALUE;
    private String _algorithm = null;
    private String _requestedJCEProvider = null;
    private Canonicalizer _canon;
    private Document _contextDocument;
    private Factory _factory;
    private Serializer _serializer;
    private Key _key;
    private Key _kek;
    private EncryptedKey _ek;
    private EncryptedData _ed;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher$Factory$ReferenceListImpl$DataReference;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher$Factory$ReferenceListImpl$KeyReference;

    private XMLCipher() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Constructing XMLCipher...");
        }
        this._factory = new Factory();
        this._serializer = new Serializer();
    }

    private static boolean isValidEncryptionAlgorithm(String string2) {
        boolean bl = string2.equals(TRIPLEDES) || string2.equals(AES_128) || string2.equals(AES_256) || string2.equals(AES_192) || string2.equals(RSA_v1dot5) || string2.equals(RSA_OAEP) || string2.equals(TRIPLEDES_KeyWrap) || string2.equals(AES_128_KeyWrap) || string2.equals(AES_256_KeyWrap) || string2.equals(AES_192_KeyWrap);
        return bl;
    }

    public static XMLCipher getInstance(String string2) throws XMLEncryptionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Getting XMLCipher...");
        }
        if (null == string2) {
            logger.log(Level.SEVERE, "Transformation unexpectedly null...");
        }
        if (!XMLCipher.isValidEncryptionAlgorithm(string2)) {
            logger.log(Level.WARNING, "Algorithm non-standard, expected one of http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n");
        }
        XMLCipher xMLCipher = new XMLCipher();
        xMLCipher._algorithm = string2;
        xMLCipher._key = null;
        xMLCipher._kek = null;
        try {
            xMLCipher._canon = Canonicalizer.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLEncryptionException("empty", invalidCanonicalizerException);
        }
        String string3 = JCEMapper.translateURItoJCEID(string2);
        try {
            xMLCipher._contextCipher = Cipher.getInstance(string3);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cihper.algoritm = " + xMLCipher._contextCipher.getAlgorithm());
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException("empty", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLEncryptionException("empty", noSuchPaddingException);
        }
        return xMLCipher;
    }

    public static XMLCipher getInstance(String string2, Cipher cipher) throws XMLEncryptionException {
        logger.log(Level.FINE, "Getting XMLCipher...");
        if (null == string2) {
            logger.log(Level.SEVERE, "Transformation unexpectedly null...");
        }
        if (!XMLCipher.isValidEncryptionAlgorithm(string2)) {
            logger.log(Level.WARNING, "Algorithm non-standard, expected one of http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n");
        }
        XMLCipher xMLCipher = new XMLCipher();
        xMLCipher._algorithm = string2;
        xMLCipher._key = null;
        xMLCipher._kek = null;
        try {
            xMLCipher._canon = Canonicalizer.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLEncryptionException("empty", invalidCanonicalizerException);
        }
        String string3 = JCEMapper.translateURItoJCEID(string2);
        try {
            xMLCipher._contextCipher = cipher;
            logger.log(Level.FINE, "cihper.algoritm = " + xMLCipher._contextCipher.getAlgorithm());
        }
        catch (Exception exception) {
            throw new XMLEncryptionException("empty", exception);
        }
        return xMLCipher;
    }

    public static XMLCipher getInstance(String string2, String string3) throws XMLEncryptionException {
        XMLCipher xMLCipher = XMLCipher.getInstance(string2);
        if (string3 != null) {
            try {
                xMLCipher._canon = Canonicalizer.getInstance(string3);
            }
            catch (InvalidCanonicalizerException invalidCanonicalizerException) {
                throw new XMLEncryptionException("empty", invalidCanonicalizerException);
            }
        }
        return xMLCipher;
    }

    public static XMLCipher getProviderInstance(String string2, String string3) throws XMLEncryptionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Getting XMLCipher...");
        }
        if (null == string2) {
            logger.log(Level.SEVERE, "Transformation unexpectedly null...");
        }
        if (null == string3) {
            logger.log(Level.SEVERE, "Provider unexpectedly null..");
        }
        if ("" == string3) {
            logger.log(Level.SEVERE, "Provider's value unexpectedly not specified...");
        }
        if (!XMLCipher.isValidEncryptionAlgorithm(string2)) {
            logger.log(Level.WARNING, "Algorithm non-standard, expected one of http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n");
        }
        XMLCipher xMLCipher = new XMLCipher();
        xMLCipher._algorithm = string2;
        xMLCipher._requestedJCEProvider = string3;
        xMLCipher._key = null;
        xMLCipher._kek = null;
        try {
            xMLCipher._canon = Canonicalizer.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLEncryptionException("empty", invalidCanonicalizerException);
        }
        try {
            String string4 = JCEMapper.translateURItoJCEID(string2);
            xMLCipher._contextCipher = Cipher.getInstance(string4, string3);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cipher._algorithm = " + xMLCipher._contextCipher.getAlgorithm());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "provider.name = " + string3);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLEncryptionException("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLEncryptionException("empty", noSuchPaddingException);
        }
        return xMLCipher;
    }

    public static XMLCipher getProviderInstance(String string2, String string3, String string4) throws XMLEncryptionException {
        XMLCipher xMLCipher = XMLCipher.getProviderInstance(string2, string3);
        if (string4 != null) {
            try {
                xMLCipher._canon = Canonicalizer.getInstance(string4);
            }
            catch (InvalidCanonicalizerException invalidCanonicalizerException) {
                throw new XMLEncryptionException("empty", invalidCanonicalizerException);
            }
        }
        return xMLCipher;
    }

    public static XMLCipher getInstance() throws XMLEncryptionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Getting XMLCipher for no transformation...");
        }
        XMLCipher xMLCipher = new XMLCipher();
        xMLCipher._algorithm = null;
        xMLCipher._requestedJCEProvider = null;
        xMLCipher._key = null;
        xMLCipher._kek = null;
        xMLCipher._contextCipher = null;
        try {
            xMLCipher._canon = Canonicalizer.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLEncryptionException("empty", invalidCanonicalizerException);
        }
        return xMLCipher;
    }

    public static XMLCipher getProviderInstance(String string2) throws XMLEncryptionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Getting XMLCipher, provider but no transformation");
        }
        if (null == string2) {
            logger.log(Level.SEVERE, "Provider unexpectedly null..");
        }
        if ("" == string2) {
            logger.log(Level.SEVERE, "Provider's value unexpectedly not specified...");
        }
        XMLCipher xMLCipher = new XMLCipher();
        xMLCipher._algorithm = null;
        xMLCipher._requestedJCEProvider = string2;
        xMLCipher._key = null;
        xMLCipher._kek = null;
        xMLCipher._contextCipher = null;
        try {
            xMLCipher._canon = Canonicalizer.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLEncryptionException("empty", invalidCanonicalizerException);
        }
        return xMLCipher;
    }

    public void init(int n, Key key) throws XMLEncryptionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Initializing XMLCipher...");
        }
        this._ek = null;
        this._ed = null;
        switch (n) {
            case 1: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "opmode = ENCRYPT_MODE");
                }
                this._ed = this.createEncryptedData(1, "NO VALUE YET");
                break;
            }
            case 2: {
                if (!logger.isLoggable(Level.FINE)) break;
                logger.log(Level.FINE, "opmode = DECRYPT_MODE");
                break;
            }
            case 3: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "opmode = WRAP_MODE");
                }
                this._ek = this.createEncryptedKey(1, "NO VALUE YET");
                break;
            }
            case 4: {
                if (!logger.isLoggable(Level.FINE)) break;
                logger.log(Level.FINE, "opmode = UNWRAP_MODE");
                break;
            }
            default: {
                logger.log(Level.SEVERE, "Mode unexpectedly invalid");
                throw new XMLEncryptionException("Invalid mode in init");
            }
        }
        this._cipherMode = n;
        this._key = key;
    }

    public EncryptedData getEncryptedData() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Returning EncryptedData");
        }
        return this._ed;
    }

    public EncryptedKey getEncryptedKey() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Returning EncryptedKey");
        }
        return this._ek;
    }

    public void setKEK(Key key) {
        this._kek = key;
    }

    public Element martial(EncryptedData encryptedData) {
        return this._factory.toElement(encryptedData);
    }

    public Element martial(EncryptedKey encryptedKey) {
        return this._factory.toElement(encryptedKey);
    }

    public Element martial(Document document, EncryptedData encryptedData) {
        this._contextDocument = document;
        return this._factory.toElement(encryptedData);
    }

    public Element martial(Document document, EncryptedKey encryptedKey) {
        this._contextDocument = document;
        return this._factory.toElement(encryptedKey);
    }

    private Document encryptElement(Element element) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Encrypting element...");
        }
        if (null == element) {
            logger.log(Level.SEVERE, "Element unexpectedly null...");
        }
        if (this._cipherMode != 1 && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        if (this._algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        this.encryptData(this._contextDocument, element, false);
        Element element2 = this._factory.toElement(this._ed);
        Node node = element.getParentNode();
        node.replaceChild(element2, element);
        return this._contextDocument;
    }

    private Document encryptElementContent(Element element) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Encrypting element content...");
        }
        if (null == element) {
            logger.log(Level.SEVERE, "Element unexpectedly null...");
        }
        if (this._cipherMode != 1 && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        if (this._algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        this.encryptData(this._contextDocument, element, true);
        Element element2 = this._factory.toElement(this._ed);
        this.removeContent(element);
        element.appendChild(element2);
        return this._contextDocument;
    }

    public Document doFinal(Document document, Document document2) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Processing source document...");
        }
        if (null == document) {
            logger.log(Level.SEVERE, "Context document unexpectedly null...");
        }
        if (null == document2) {
            logger.log(Level.SEVERE, "Source document unexpectedly null...");
        }
        this._contextDocument = document;
        Document document3 = null;
        switch (this._cipherMode) {
            case 2: {
                document3 = this.decryptElement(document2.getDocumentElement());
                break;
            }
            case 1: {
                document3 = this.encryptElement(document2.getDocumentElement());
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return document3;
    }

    public Document doFinal(Document document, Element element) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Processing source element...");
        }
        if (null == document) {
            logger.log(Level.SEVERE, "Context document unexpectedly null...");
        }
        if (null == element) {
            logger.log(Level.SEVERE, "Source element unexpectedly null...");
        }
        this._contextDocument = document;
        Document document2 = null;
        switch (this._cipherMode) {
            case 2: {
                document2 = this.decryptElement(element);
                break;
            }
            case 1: {
                document2 = this.encryptElement(element);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return document2;
    }

    public Document doFinal(Document document, Element element, boolean bl) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Processing source element...");
        }
        if (null == document) {
            logger.log(Level.SEVERE, "Context document unexpectedly null...");
        }
        if (null == element) {
            logger.log(Level.SEVERE, "Source element unexpectedly null...");
        }
        this._contextDocument = document;
        Document document2 = null;
        switch (this._cipherMode) {
            case 2: {
                if (bl) {
                    document2 = this.decryptElementContent(element);
                    break;
                }
                document2 = this.decryptElement(element);
                break;
            }
            case 1: {
                if (bl) {
                    document2 = this.encryptElementContent(element);
                    break;
                }
                document2 = this.encryptElement(element);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return document2;
    }

    public EncryptedData encryptData(Document document, Element element) throws Exception {
        return this.encryptData(document, element, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EncryptedData encryptData(Document document, Element element, boolean bl) throws Exception {
        Cipher cipher;
        Object object;
        Object object2;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Encrypting element...");
        }
        if (null == document) {
            logger.log(Level.SEVERE, "Context document unexpectedly null...");
        }
        if (null == element) {
            logger.log(Level.SEVERE, "Element unexpectedly null...");
        }
        if (this._cipherMode != 1 && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        this._contextDocument = document;
        if (this._algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        String string2 = null;
        if (bl) {
            object2 = element.getChildNodes();
            if (null == object2) {
                Object[] objectArray = new Object[]{"Element has no content."};
                throw new XMLEncryptionException("empty", objectArray);
            }
            string2 = this._serializer.serialize((NodeList)object2);
        } else {
            string2 = this._serializer.serialize(element);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Serialized octets:\n" + string2);
        }
        object2 = null;
        if (this._contextCipher == null) {
            object = JCEMapper.translateURItoJCEID(this._algorithm);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "alg = " + (String)object);
            }
            try {
                if (this._requestedJCEProvider == null) {
                    cipher = Cipher.getInstance((String)object);
                }
                cipher = Cipher.getInstance((String)object, this._requestedJCEProvider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLEncryptionException("empty", noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new XMLEncryptionException("empty", noSuchProviderException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new XMLEncryptionException("empty", noSuchPaddingException);
            }
        } else {
            cipher = this._contextCipher;
        }
        try {
            cipher.init(this._cipherMode, this._key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("empty", invalidKeyException);
        }
        try {
            object2 = cipher.doFinal(string2.getBytes("UTF-8"));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Expected cipher.outputSize = " + Integer.toString(cipher.getOutputSize(string2.getBytes().length)));
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Actual cipher.outputSize = " + Integer.toString(((Object)object2).length));
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLEncryptionException("empty", illegalStateException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLEncryptionException("empty", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new XMLEncryptionException("empty", badPaddingException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XMLEncryptionException("empty", unsupportedEncodingException);
        }
        object = cipher.getIV();
        byte[] byArray = new byte[((Object)object).length + ((Object)object2).length];
        System.arraycopy(object, 0, byArray, 0, ((Object)object).length);
        System.arraycopy(object2, 0, byArray, ((Object)object).length, ((Object)object2).length);
        String string3 = Base64.encode(byArray);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Encrypted octets:\n" + string3);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Encrypted octets length = " + string3.length());
        }
        try {
            CipherData cipherData = this._ed.getCipherData();
            CipherValue cipherValue = cipherData.getCipherValue();
            cipherValue.setValue(string3);
            if (bl) {
                this._ed.setType(new URI("http://www.w3.org/2001/04/xmlenc#Content").toString());
            } else {
                this._ed.setType(new URI("http://www.w3.org/2001/04/xmlenc#Element").toString());
            }
            EncryptionMethod encryptionMethod = this._factory.newEncryptionMethod(new URI(this._algorithm).toString());
            this._ed.setEncryptionMethod(encryptionMethod);
            return this._ed;
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new XMLEncryptionException("empty", malformedURIException);
        }
    }

    public EncryptedData encryptData(Document document, byte[] byArray, boolean bl) throws Exception {
        Cipher cipher;
        Object object;
        logger.log(Level.FINE, "Encrypting element...");
        if (null == document) {
            logger.log(Level.SEVERE, "Context document unexpectedly null...");
        }
        if (null == byArray) {
            logger.log(Level.SEVERE, "Canonicalized Data is unexpectedly null...");
        }
        if (this._cipherMode != 1) {
            logger.log(Level.FINE, "XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        this._contextDocument = document;
        if (this._algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        logger.log(Level.FINE, "Serialized octets:\n" + byArray);
        byte[] byArray2 = null;
        if (this._contextCipher == null) {
            object = JCEMapper.translateURItoJCEID(this._algorithm);
            logger.log(Level.FINE, "alg = " + (String)object);
            try {
                if (this._requestedJCEProvider == null) {
                    cipher = Cipher.getInstance((String)object);
                }
                cipher = Cipher.getInstance((String)object, this._requestedJCEProvider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLEncryptionException("empty", noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new XMLEncryptionException("empty", noSuchProviderException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new XMLEncryptionException("empty", noSuchPaddingException);
            }
        } else {
            cipher = this._contextCipher;
        }
        try {
            cipher.init(this._cipherMode, this._key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("empty", invalidKeyException);
        }
        try {
            byArray2 = cipher.doFinal(byArray);
            logger.log(Level.FINE, "Expected cipher.outputSize = " + Integer.toString(cipher.getOutputSize(byArray.length)));
            logger.log(Level.FINE, "Actual cipher.outputSize = " + Integer.toString(byArray2.length));
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLEncryptionException("empty", illegalStateException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLEncryptionException("empty", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new XMLEncryptionException("empty", badPaddingException);
        }
        catch (Exception exception) {
            throw new XMLEncryptionException("empty", exception);
        }
        object = cipher.getIV();
        byte[] byArray3 = new byte[((Object)object).length + byArray2.length];
        System.arraycopy(object, 0, byArray3, 0, ((Object)object).length);
        System.arraycopy(byArray2, 0, byArray3, ((Object)object).length, byArray2.length);
        String string2 = Base64.encode(byArray3);
        logger.log(Level.FINE, "Encrypted octets:\n" + string2);
        logger.log(Level.FINE, "Encrypted octets length = " + string2.length());
        try {
            CipherData cipherData = this._ed.getCipherData();
            CipherValue cipherValue = cipherData.getCipherValue();
            cipherValue.setValue(string2);
            if (bl) {
                this._ed.setType(new URI("http://www.w3.org/2001/04/xmlenc#Content").toString());
            } else {
                this._ed.setType(new URI("http://www.w3.org/2001/04/xmlenc#Element").toString());
            }
            EncryptionMethod encryptionMethod = this._factory.newEncryptionMethod(new URI(this._algorithm).toString());
            this._ed.setEncryptionMethod(encryptionMethod);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new XMLEncryptionException("empty", malformedURIException);
        }
        return this._ed;
    }

    public EncryptedData loadEncryptedData(Document document, Element element) throws XMLEncryptionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Loading encrypted element...");
        }
        if (null == document) {
            logger.log(Level.SEVERE, "Context document unexpectedly null...");
        }
        if (null == element) {
            logger.log(Level.SEVERE, "Element unexpectedly null...");
        }
        if (this._cipherMode != 2) {
            logger.log(Level.SEVERE, "XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        this._contextDocument = document;
        this._ed = this._factory.newEncryptedData(element);
        return this._ed;
    }

    public EncryptedKey loadEncryptedKey(Document document, Element element) throws XMLEncryptionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Loading encrypted key...");
        }
        if (null == document) {
            logger.log(Level.SEVERE, "Context document unexpectedly null...");
        }
        if (null == element) {
            logger.log(Level.SEVERE, "Element unexpectedly null...");
        }
        if (this._cipherMode != 4 && this._cipherMode != 2 && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "XMLCipher unexpectedly not in UNWRAP_MODE or DECRYPT_MODE...");
        }
        this._contextDocument = document;
        this._ek = this._factory.newEncryptedKey(element);
        return this._ek;
    }

    public EncryptedKey loadEncryptedKey(Element element) throws XMLEncryptionException {
        return this.loadEncryptedKey(element.getOwnerDocument(), element);
    }

    public EncryptedKey encryptKey(Document document, Key key) throws XMLEncryptionException {
        Cipher cipher;
        String string2;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Encrypting key ...");
        }
        if (null == key) {
            logger.log(Level.SEVERE, "Key unexpectedly null...");
        }
        if (this._cipherMode != 3 && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "XMLCipher unexpectedly not in WRAP_MODE...");
        }
        if (this._algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        this._contextDocument = document;
        byte[] byArray = null;
        if (this._contextCipher == null) {
            string2 = JCEMapper.translateURItoJCEID(this._algorithm);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "alg = " + string2);
            }
            try {
                if (this._requestedJCEProvider == null) {
                    cipher = Cipher.getInstance(string2);
                }
                cipher = Cipher.getInstance(string2, this._requestedJCEProvider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLEncryptionException("empty", noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new XMLEncryptionException("empty", noSuchProviderException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new XMLEncryptionException("empty", noSuchPaddingException);
            }
        } else {
            cipher = this._contextCipher;
        }
        try {
            cipher.init(3, this._key);
            byArray = cipher.wrap(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("empty", invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLEncryptionException("empty", illegalBlockSizeException);
        }
        string2 = Base64.encode(byArray);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Encrypted key octets:\n" + string2);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Encrypted key octets length = " + string2.length());
        }
        CipherValue cipherValue = this._ek.getCipherData().getCipherValue();
        cipherValue.setValue(string2);
        try {
            EncryptionMethod encryptionMethod = this._factory.newEncryptionMethod(new URI(this._algorithm).toString());
            this._ek.setEncryptionMethod(encryptionMethod);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new XMLEncryptionException("empty", malformedURIException);
        }
        return this._ek;
    }

    public Key decryptKey(EncryptedKey encryptedKey, String string2) throws XMLEncryptionException {
        Cipher cipher;
        Object object;
        Object object2;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Decrypting key from previously loaded EncryptedKey...");
        }
        if (this._cipherMode != 4 && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "XMLCipher unexpectedly not in UNWRAP_MODE...");
        }
        if (string2 == null) {
            throw new XMLEncryptionException("Cannot decrypt a key without knowing the algorithm");
        }
        if (this._key == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Trying to find a KEK via key resolvers");
            }
            if ((object2 = encryptedKey.getKeyInfo()) != null) {
                try {
                    this._key = ((KeyInfo)object2).getSecretKey();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this._key == null) {
                logger.log(Level.SEVERE, "XMLCipher::decryptKey called without a KEK and cannot resolve");
                throw new XMLEncryptionException("Unable to decrypt without a KEK");
            }
        }
        object2 = new XMLCipherInput(encryptedKey);
        byte[] byArray = ((XMLCipherInput)object2).getBytes();
        String string3 = JCEMapper.getJCEKeyAlgorithmFromURI(string2);
        if (this._contextCipher == null) {
            object = JCEMapper.translateURItoJCEID(encryptedKey.getEncryptionMethod().getAlgorithm());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JCE Algorithm = " + (String)object);
            }
            try {
                if (this._requestedJCEProvider == null) {
                    cipher = Cipher.getInstance((String)object);
                }
                cipher = Cipher.getInstance((String)object, this._requestedJCEProvider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLEncryptionException("empty", noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new XMLEncryptionException("empty", noSuchProviderException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new XMLEncryptionException("empty", noSuchPaddingException);
            }
        } else {
            cipher = this._contextCipher;
        }
        try {
            cipher.init(4, this._key);
            object = cipher.unwrap(byArray, string3, 3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("empty", invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException("empty", noSuchAlgorithmException);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Decryption of key type " + string2 + " OK");
        }
        return object;
    }

    public Key decryptKey(EncryptedKey encryptedKey) throws XMLEncryptionException {
        return this.decryptKey(encryptedKey, this._ed.getEncryptionMethod().getAlgorithm());
    }

    private void removeContent(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() > 0) {
            Node node2 = nodeList.item(0);
            if (null != node2) {
                node2.getParentNode().removeChild(node2);
            }
            this.removeContent(node);
        }
    }

    private Document decryptElement(Element element) throws XMLEncryptionException {
        String string2;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Decrypting element...");
        }
        if (this._cipherMode != 2) {
            logger.log(Level.SEVERE, "XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        try {
            string2 = new String(this.decryptToByteArray(element), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XMLEncryptionException("empty", unsupportedEncodingException);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Decrypted octets:\n" + string2);
        }
        Node node = element.getParentNode();
        DocumentFragment documentFragment = this._serializer.deserialize(string2, node);
        if (node instanceof Document) {
            this._contextDocument.removeChild(this._contextDocument.getDocumentElement());
            this._contextDocument.appendChild(documentFragment);
        } else {
            node.replaceChild(documentFragment, element);
        }
        return this._contextDocument;
    }

    private Document decryptElementContent(Element element) throws XMLEncryptionException {
        Element element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
        if (null == element2) {
            throw new XMLEncryptionException("No EncryptedData child element.");
        }
        return this.decryptElement(element2);
    }

    public byte[] decryptToByteArray(Element element) throws XMLEncryptionException {
        byte[] byArray;
        Cipher cipher;
        Object object;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Decrypting to ByteArray...");
        }
        if (this._cipherMode != 2) {
            logger.log(Level.SEVERE, "XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        EncryptedData encryptedData = this._factory.newEncryptedData(element);
        if (this._key == null) {
            object = encryptedData.getKeyInfo();
            if (object != null) {
                try {
                    ((KeyInfo)object).registerInternalKeyResolver(new EncryptedKeyResolver(encryptedData.getEncryptionMethod().getAlgorithm(), this._kek));
                    this._key = ((KeyInfo)object).getSecretKey();
                }
                catch (KeyResolverException keyResolverException) {
                    // empty catch block
                }
            }
            if (this._key == null) {
                logger.log(Level.SEVERE, "XMLCipher::decryptElement called without a key and unable to resolve");
                throw new XMLEncryptionException("encryption.nokey");
            }
        }
        object = new XMLCipherInput(encryptedData);
        byte[] byArray2 = ((XMLCipherInput)object).getBytes();
        String string2 = JCEMapper.translateURItoJCEID(encryptedData.getEncryptionMethod().getAlgorithm());
        try {
            cipher = this._requestedJCEProvider == null ? Cipher.getInstance(string2) : Cipher.getInstance(string2, this._requestedJCEProvider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLEncryptionException("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLEncryptionException("empty", noSuchPaddingException);
        }
        int n = cipher.getBlockSize();
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
        try {
            cipher.init(this._cipherMode, this._key, ivParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("empty", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException("empty", invalidAlgorithmParameterException);
        }
        try {
            byArray = cipher.doFinal(byArray2, n, byArray2.length - n);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLEncryptionException("empty", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new XMLEncryptionException("empty", badPaddingException);
        }
        return byArray;
    }

    public EncryptedData createEncryptedData(int n, String string2) throws XMLEncryptionException {
        EncryptedData encryptedData = null;
        CipherData cipherData = null;
        switch (n) {
            case 2: {
                CipherReference cipherReference = this._factory.newCipherReference(string2);
                cipherData = this._factory.newCipherData(n);
                cipherData.setCipherReference(cipherReference);
                encryptedData = this._factory.newEncryptedData(cipherData);
                break;
            }
            case 1: {
                CipherValue cipherValue = this._factory.newCipherValue(string2);
                cipherData = this._factory.newCipherData(n);
                cipherData.setCipherValue(cipherValue);
                encryptedData = this._factory.newEncryptedData(cipherData);
            }
        }
        return encryptedData;
    }

    public EncryptedKey createEncryptedKey(int n, String string2) throws XMLEncryptionException {
        EncryptedKey encryptedKey = null;
        CipherData cipherData = null;
        switch (n) {
            case 2: {
                CipherReference cipherReference = this._factory.newCipherReference(string2);
                cipherData = this._factory.newCipherData(n);
                cipherData.setCipherReference(cipherReference);
                encryptedKey = this._factory.newEncryptedKey(cipherData);
                break;
            }
            case 1: {
                CipherValue cipherValue = this._factory.newCipherValue(string2);
                cipherData = this._factory.newCipherData(n);
                cipherData.setCipherValue(cipherValue);
                encryptedKey = this._factory.newEncryptedKey(cipherData);
            }
        }
        return encryptedKey;
    }

    public AgreementMethod createAgreementMethod(String string2) {
        return this._factory.newAgreementMethod(string2);
    }

    public CipherData createCipherData(int n) {
        return this._factory.newCipherData(n);
    }

    public CipherReference createCipherReference(String string2) {
        return this._factory.newCipherReference(string2);
    }

    public CipherValue createCipherValue(String string2) {
        return this._factory.newCipherValue(string2);
    }

    public EncryptionMethod createEncryptionMethod(String string2) {
        return this._factory.newEncryptionMethod(string2);
    }

    public EncryptionProperties createEncryptionProperties() {
        return this._factory.newEncryptionProperties();
    }

    public EncryptionProperty createEncryptionProperty() {
        return this._factory.newEncryptionProperty();
    }

    public ReferenceList createReferenceList(int n) {
        return this._factory.newReferenceList(n);
    }

    public Transforms createTransforms() {
        return this._factory.newTransforms();
    }

    public Transforms createTransforms(Document document) {
        return this._factory.newTransforms(document);
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Factory {
        private Factory() {
        }

        AgreementMethod newAgreementMethod(String string2) {
            return new AgreementMethodImpl(string2);
        }

        CipherData newCipherData(int n) {
            return new CipherDataImpl(n);
        }

        CipherReference newCipherReference(String string2) {
            return new CipherReferenceImpl(string2);
        }

        CipherValue newCipherValue(String string2) {
            return new CipherValueImpl(string2);
        }

        EncryptedData newEncryptedData(CipherData cipherData) {
            return new EncryptedDataImpl(cipherData);
        }

        EncryptedKey newEncryptedKey(CipherData cipherData) {
            return new EncryptedKeyImpl(cipherData);
        }

        EncryptionMethod newEncryptionMethod(String string2) {
            return new EncryptionMethodImpl(string2);
        }

        EncryptionProperties newEncryptionProperties() {
            return new EncryptionPropertiesImpl();
        }

        EncryptionProperty newEncryptionProperty() {
            return new EncryptionPropertyImpl();
        }

        ReferenceList newReferenceList(int n) {
            return new ReferenceListImpl(n);
        }

        Transforms newTransforms() {
            return new TransformsImpl();
        }

        Transforms newTransforms(Document document) {
            return new TransformsImpl(document);
        }

        AgreementMethod newAgreementMethod(Element element) throws XMLEncryptionException {
            Element element2;
            Element element3;
            if (null == element) {
                // empty if block
            }
            String string2 = element.getAttributeNS(null, "Algorithm");
            AgreementMethod agreementMethod = this.newAgreementMethod(string2);
            Element element4 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KA-Nonce").item(0);
            if (null != element4) {
                agreementMethod.setKANonce(element4.getNodeValue().getBytes());
            }
            if (null != (element3 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "OriginatorKeyInfo").item(0))) {
                try {
                    agreementMethod.setOriginatorKeyInfo(new KeyInfo(element3, null));
                }
                catch (XMLSecurityException xMLSecurityException) {
                    throw new XMLEncryptionException("empty", xMLSecurityException);
                }
            }
            if (null != (element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "RecipientKeyInfo").item(0))) {
                try {
                    agreementMethod.setRecipientKeyInfo(new KeyInfo(element2, null));
                }
                catch (XMLSecurityException xMLSecurityException) {
                    throw new XMLEncryptionException("empty", xMLSecurityException);
                }
            }
            return agreementMethod;
        }

        CipherData newCipherData(Element element) throws XMLEncryptionException {
            if (null == element) {
                // empty if block
            }
            int n = 0;
            Element element2 = null;
            if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").getLength() > 0) {
                n = 1;
                element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0);
            } else if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference").getLength() > 0) {
                n = 2;
                element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference").item(0);
            }
            CipherData cipherData = this.newCipherData(n);
            if (n == 1) {
                cipherData.setCipherValue(this.newCipherValue(element2));
            } else if (n == 2) {
                cipherData.setCipherReference(this.newCipherReference(element2));
            }
            return cipherData;
        }

        CipherReference newCipherReference(Element element) throws XMLEncryptionException {
            Attr attr = element.getAttributeNodeNS(null, "URI");
            CipherReferenceImpl cipherReferenceImpl = new CipherReferenceImpl(attr);
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "Transforms");
            Element element2 = (Element)nodeList.item(0);
            if (element2 != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Creating a DSIG based Transforms element");
                }
                try {
                    cipherReferenceImpl.setTransforms(new TransformsImpl(element2));
                }
                catch (XMLSignatureException xMLSignatureException) {
                    throw new XMLEncryptionException("empty", xMLSignatureException);
                }
                catch (InvalidTransformException invalidTransformException) {
                    throw new XMLEncryptionException("empty", invalidTransformException);
                }
                catch (XMLSecurityException xMLSecurityException) {
                    throw new XMLEncryptionException("empty", xMLSecurityException);
                }
            }
            return cipherReferenceImpl;
        }

        CipherValue newCipherValue(Element element) {
            String string2 = XMLUtils.getFullTextChildrenFromElement(element);
            CipherValue cipherValue = this.newCipherValue(string2);
            return cipherValue;
        }

        EncryptedData newEncryptedData(Element element) throws XMLEncryptionException {
            Element element2;
            Element element3;
            EncryptedData encryptedData = null;
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
            Element element4 = (Element)nodeList.item(nodeList.getLength() - 1);
            CipherData cipherData = this.newCipherData(element4);
            encryptedData = this.newEncryptedData(cipherData);
            try {
                encryptedData.setId(element.getAttributeNS(null, "Id"));
                encryptedData.setType(new URI(element.getAttributeNS(null, "Type")).toString());
                encryptedData.setMimeType(element.getAttributeNS(null, "MimeType"));
                encryptedData.setEncoding(new URI(element.getAttributeNS(null, "Encoding")).toString());
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
            Element element5 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
            if (null != element5) {
                encryptedData.setEncryptionMethod(this.newEncryptionMethod(element5));
            }
            if (null != (element3 = (Element)element.getElementsByTagNameNS(XMLCipher.XML_DSIG, "KeyInfo").item(0))) {
                try {
                    encryptedData.setKeyInfo(new KeyInfo(element3, null));
                }
                catch (XMLSecurityException xMLSecurityException) {
                    throw new XMLEncryptionException("Error loading Key Info", xMLSecurityException);
                }
            }
            if (null != (element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties").item(0))) {
                encryptedData.setEncryptionProperties(this.newEncryptionProperties(element2));
            }
            return encryptedData;
        }

        EncryptedKey newEncryptedKey(Element element) throws XMLEncryptionException {
            Element element2;
            Element element3;
            Element element4;
            Element element5;
            EncryptedKey encryptedKey = null;
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
            Element element6 = (Element)nodeList.item(nodeList.getLength() - 1);
            CipherData cipherData = this.newCipherData(element6);
            encryptedKey = this.newEncryptedKey(cipherData);
            try {
                encryptedKey.setId(element.getAttributeNS(null, "Id"));
                encryptedKey.setType(new URI(element.getAttributeNS(null, "Type")).toString());
                encryptedKey.setMimeType(element.getAttributeNS(null, "MimeType"));
                encryptedKey.setEncoding(new URI(element.getAttributeNS(null, "Encoding")).toString());
                encryptedKey.setRecipient(element.getAttributeNS(null, "Recipient"));
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
            Element element7 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
            if (null != element7) {
                encryptedKey.setEncryptionMethod(this.newEncryptionMethod(element7));
            }
            if (null != (element5 = (Element)element.getElementsByTagNameNS(XMLCipher.XML_DSIG, "KeyInfo").item(0))) {
                try {
                    encryptedKey.setKeyInfo(new KeyInfo(element5, null));
                }
                catch (XMLSecurityException xMLSecurityException) {
                    throw new XMLEncryptionException("Error loading Key Info", xMLSecurityException);
                }
            }
            if (null != (element4 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties").item(0))) {
                encryptedKey.setEncryptionProperties(this.newEncryptionProperties(element4));
            }
            if (null != (element3 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList").item(0))) {
                encryptedKey.setReferenceList(this.newReferenceList(element3));
            }
            if (null != (element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName").item(0))) {
                encryptedKey.setCarriedName(element2.getNodeValue());
            }
            return encryptedKey;
        }

        EncryptionMethod newEncryptionMethod(Element element) {
            Element element2;
            String string2 = element.getAttributeNS(null, "Algorithm");
            EncryptionMethod encryptionMethod = this.newEncryptionMethod(string2);
            Element element3 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeySize").item(0);
            if (null != element3) {
                encryptionMethod.setKeySize(Integer.valueOf(element3.getFirstChild().getNodeValue()));
            }
            if (null != (element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "OAEPparams").item(0))) {
                encryptionMethod.setOAEPparams(element2.getNodeValue().getBytes());
            }
            return encryptionMethod;
        }

        EncryptionProperties newEncryptionProperties(Element element) {
            EncryptionProperties encryptionProperties = this.newEncryptionProperties();
            encryptionProperties.setId(element.getAttributeNS(null, "Id"));
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperty");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (null == node) continue;
                encryptionProperties.addEncryptionProperty(this.newEncryptionProperty((Element)node));
            }
            return encryptionProperties;
        }

        EncryptionProperty newEncryptionProperty(Element element) {
            EncryptionProperty encryptionProperty = this.newEncryptionProperty();
            try {
                encryptionProperty.setTarget(new URI(element.getAttributeNS(null, "Target")).toString());
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
            encryptionProperty.setId(element.getAttributeNS(null, "Id"));
            return encryptionProperty;
        }

        ReferenceList newReferenceList(Element element) {
            int n = 0;
            if (null != element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference").item(0)) {
                n = 1;
            } else if (null != element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeyReference").item(0)) {
                n = 2;
            }
            ReferenceListImpl referenceListImpl = new ReferenceListImpl(n);
            NodeList nodeList = null;
            switch (n) {
                case 1: {
                    nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        String string2 = ((Element)nodeList.item(i)).getAttribute("URI");
                        referenceListImpl.add(referenceListImpl.newDataReference(string2));
                    }
                    break;
                }
                case 2: {
                    nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeyReference");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        String string3 = ((Element)nodeList.item(i)).getAttribute("URI");
                        referenceListImpl.add(referenceListImpl.newKeyReference(string3));
                    }
                    break;
                }
            }
            return referenceListImpl;
        }

        Transforms newTransforms(Element element) {
            return null;
        }

        Element toElement(AgreementMethod agreementMethod) {
            return ((AgreementMethodImpl)agreementMethod).toElement();
        }

        Element toElement(CipherData cipherData) {
            return ((CipherDataImpl)cipherData).toElement();
        }

        Element toElement(CipherReference cipherReference) {
            return ((CipherReferenceImpl)cipherReference).toElement();
        }

        Element toElement(CipherValue cipherValue) {
            return ((CipherValueImpl)cipherValue).toElement();
        }

        Element toElement(EncryptedData encryptedData) {
            return ((EncryptedDataImpl)encryptedData).toElement();
        }

        Element toElement(EncryptedKey encryptedKey) {
            return ((EncryptedKeyImpl)encryptedKey).toElement();
        }

        Element toElement(EncryptionMethod encryptionMethod) {
            return ((EncryptionMethodImpl)encryptionMethod).toElement();
        }

        Element toElement(EncryptionProperties encryptionProperties) {
            return ((EncryptionPropertiesImpl)encryptionProperties).toElement();
        }

        Element toElement(EncryptionProperty encryptionProperty) {
            return ((EncryptionPropertyImpl)encryptionProperty).toElement();
        }

        Element toElement(ReferenceList referenceList) {
            return ((ReferenceListImpl)referenceList).toElement();
        }

        Element toElement(Transforms transforms) {
            return ((TransformsImpl)transforms).toElement();
        }

        private class ReferenceListImpl
        implements ReferenceList {
            private Class sentry;
            private List references;

            public ReferenceListImpl(int n) {
                if (n == 1) {
                    this.sentry = class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher$Factory$ReferenceListImpl$DataReference == null ? (class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher$Factory$ReferenceListImpl$DataReference = XMLCipher.class$("com.sun.org.apache.xml.internal.security.encryption.XMLCipher$Factory$ReferenceListImpl$DataReference")) : class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher$Factory$ReferenceListImpl$DataReference;
                } else if (n == 2) {
                    this.sentry = class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher$Factory$ReferenceListImpl$KeyReference == null ? (class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher$Factory$ReferenceListImpl$KeyReference = XMLCipher.class$("com.sun.org.apache.xml.internal.security.encryption.XMLCipher$Factory$ReferenceListImpl$KeyReference")) : class$com$sun$org$apache$xml$internal$security$encryption$XMLCipher$Factory$ReferenceListImpl$KeyReference;
                } else {
                    throw new IllegalArgumentException();
                }
                this.references = new LinkedList();
            }

            public void add(Reference reference) {
                if (!reference.getClass().equals(this.sentry)) {
                    throw new IllegalArgumentException();
                }
                this.references.add(reference);
            }

            public void remove(Reference reference) {
                if (!reference.getClass().equals(this.sentry)) {
                    throw new IllegalArgumentException();
                }
                this.references.remove(reference);
            }

            public int size() {
                return this.references.size();
            }

            public boolean isEmpty() {
                return this.references.isEmpty();
            }

            public Iterator getReferences() {
                return this.references.iterator();
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
                Iterator iterator = this.references.iterator();
                while (iterator.hasNext()) {
                    Reference reference = (Reference)iterator.next();
                    element.appendChild(((ReferenceImpl)reference).toElement());
                }
                return element;
            }

            public Reference newDataReference(String string2) {
                return new DataReference(string2);
            }

            public Reference newKeyReference(String string2) {
                return new KeyReference(string2);
            }

            private class KeyReference
            extends ReferenceImpl {
                KeyReference(String string2) {
                    super(string2);
                }

                public Element toElement() {
                    return super.toElement("KeyReference");
                }
            }

            private class DataReference
            extends ReferenceImpl {
                DataReference(String string2) {
                    super(string2);
                }

                public Element toElement() {
                    return super.toElement("DataReference");
                }
            }

            private abstract class ReferenceImpl
            implements Reference {
                private String uri;
                private List referenceInformation;

                ReferenceImpl(String string2) {
                    this.uri = string2;
                    this.referenceInformation = new LinkedList();
                }

                public String getURI() {
                    return this.uri;
                }

                public Iterator getElementRetrievalInformation() {
                    return this.referenceInformation.iterator();
                }

                public void setURI(String string2) {
                    this.uri = string2;
                }

                public void removeElementRetrievalInformation(Element element) {
                    this.referenceInformation.remove(element);
                }

                public void addElementRetrievalInformation(Element element) {
                    this.referenceInformation.add(element);
                }

                public abstract Element toElement();

                Element toElement(String string2) {
                    Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", string2);
                    element.setAttribute("URI", this.uri);
                    return element;
                }
            }
        }

        private class TransformsImpl
        extends com.sun.org.apache.xml.internal.security.transforms.Transforms
        implements Transforms {
            public TransformsImpl() {
                super(XMLCipher.this._contextDocument);
            }

            public TransformsImpl(Document document) {
                super(document);
            }

            public TransformsImpl(Element element) throws XMLSignatureException, InvalidTransformException, XMLSecurityException, TransformationException {
                super(element, "");
            }

            public Element toElement() {
                if (this._doc == null) {
                    this._doc = XMLCipher.this._contextDocument;
                }
                return this.getElement();
            }

            public com.sun.org.apache.xml.internal.security.transforms.Transforms getDSTransforms() {
                return this;
            }

            public String getBaseNamespace() {
                return "http://www.w3.org/2001/04/xmlenc#";
            }
        }

        private class EncryptionPropertyImpl
        implements EncryptionProperty {
            private String target = null;
            private String id = null;
            private String attributeName = null;
            private String attributeValue = null;
            private List encryptionInformation = new LinkedList();

            public String getTarget() {
                return this.target;
            }

            public void setTarget(String string2) {
                URI uRI = null;
                try {
                    uRI = new URI(string2);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.target = uRI.toString();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string2) {
                this.id = string2;
            }

            public String getAttribute(String string2) {
                return this.attributeValue;
            }

            public void setAttribute(String string2, String string3) {
                this.attributeName = string2;
                this.attributeValue = string3;
            }

            public Iterator getEncryptionInformation() {
                return this.encryptionInformation.iterator();
            }

            public void addEncryptionInformation(Element element) {
                this.encryptionInformation.add(element);
            }

            public void removeEncryptionInformation(Element element) {
                this.encryptionInformation.remove(element);
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptionProperty");
                if (null != this.target) {
                    element.setAttributeNS(null, "Target", this.target.toString());
                }
                if (null != this.id) {
                    element.setAttributeNS(null, "Id", this.id);
                }
                return element;
            }
        }

        private class EncryptionPropertiesImpl
        implements EncryptionProperties {
            private String id = null;
            private List encryptionProperties = new LinkedList();

            public String getId() {
                return this.id;
            }

            public void setId(String string2) {
                this.id = string2;
            }

            public Iterator getEncryptionProperties() {
                return this.encryptionProperties.iterator();
            }

            public void addEncryptionProperty(EncryptionProperty encryptionProperty) {
                this.encryptionProperties.add(encryptionProperty);
            }

            public void removeEncryptionProperty(EncryptionProperty encryptionProperty) {
                this.encryptionProperties.remove(encryptionProperty);
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties");
                if (null != this.id) {
                    element.setAttributeNS(null, "Id", this.id);
                }
                Iterator iterator = this.getEncryptionProperties();
                while (iterator.hasNext()) {
                    element.appendChild(((EncryptionPropertyImpl)iterator.next()).toElement());
                }
                return element;
            }
        }

        private class EncryptionMethodImpl
        implements EncryptionMethod {
            private String algorithm = null;
            private int keySize = Integer.MIN_VALUE;
            private byte[] oaepParams = null;
            private List encryptionMethodInformation = null;

            public EncryptionMethodImpl(String string2) {
                URI uRI = null;
                try {
                    uRI = new URI(string2);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.algorithm = uRI.toString();
                this.encryptionMethodInformation = new LinkedList();
            }

            public String getAlgorithm() {
                return this.algorithm;
            }

            public int getKeySize() {
                return this.keySize;
            }

            public void setKeySize(int n) {
                this.keySize = n;
            }

            public byte[] getOAEPparams() {
                return this.oaepParams;
            }

            public void setOAEPparams(byte[] byArray) {
                this.oaepParams = byArray;
            }

            public Iterator getEncryptionMethodInformation() {
                return this.encryptionMethodInformation.iterator();
            }

            public void addEncryptionMethodInformation(Element element) {
                this.encryptionMethodInformation.add(element);
            }

            public void removeEncryptionMethodInformation(Element element) {
                this.encryptionMethodInformation.remove(element);
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
                element.setAttributeNS(null, "Algorithm", this.algorithm.toString());
                if (this.keySize > 0) {
                    element.appendChild(ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "KeySize").appendChild(XMLCipher.this._contextDocument.createTextNode(String.valueOf(this.keySize))));
                }
                if (null != this.oaepParams) {
                    element.appendChild(ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "OAEPparams").appendChild(XMLCipher.this._contextDocument.createTextNode(new String(this.oaepParams))));
                }
                if (!this.encryptionMethodInformation.isEmpty()) {
                    Iterator iterator = this.encryptionMethodInformation.iterator();
                    element.appendChild((Element)iterator.next());
                }
                return element;
            }
        }

        private abstract class EncryptedTypeImpl {
            private String id = null;
            private String type = null;
            private String mimeType = null;
            private String encoding = null;
            private EncryptionMethod encryptionMethod = null;
            private KeyInfo keyInfo = null;
            private CipherData cipherData = null;
            private EncryptionProperties encryptionProperties = null;

            protected EncryptedTypeImpl(CipherData cipherData) {
                this.cipherData = cipherData;
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string2) {
                this.id = string2;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String string2) {
                URI uRI = null;
                try {
                    uRI = new URI(string2);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.type = uRI.toString();
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public void setMimeType(String string2) {
                this.mimeType = string2;
            }

            public String getEncoding() {
                return this.encoding;
            }

            public void setEncoding(String string2) {
                URI uRI = null;
                try {
                    uRI = new URI(string2);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.encoding = uRI.toString();
            }

            public EncryptionMethod getEncryptionMethod() {
                return this.encryptionMethod;
            }

            public void setEncryptionMethod(EncryptionMethod encryptionMethod) {
                this.encryptionMethod = encryptionMethod;
            }

            public KeyInfo getKeyInfo() {
                return this.keyInfo;
            }

            public void setKeyInfo(KeyInfo keyInfo) {
                this.keyInfo = keyInfo;
            }

            public CipherData getCipherData() {
                return this.cipherData;
            }

            public EncryptionProperties getEncryptionProperties() {
                return this.encryptionProperties;
            }

            public void setEncryptionProperties(EncryptionProperties encryptionProperties) {
                this.encryptionProperties = encryptionProperties;
            }
        }

        private class EncryptedKeyImpl
        extends EncryptedTypeImpl
        implements EncryptedKey {
            private String keyRecipient = null;
            private ReferenceList referenceList = null;
            private String carriedName = null;

            public EncryptedKeyImpl(CipherData cipherData) {
                super(cipherData);
            }

            public String getRecipient() {
                return this.keyRecipient;
            }

            public void setRecipient(String string2) {
                this.keyRecipient = string2;
            }

            public ReferenceList getReferenceList() {
                return this.referenceList;
            }

            public void setReferenceList(ReferenceList referenceList) {
                this.referenceList = referenceList;
            }

            public String getCarriedName() {
                return this.carriedName;
            }

            public void setCarriedName(String string2) {
                this.carriedName = string2;
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
                if (null != super.getId()) {
                    element.setAttributeNS(null, "Id", super.getId());
                }
                if (null != super.getType()) {
                    element.setAttributeNS(null, "Type", super.getType().toString());
                }
                if (null != super.getMimeType()) {
                    element.setAttributeNS(null, "MimeType", super.getMimeType());
                }
                if (null != super.getEncoding()) {
                    element.setAttributeNS(null, "Encoding", super.getEncoding().toString());
                }
                if (null != this.getRecipient()) {
                    element.setAttributeNS(null, "Recipient", this.getRecipient());
                }
                if (null != super.getEncryptionMethod()) {
                    element.appendChild(((EncryptionMethodImpl)super.getEncryptionMethod()).toElement());
                }
                if (null != super.getKeyInfo()) {
                    element.appendChild(super.getKeyInfo().getElement());
                }
                element.appendChild(((CipherDataImpl)super.getCipherData()).toElement());
                if (null != super.getEncryptionProperties()) {
                    element.appendChild(((EncryptionPropertiesImpl)super.getEncryptionProperties()).toElement());
                }
                if (this.referenceList != null && !this.referenceList.isEmpty()) {
                    element.appendChild(((ReferenceListImpl)this.getReferenceList()).toElement());
                }
                if (null != this.carriedName) {
                    Element element2 = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName");
                    Text text = XMLCipher.this._contextDocument.createTextNode(this.carriedName);
                    element2.appendChild(text);
                    element.appendChild(element2);
                }
                return element;
            }
        }

        private class EncryptedDataImpl
        extends EncryptedTypeImpl
        implements EncryptedData {
            public EncryptedDataImpl(CipherData cipherData) {
                super(cipherData);
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
                if (null != super.getId()) {
                    element.setAttributeNS(null, "Id", super.getId());
                }
                if (null != super.getType()) {
                    element.setAttributeNS(null, "Type", super.getType().toString());
                }
                if (null != super.getMimeType()) {
                    element.setAttributeNS(null, "MimeType", super.getMimeType());
                }
                if (null != super.getEncoding()) {
                    element.setAttributeNS(null, "Encoding", super.getEncoding().toString());
                }
                if (null != super.getEncryptionMethod()) {
                    element.appendChild(((EncryptionMethodImpl)super.getEncryptionMethod()).toElement());
                }
                if (null != super.getKeyInfo()) {
                    element.appendChild(super.getKeyInfo().getElement());
                }
                element.appendChild(((CipherDataImpl)super.getCipherData()).toElement());
                if (null != super.getEncryptionProperties()) {
                    element.appendChild(((EncryptionPropertiesImpl)super.getEncryptionProperties()).toElement());
                }
                return element;
            }
        }

        private class CipherValueImpl
        implements CipherValue {
            private String cipherValue = null;

            public CipherValueImpl(String string2) {
                this.cipherValue = string2;
            }

            public String getValue() {
                return this.cipherValue;
            }

            public void setValue(String string2) {
                this.cipherValue = string2;
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CipherValue");
                element.appendChild(XMLCipher.this._contextDocument.createTextNode(new String(this.cipherValue)));
                return element;
            }
        }

        private class CipherReferenceImpl
        implements CipherReference {
            private String referenceURI = null;
            private Transforms referenceTransforms = null;
            private Attr referenceNode = null;

            public CipherReferenceImpl(String string2) {
                this.referenceURI = string2;
                this.referenceNode = null;
            }

            public CipherReferenceImpl(Attr attr) {
                this.referenceURI = attr.getNodeValue();
                this.referenceNode = attr;
            }

            public String getURI() {
                return this.referenceURI;
            }

            public Attr getURIAsAttr() {
                return this.referenceNode;
            }

            public Transforms getTransforms() {
                return this.referenceTransforms;
            }

            public void setTransforms(Transforms transforms) {
                this.referenceTransforms = transforms;
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CipherReference");
                element.setAttributeNS(null, "URI", this.referenceURI);
                if (null != this.referenceTransforms) {
                    element.appendChild(((TransformsImpl)this.referenceTransforms).toElement());
                }
                return element;
            }
        }

        private class CipherDataImpl
        implements CipherData {
            private static final String valueMessage = "Data type is reference type.";
            private static final String referenceMessage = "Data type is value type.";
            private CipherValue cipherValue = null;
            private CipherReference cipherReference = null;
            private int cipherType = Integer.MIN_VALUE;

            public CipherDataImpl(int n) {
                this.cipherType = n;
            }

            public CipherValue getCipherValue() {
                return this.cipherValue;
            }

            public void setCipherValue(CipherValue cipherValue) throws XMLEncryptionException {
                if (this.cipherType == 2) {
                    throw new XMLEncryptionException("empty", new UnsupportedOperationException(valueMessage));
                }
                this.cipherValue = cipherValue;
            }

            public CipherReference getCipherReference() {
                return this.cipherReference;
            }

            public void setCipherReference(CipherReference cipherReference) throws XMLEncryptionException {
                if (this.cipherType == 1) {
                    throw new XMLEncryptionException("empty", new UnsupportedOperationException(referenceMessage));
                }
                this.cipherReference = cipherReference;
            }

            public int getDataType() {
                return this.cipherType;
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CipherData");
                if (this.cipherType == 1) {
                    element.appendChild(((CipherValueImpl)this.cipherValue).toElement());
                } else if (this.cipherType == 2) {
                    element.appendChild(((CipherReferenceImpl)this.cipherReference).toElement());
                }
                return element;
            }
        }

        private class AgreementMethodImpl
        implements AgreementMethod {
            private byte[] kaNonce = null;
            private List agreementMethodInformation = new LinkedList();
            private KeyInfo originatorKeyInfo = null;
            private KeyInfo recipientKeyInfo = null;
            private String algorithmURI = null;

            public AgreementMethodImpl(String string2) {
                URI uRI = null;
                try {
                    uRI = new URI(string2);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.algorithmURI = uRI.toString();
            }

            public byte[] getKANonce() {
                return this.kaNonce;
            }

            public void setKANonce(byte[] byArray) {
                this.kaNonce = byArray;
            }

            public Iterator getAgreementMethodInformation() {
                return this.agreementMethodInformation.iterator();
            }

            public void addAgreementMethodInformation(Element element) {
                this.agreementMethodInformation.add(element);
            }

            public void revoveAgreementMethodInformation(Element element) {
                this.agreementMethodInformation.remove(element);
            }

            public KeyInfo getOriginatorKeyInfo() {
                return this.originatorKeyInfo;
            }

            public void setOriginatorKeyInfo(KeyInfo keyInfo) {
                this.originatorKeyInfo = keyInfo;
            }

            public KeyInfo getRecipientKeyInfo() {
                return this.recipientKeyInfo;
            }

            public void setRecipientKeyInfo(KeyInfo keyInfo) {
                this.recipientKeyInfo = keyInfo;
            }

            public String getAlgorithm() {
                return this.algorithmURI;
            }

            public void setAlgorithm(String string2) {
                URI uRI = null;
                try {
                    uRI = new URI(string2);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                string2 = uRI.toString();
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "AgreementMethod");
                element.setAttributeNS(null, "Algorithm", this.algorithmURI);
                if (null != this.kaNonce) {
                    element.appendChild(ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "KA-Nonce")).appendChild(XMLCipher.this._contextDocument.createTextNode(new String(this.kaNonce)));
                }
                if (!this.agreementMethodInformation.isEmpty()) {
                    Iterator iterator = this.agreementMethodInformation.iterator();
                    while (iterator.hasNext()) {
                        element.appendChild((Element)iterator.next());
                    }
                }
                if (null != this.originatorKeyInfo) {
                    element.appendChild(this.originatorKeyInfo.getElement());
                }
                if (null != this.recipientKeyInfo) {
                    element.appendChild(this.recipientKeyInfo.getElement());
                }
                return element;
            }
        }
    }

    private class Serializer {
        Serializer() {
        }

        String serialize(Document document) throws Exception {
            return this.canonSerialize(document);
        }

        String serialize(Element element) throws Exception {
            return this.canonSerialize(element);
        }

        String serialize(NodeList nodeList) throws Exception {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLCipher.this._canon.setWriter(byteArrayOutputStream);
            XMLCipher.this._canon.notReset();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                XMLCipher.this._canon.canonicalizeSubtree(nodeList.item(i));
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString("UTF-8");
        }

        String canonSerialize(Node node) throws Exception {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLCipher.this._canon.setWriter(byteArrayOutputStream);
            XMLCipher.this._canon.notReset();
            XMLCipher.this._canon.canonicalizeSubtree(node);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString("UTF-8");
        }

        DocumentFragment deserialize(String string2, Node node) throws XMLEncryptionException {
            DocumentFragment documentFragment;
            Node node2;
            Node node3;
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><fragment");
            for (Node node4 = node; node4 != null; node4 = node4.getParentNode()) {
                object = node4.getAttributes();
                int n = object != null ? object.getLength() : 0;
                for (int i = 0; i < n; ++i) {
                    node3 = object.item(i);
                    if (!node3.getNodeName().startsWith("xmlns:") && !node3.getNodeName().equals("xmlns")) continue;
                    boolean bl = false;
                    for (node2 = node; node2 != node4; node2 = node2.getParentNode()) {
                        NamedNodeMap namedNodeMap = node2.getAttributes();
                        if (namedNodeMap == null || namedNodeMap.getNamedItem(node3.getNodeName()) == null) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    stringBuffer.append(" " + node3.getNodeName() + "=\"" + node3.getNodeValue() + "\"");
                }
            }
            stringBuffer.append(">" + string2 + "</" + "fragment" + ">");
            object = stringBuffer.toString();
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                node3 = documentBuilder.parse(new InputSource(new StringReader((String)object)));
                node2 = (Element)XMLCipher.this._contextDocument.importNode(node3.getDocumentElement(), true);
                documentFragment = XMLCipher.this._contextDocument.createDocumentFragment();
                Node node5 = node2.getFirstChild();
                while (node5 != null) {
                    node2.removeChild(node5);
                    documentFragment.appendChild(node5);
                    node5 = node2.getFirstChild();
                }
            }
            catch (SAXException sAXException) {
                throw new XMLEncryptionException("empty", sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new XMLEncryptionException("empty", parserConfigurationException);
            }
            catch (IOException iOException) {
                throw new XMLEncryptionException("empty", iOException);
            }
            return documentFragment;
        }
    }
}

