/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.DDParser;
import org.netbeans.modules.schema2beans.DDRegistryParser;
import org.netbeans.modules.schema2beans.TraceLogger;

public class DDRegistry {
    private ArrayList scopes = new ArrayList();
    private ChangeTracer changeTracer = new ChangeTracer(this);

    public void createEntry(BaseBean baseBean, String string, String string2) {
        RegEntry regEntry = this.getRegEntry(baseBean, false);
        if (regEntry != null) {
            throw new IllegalArgumentException(Common.getMessage("BeanGraphAlreadyInRegistry_msg", baseBean.name()));
        }
        regEntry = this.getRegEntry(string);
        if (regEntry != null) {
            throw new IllegalArgumentException(Common.getMessage("CantRegisterGraphSameID_msg", baseBean.name(), regEntry, string));
        }
        baseBean.addPropertyChangeListener(this.changeTracer);
        this.scopes.add(new RegEntry(baseBean, string, string2));
    }

    public void updateEntry(String string, BaseBean baseBean) {
        RegEntry regEntry = this.getRegEntry(string);
        if (regEntry == null) {
            throw new IllegalArgumentException(Common.getMessage("CantUpdateGraphNotInRegistry_msg", string));
        }
        regEntry.setBean(baseBean);
    }

    public void removeEntry(BaseBean baseBean) {
        RegEntry regEntry = this.getRegEntry(baseBean, false);
        if (regEntry != null) {
            regEntry.getBean().removePropertyChangeListener(this.changeTracer);
            this.removeRegEntry(regEntry);
        }
    }

    public void renameEntry(String string, String string2, String string3) {
        RegEntry regEntry = this.getRegEntry(string);
        if (regEntry != null) {
            regEntry.setID(string2);
            if (string3 != null) {
                regEntry.setName(string3);
            }
        }
    }

    public void renameEntry(String string, String string2) {
        this.renameEntry(string, string2, null);
    }

    public void removeEntry(String string) {
        RegEntry regEntry = this.getRegEntry(string);
        if (regEntry != null) {
            regEntry.getBean().removePropertyChangeListener(this.changeTracer);
        }
        this.removeRegEntry(regEntry);
    }

    public DDChangeMarker createChangeMarker() {
        return new DDChangeMarker(this);
    }

    public boolean hasType(BaseBean baseBean, String string) {
        RegEntry regEntry = this.getRegEntry(baseBean, false);
        if (regEntry != null) {
            return regEntry.hasType(string);
        }
        return false;
    }

    public void clearCache() {
        for (int i = 0; i < this.scopes.size(); ++i) {
            RegEntry regEntry = (RegEntry)this.scopes.get(i);
            if (regEntry == null) continue;
            regEntry.setTimestamp();
        }
    }

    public void clearCache(BaseBean baseBean) {
        this.setTimestamp(baseBean);
    }

    public void setTimestamp(BaseBean baseBean) {
        RegEntry regEntry = this.getRegEntry(baseBean, false);
        if (regEntry != null) {
            regEntry.setTimestamp();
        }
    }

    public long getTimestamp(BaseBean baseBean) {
        RegEntry regEntry = this.getRegEntry(baseBean, false);
        if (regEntry != null) {
            return regEntry.getTimestamp();
        }
        return 0L;
    }

    public String getID(BaseBean baseBean) {
        RegEntry regEntry = this.getRegEntry(baseBean, false);
        if (regEntry != null) {
            return regEntry.getID();
        }
        return null;
    }

    public String getID(DDRegistryParser.DDCursor dDCursor) {
        RegEntry regEntry = this.getRegEntry(dDCursor.getRoot(), false);
        if (regEntry != null) {
            return regEntry.getID();
        }
        return null;
    }

    public String getName(DDRegistryParser.DDCursor dDCursor) {
        RegEntry regEntry = this.getRegEntry(dDCursor.getRoot(), false);
        if (regEntry != null) {
            return regEntry.getName();
        }
        return null;
    }

    public DDRegistryParser newParser(DDRegistryParser dDRegistryParser, String string) {
        return new DDRegistryParser(this, dDRegistryParser, string);
    }

    public DDRegistryParser newParser(DDRegistryParser.DDCursor dDCursor, String string) {
        return new DDRegistryParser(this, dDCursor, string);
    }

    public DDRegistryParser newParser(String string) {
        return new DDRegistryParser(this, string);
    }

    public DDRegistryParser.DDCursor newCursor(DDRegistryParser.DDCursor dDCursor, String string) {
        return new DDRegistryParser.DDCursor(dDCursor, string);
    }

    public DDRegistryParser.DDCursor newCursor(String string) {
        return new DDRegistryParser.DDCursor(this, string);
    }

    public DDRegistryParser.DDCursor newCursor(BaseBean baseBean) {
        return new DDRegistryParser.DDCursor(this, baseBean);
    }

    public void addType(BaseBean baseBean, String string) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 16, 1, 1, baseBean.name() + " " + string);
        }
        RegEntry regEntry = this.getRegEntry(baseBean, true);
        regEntry.add(string);
    }

    public String getName(String string) {
        RegEntry regEntry = this.getRegEntry(string);
        if (regEntry != null) {
            return regEntry.getName();
        }
        return null;
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.scopes.size(); ++i) {
            RegEntry regEntry = (RegEntry)this.scopes.get(i);
            if (regEntry == null) continue;
            stringBuffer.append(regEntry.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public String dumpAll() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.scopes.size(); ++i) {
            RegEntry regEntry = (RegEntry)this.scopes.get(i);
            if (regEntry == null) continue;
            stringBuffer.append("\n*** Graph:" + regEntry.toString() + "\n");
            stringBuffer.append(regEntry.getBean().dumpBeanNode());
        }
        return stringBuffer.toString();
    }

    public RegEntry getRegEntry(BaseBean baseBean, boolean bl) {
        for (int i = 0; i < this.scopes.size(); ++i) {
            RegEntry regEntry = (RegEntry)this.scopes.get(i);
            if (regEntry.getBean() != baseBean) continue;
            return regEntry;
        }
        if (baseBean != null && !baseBean.isRoot()) {
            while ((baseBean = baseBean.parent()) != null && !baseBean.isRoot()) {
            }
            return this.getRegEntry(baseBean, bl);
        }
        if (bl) {
            throw new IllegalArgumentException(Common.getMessage("BeanGraphEntryNotInRegistry_msg", baseBean.name()));
        }
        return null;
    }

    private RegEntry getRegEntry(String string) {
        for (int i = 0; i < this.scopes.size(); ++i) {
            RegEntry regEntry = (RegEntry)this.scopes.get(i);
            if (!regEntry.getID().equals(string)) continue;
            return regEntry;
        }
        return null;
    }

    private void removeRegEntry(RegEntry regEntry) {
        int n = this.scopes.indexOf(regEntry);
        if (n != -1) {
            this.scopes.remove(n);
        }
    }

    public static String getGraphName(String string) {
        if (string != null && (string = string.trim()).startsWith("[")) {
            int n = string.indexOf(93);
            if (n != -1) {
                string = string.substring(1, n);
            } else {
                return null;
            }
        }
        return string;
    }

    public boolean hasGraph(String string) {
        return this.hasGraph(string, null);
    }

    public boolean hasGraph(String string, DDRegistryParser.DDCursor dDCursor) {
        String string2 = DDRegistry.getGraphName(string);
        if (string2 != null) {
            if (!string2.equals(".")) {
                return this.getRoot(string2) != null;
            }
            if (dDCursor == null) {
                return true;
            }
            return this.getID(dDCursor) != null;
        }
        return false;
    }

    public static String createGraphName(String string) {
        if (string != null) {
            int n = string.indexOf(91);
            if (n != -1 && n < string.indexOf(93)) {
                return string;
            }
            return "[" + string + "]";
        }
        throw new IllegalArgumentException(Common.getMessage("GraphNameCantBeNull_msg"));
    }

    public BaseBean getRoot(String string) {
        BaseBean[] baseBeanArray = this.getRoots(string);
        if (baseBeanArray.length > 0) {
            return baseBeanArray[0];
        }
        return null;
    }

    public BaseBean[] getRoots(String string) {
        RegEntry regEntry = this.getRegEntry(string = DDRegistry.getGraphName(string));
        if (regEntry == null) {
            ArrayList<BaseBean> arrayList = new ArrayList<BaseBean>();
            for (int i = 0; i < this.scopes.size(); ++i) {
                regEntry = (RegEntry)this.scopes.get(i);
                if (!regEntry.hasType(string)) continue;
                arrayList.add(regEntry.getBean());
            }
            BaseBean[] baseBeanArray = new BaseBean[arrayList.size()];
            return arrayList.toArray(baseBeanArray);
        }
        return new BaseBean[]{regEntry.getBean()};
    }

    static class RegEntry {
        private BaseBean bean;
        private ArrayList types;
        private String ID;
        private String name;
        private long timestamp;

        RegEntry(BaseBean baseBean, String string, String string2) {
            this.bean = baseBean;
            this.types = new ArrayList();
            this.ID = string;
            this.name = string2;
            this.setTimestamp();
        }

        void setTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        long getTimestamp() {
            return this.timestamp;
        }

        void setBean(BaseBean baseBean) {
            this.bean = baseBean;
        }

        BaseBean getBean() {
            return this.bean;
        }

        String getName() {
            return this.name;
        }

        String getID() {
            return this.ID;
        }

        void setID(String string) {
            this.ID = string;
        }

        void setName(String string) {
            this.name = string;
        }

        void add(String string) {
            this.types.add(string);
        }

        boolean hasType(String string) {
            for (int i = 0; i < this.types.size(); ++i) {
                String string2 = (String)this.types.get(i);
                if (string == null || !string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String string = this.bean.name() + "(id:" + this.ID + "-name:" + this.name + ")" + " [";
            for (int i = 0; i < this.types.size(); ++i) {
                String string2 = (String)this.types.get(i);
                string = string + " " + string2;
            }
            return string + "]";
        }
    }

    class IterateParser
    implements Iterator {
        private ArrayList list = new ArrayList();
        private int pos;

        void addParser(BaseBean baseBean, String string) {
            this.list.add(new DDParser(baseBean, string));
        }

        public boolean hasNext() {
            return this.pos < this.list.size();
        }

        public Object next() {
            return this.list.get(this.pos++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class ChangeTracer
    implements PropertyChangeListener {
        DDRegistry reg;

        public ChangeTracer(DDRegistry dDRegistry2) {
            this.reg = dDRegistry2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            try {
                BaseBean baseBean = (BaseBean)propertyChangeEvent.getSource();
                RegEntry regEntry = this.reg.getRegEntry(baseBean, false);
                regEntry.setTimestamp();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class DDChangeMarker {
        private DDRegistry reg;
        private long timestamp;
        private ArrayList elts = null;

        DDChangeMarker(DDRegistry dDRegistry) {
            this.reg = dDRegistry;
            this.elts = new ArrayList();
            this.timestamp = 0L;
        }

        public int size() {
            return this.elts.size();
        }

        public void add(DDChangeMarker dDChangeMarker) {
            if (dDChangeMarker == this) {
                Thread.dumpStack();
            }
            this.elts.add(dDChangeMarker);
        }

        public void add(BaseBean baseBean) {
            RegEntry regEntry = this.reg.getRegEntry(baseBean, false);
            if (regEntry != null && !this.elts.contains(regEntry)) {
                this.elts.add(regEntry);
            }
        }

        public void add(DDRegistryParser.DDCursor dDCursor) {
            String string = this.reg.getID(dDCursor);
            if (string != null) {
                BaseBean baseBean = this.reg.getRoot(string);
                this.add(baseBean);
            }
        }

        public void remove(DDChangeMarker dDChangeMarker) {
            this.elts.remove(dDChangeMarker);
        }

        public void remove(BaseBean baseBean) {
            RegEntry regEntry = this.reg.getRegEntry(baseBean, false);
            if (regEntry != null) {
                this.elts.remove(regEntry);
            }
        }

        public void remove(DDRegistryParser.DDCursor dDCursor) {
            String string = this.reg.getID(dDCursor);
            if (string != null) {
                BaseBean baseBean = this.reg.getRoot(string);
                this.remove(baseBean);
            }
        }

        public void resetTime() {
            this.timestamp = System.currentTimeMillis();
        }

        public boolean hasChanged() {
            boolean bl = this.hasChanged(this.timestamp);
            return bl;
        }

        private boolean hasChanged(long l) {
            for (int i = 0; i < this.elts.size(); ++i) {
                Object e = this.elts.get(i);
                if (e == null || !(e instanceof DDChangeMarker ? ((DDChangeMarker)e).hasChanged(l) : e instanceof RegEntry && ((RegEntry)e).getTimestamp() > l)) continue;
                return true;
            }
            return false;
        }

        public String dump() {
            return this.dump(new StringBuffer(), "", this.timestamp).toString();
        }

        public StringBuffer dump(StringBuffer stringBuffer, String string, long l) {
            stringBuffer.append(string + this.toString() + "\n");
            for (int i = 0; i < this.elts.size(); ++i) {
                Object e = this.elts.get(i);
                if (e == null) continue;
                if (e instanceof DDChangeMarker) {
                    ((DDChangeMarker)e).dump(stringBuffer, string + "  ", l);
                    continue;
                }
                if (!(e instanceof RegEntry)) continue;
                RegEntry regEntry = (RegEntry)e;
                stringBuffer.append(string + "  " + regEntry.getBean() + "-0x" + Integer.toHexString(regEntry.getBean().hashCode()));
                long l2 = regEntry.getTimestamp();
                if (l2 > l) {
                    stringBuffer.append(" Changed  (bean ts:" + l2 + " > cm ts:" + l);
                } else {
                    stringBuffer.append(" No_Change (bean ts:" + l2 + " < cm ts:" + l + ")");
                }
                stringBuffer.append("\n");
            }
            return stringBuffer;
        }

        public String toString() {
            return "DDChangeMarker-0x" + Integer.toHexString(this.hashCode());
        }
    }
}

