/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.SystemInfo;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.enterprise.management.support.Loader;
import com.sun.enterprise.management.support.LoaderOfOld;
import com.sun.enterprise.management.support.WebModuleSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LoaderOfOld77
extends LoaderOfOld {
    private final String mAMXJMXDomain;
    private final boolean mIsDAS;
    public static final Set SYNC_TYPES = GSetUtil.newUnmodifiableStringSet("J2EEDomain", "J2EEServer", "J2EEApplication", "AppClientModule", "EJBModule", "WebModule", "ResourceAdapterModule", "ResourceAdapter", "EntityBean", "StatefulSessionBean", "StatelessSessionBean", "MessageDrivenBean", "Servlet", "JavaMailResource", "JCAResource", "JCAConnectionFactory", "JCAManagedConnectionFactory", "JDBCResource", "JDBCDataSource", "JDBCDriver", "JMSResource", "JNDIResource", "JTAResource", "RMI_IIOPResource", "URL_Resource", "JVM", "WebServiceEndpoint");
    private static final String[] CONTAINMENT_KEYS_77 = new String[]{"name", "j2eeType", "J2EEDomain", "J2EEServer", "J2EEApplication", "EJBModule", "WebModule", "ResourceAdapterModule", "JDBCResource", "JCAResource", "WebServiceEndpoint"};

    LoaderOfOld77(Loader loader) {
        super(loader);
        this.mAMXJMXDomain = loader.getAMXJMXDomainName();
        SystemInfo systemInfo = loader.getDomainRoot().getSystemInfo();
        this.mIsDAS = systemInfo.supportsFeature("RunningInDomainAdminServer");
    }

    @Override
    public Set<ObjectName> findAllOldCandidates() {
        ObjectName pattern = JMXUtil.newObjectName("com.sun.appserv", "*");
        Set<ObjectName> all = JMXUtil.queryNames(this.getMBeanServer(), pattern, null);
        HashSet<ObjectName> results = new HashSet<ObjectName>();
        for (ObjectName objectName : all) {
            if (!this.shouldSync(objectName)) continue;
            results.add(objectName);
        }
        return results;
    }

    private boolean isOld77ObjectName(ObjectName objectName) {
        String j2eeType = objectName.getKeyProperty("j2eeType");
        boolean ret = j2eeType != null && !objectName.getDomain().equals(this.mAMXJMXDomain);
        return ret;
    }

    @Override
    protected Set getNeedsSupport() {
        return Collections.EMPTY_SET;
    }

    @Override
    protected Set getIgnoreTypes() {
        return Collections.EMPTY_SET;
    }

    private boolean isValidCompositeWebModuleName(String compositeName) {
        boolean valid = false;
        try {
            String webModuleName = WebModuleSupport.extractWebModuleName(compositeName);
            valid = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }

    private boolean hasValidWebModuleName(ObjectName objectName) {
        boolean isValid = true;
        String j2eeType = Util.getJ2EEType(objectName);
        if (j2eeType.equals("Servlet")) {
            String compositeName = objectName.getKeyProperty("WebModule");
            isValid = this.isValidCompositeWebModuleName(compositeName);
        } else if (j2eeType.equals("WebServiceEndpoint")) {
            String ejbModName = objectName.getKeyProperty("EJBModule");
            if (ejbModName != null) {
                isValid = true;
            } else {
                String compositeName = objectName.getKeyProperty("WebModule");
                isValid = this.isValidCompositeWebModuleName(compositeName);
            }
        } else if (j2eeType.equals("WebModule")) {
            String compositeName = objectName.getKeyProperty("name");
            isValid = this.isValidCompositeWebModuleName(compositeName);
        }
        return isValid;
    }

    @Override
    public boolean isOldMBean(ObjectName objectName) {
        String j2eeType;
        boolean shouldSync = this.isOld77ObjectName(objectName);
        if (shouldSync && (shouldSync = SYNC_TYPES.contains(j2eeType = Util.getJ2EEType(objectName))) && !this.hasValidWebModuleName(objectName)) {
            shouldSync = false;
            this.getLogger().warning("Not registering AMX MBean against old MBean " + StringUtil.quote(objectName) + " due to malformed composite WebModule name.");
        }
        return shouldSync;
    }

    private Map<String, String> getOld77Props(ObjectName oldObjectName) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < CONTAINMENT_KEYS_77.length; ++i) {
            String key = CONTAINMENT_KEYS_77[i];
            String value = oldObjectName.getKeyProperty(key);
            if (value == null) continue;
            m.put(key, value);
        }
        return m;
    }

    @Override
    protected ObjectName oldToNewObjectName(ObjectName oldObjectName) {
        String j2eeType = Util.getJ2EEType(oldObjectName);
        String j2eeDomainName = this.getAMXJMXDomainName();
        Map<String, String> propsMap = this.getOld77Props(oldObjectName);
        if (j2eeType.equals("J2EEDomain")) {
            propsMap.put("name", j2eeDomainName);
        } else if (j2eeType.equals("J2EEServer")) {
            // empty if block
        }
        String props = JMXUtil.mapToProps(propsMap);
        ObjectName newName = Util.newObjectName(j2eeDomainName, props);
        return newName;
    }

    private final boolean serverRunningInDAS(String serverName) {
        boolean runningInDAS = false;
        if (this.mIsDAS) {
            runningInDAS = true;
        }
        return runningInDAS;
    }

    @Override
    protected Class getImplClass(ObjectName newObjectName, ObjectName oldObjectName) {
        Class implClass = super.getImplClass(newObjectName, oldObjectName);
        boolean isJ2EEServer = Util.getJ2EEType(newObjectName).equals("J2EEServer");
        if (isJ2EEServer) {
            String serverName = Util.getName(newObjectName);
            boolean isAdminServer = this.serverRunningInDAS(serverName);
            if (isAdminServer) {
                try {
                    implClass = ClassUtil.getClassFromName("com.sun.enterprise.management.j2ee.DASJ2EEServerImpl");
                }
                catch (ClassNotFoundException cnfe) {
                    try {
                        implClass = ClassUtil.getClassFromName("com.sun.enterprise.management.j2ee.J2EEServerImpl");
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            this.getLogger().fine("LoaderOfOld77.getImplClass: Using J2EEServer impl of class: " + implClass.getName() + " for server " + serverName);
        }
        return implClass;
    }
}

