/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldAdminServiceMBean;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JMXConnectorConfigFactory
extends ConfigFactory {
    private final OldAdminServiceMBean mOldAdminServiceMBean;
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("AcceptAll", "SecurityEnabled");
    private static final String ADDRESS_KEY = "Address";
    private static final String PORT_KEY = "Port";
    private static final String AUTH_REALM_NAME_KEY = "AuthRealmName";

    public JMXConnectorConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
        this.mOldAdminServiceMBean = this.getOldAdminServiceMBean();
    }

    private final OldAdminServiceMBean getOldAdminServiceMBean() {
        return this.getOldConfigProxies().getOldAdminServiceMBean(this.getConfigName());
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    public ObjectName create(String name, String address, String port, String authRealmName, Map<String, String> optional) {
        String[] requiredParams = new String[]{ADDRESS_KEY, address, PORT_KEY, port, AUTH_REALM_NAME_KEY, authRealmName};
        Map<String, String> params = this.initParams(name, requiredParams, optional);
        ObjectName amxObjectName = this.createNamedChild(name, params);
        return amxObjectName;
    }

    @Override
    protected void removeByName(String name) {
        this.mOldAdminServiceMBean.removeJmxConnectorByName(name);
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        return this.mOldAdminServiceMBean.createJmxConnector(translatedAttrs);
    }
}

