/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.ResourceFactoryImplBase;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectorResourceConfigFactory
extends ResourceFactoryImplBase {
    public static final String RESOURCE_POOL_NAME_KEY = "PoolName";

    public ConnectorResourceConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "jndi-name");
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs, Properties props) {
        return this.getOldResourcesMBean().createConnectorResource(translatedAttrs, props, null);
    }

    public ObjectName create(String jndiName, String poolName, Map<String, String> optional) {
        String[] requiredParams = new String[]{RESOURCE_POOL_NAME_KEY, poolName};
        Map<String, String> params = this.initParams(jndiName, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(jndiName, params);
        return amxName;
    }

    @Override
    protected void removeByName(String name) {
        Set<ResourceRefConfig> refs = this.findAllRefConfigs("X-ConnectorResourceConfig", name);
        if (refs.size() == 0) {
            this.getOldResourcesMBean().removeConnectorResourceByJndiName(name);
        } else {
            for (ResourceRefConfig ref : refs) {
                String target = ref.getContainer().getName();
                this.getOldResourcesMBean().deleteConnectorResource(name, target);
            }
        }
    }
}

