/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.logging.Level;

public class ClusterTest
extends GenericValidator {
    public ClusterTest(ValidationDescriptor desc) {
        super(desc);
    }

    void validateAdd(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkNameNotDomain(cce, result);
        this.checkConfigRefValidity(cce, result);
    }

    void validateUpdate(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkNameNotDomain(cce, result);
        this.preventInvalidConfigRef(cce, result);
    }

    void checkNameNotDomain(ConfigContextEvent cce, Result result) throws ConfigException {
        Cluster c = this.getCluster(cce);
        if ("domain".equals(c.getName())) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".illegalClusterName", "Illegal Cluster Name: {0}", new Object[]{c.getName()}));
        }
    }

    private Cluster getCluster(ConfigContextEvent cce) throws ConfigException {
        return (Cluster)cce.getValidationTarget();
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        boolean flag = false;
        String choice = cce.getChoice();
        try {
            if (choice.equals("UPDATE")) {
                this.validateUpdate(cce, result);
            } else if (choice.equals("ADD")) {
                this.validateAdd(cce, result);
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "domainxmlverifier.exception", ce);
        }
        return result;
    }

    private final void preventInvalidConfigRef(ConfigContextEvent cce, Result result) throws ConfigException {
        if (cce.getName().equals("config-ref")) {
            this.checkConfigRefValidity((String)cce.getObject(), result);
        }
    }

    private final void checkConfigRefValidity(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkConfigRefValidity(this.getCluster(cce).getConfigRef(), result);
    }

    private void checkConfigRefValidity(String config_ref, Result result) {
        if (config_ref.equals("server-config")) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotHaveDASasConfig", "The configuration of the Domain Administration Server (named {0}) cannot be referenced by a cluster", new Object[]{"server-config"}));
        } else if (config_ref.equals("default-config")) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotHaveTemplateConfig", "The default configuration template (named {0}) cannot be referenced by a cluster", new Object[]{"default-config"}));
        }
    }
}

