/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.backup;

import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.BackupRequest;
import com.sun.enterprise.config.backup.BackupRestoreManager;
import com.sun.enterprise.config.backup.BackupWarningException;
import com.sun.enterprise.config.backup.Status;
import com.sun.enterprise.config.backup.ZipFilenameFilter;
import com.sun.enterprise.config.backup.util.FileUtils;
import java.io.File;

public class ListManager
extends BackupRestoreManager {
    File[] zips;

    public ListManager(BackupRequest req) throws BackupException, BackupWarningException {
        super(req);
    }

    public String list() throws BackupException {
        StringBuffer sb = new StringBuffer();
        this.findZips();
        for (int i = 0; i < this.zips.length; ++i) {
            Status status2 = new Status();
            sb.append(status2.read(this.zips[i], this.request.terse));
            sb.append("\n");
            if (this.request.terse) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    void init() throws BackupException, BackupWarningException {
        super.init();
        if (!FileUtils.safeIsDirectory(this.request.domainDir)) {
            throw new BackupException("backup-res.NoDomainDir", this.request.domainDir);
        }
        this.request.backupDir = new File(this.request.domainDir, "backups");
        if (!FileUtils.safeIsDirectory(this.request.backupDir)) {
            throw new BackupWarningException("backup-res.NoBackupDir", this.request.backupDir);
        }
    }

    void findZips() throws BackupWarningException {
        this.zips = this.request.backupDir.listFiles(new ZipFilenameFilter());
        if (this.zips == null || this.zips.length <= 0) {
            throw new BackupWarningException("backup-res.NoBackupFiles", this.request.backupDir);
        }
    }
}

