/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.lifecycle;

import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.wsmgmt.config.spi.WebServiceConfig;
import com.sun.enterprise.admin.wsmgmt.lifecycle.EndpointRegistration;

class MonitoringLifeCycleImpl {
    static MonitoringLifeCycleImpl flcm = null;
    private static final MonitoringLevel OFF = MonitoringLevel.OFF;
    private static final MonitoringLevel HIGH = MonitoringLevel.HIGH;
    private static final MonitoringLevel LOW = MonitoringLevel.LOW;

    MonitoringLifeCycleImpl() {
    }

    public void initializeMonitoring(String appId, String modName, String ctxRoot, boolean isStandAlone, boolean isEjbModule, String vs, WebServiceConfig wsConfig) throws MonitoringRegistrationException {
        if (wsConfig == null) {
            return;
        }
        String monLevel = wsConfig.getMonitoringLevel();
        MonitoringLevel newLevel = MonitoringLevel.instance(monLevel);
        if (newLevel.equals(MonitoringLevel.OFF)) {
            return;
        }
        this.instrumentMonitoring(wsConfig.getEndpointName(), modName, ctxRoot, isStandAlone, vs, appId, MonitoringLevel.OFF, newLevel, isEjbModule);
    }

    public void uninitializeMonitoring(String appId, String modName, String ctxRoot, boolean isStandAlone, boolean isEjbModule, String vs, WebServiceConfig wsConfig) throws MonitoringRegistrationException {
        if (wsConfig == null) {
            return;
        }
        String monLevel = wsConfig.getMonitoringLevel();
        MonitoringLevel oldLevel = MonitoringLevel.instance(monLevel);
        if (oldLevel.equals(MonitoringLevel.OFF)) {
            return;
        }
        this.instrumentMonitoring(wsConfig.getEndpointName(), modName, ctxRoot, isStandAlone, vs, appId, oldLevel, MonitoringLevel.OFF, isEjbModule);
    }

    public void instrumentMonitoring(String name, String moduleName, String ctxRoot, boolean isStandAlone, String vs, String j2eeAppName, MonitoringLevel oldLevel, MonitoringLevel newLevel, boolean isEjbModule) throws MonitoringRegistrationException {
        if (name == null) {
            return;
        }
        EndpointRegistration epr = new EndpointRegistration(name, moduleName, ctxRoot, isStandAlone, vs, j2eeAppName, isEjbModule);
        if (oldLevel == newLevel) {
            return;
        }
        if (oldLevel == OFF) {
            if (newLevel == LOW) {
                epr.enableLOW();
            }
            if (newLevel == HIGH) {
                epr.enableLOW();
            }
        }
        if (oldLevel == LOW) {
            if (newLevel == HIGH) {
                // empty if block
            }
            if (newLevel == OFF) {
                epr.disableLOW();
            }
        }
        if (oldLevel == HIGH) {
            if (newLevel == LOW) {
                // empty if block
            }
            if (newLevel == OFF) {
                epr.disableLOW();
            }
        }
    }
}

