/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.filter.spi;

import com.sun.enterprise.admin.wsmgmt.filter.spi.Filter;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterContext;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterRegistry;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class FilterRouter {
    private static FilterRouter fr = new FilterRouter();
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager _stringMgr = StringManager.getManager(FilterRouter.class);

    public void applyFilters(String stage, FilterContext context) {
        if (context == null) {
            return;
        }
        String endpoint = context.getFullyQualifiedName();
        FilterRegistry fm = FilterRegistry.getInstance();
        if (!fm.isManaged(endpoint)) {
            return;
        }
        List filters = fm.getFilters(stage, endpoint);
        if (filters == null) {
            return;
        }
        ListIterator filterItr = filters.listIterator();
        while (filterItr.hasNext()) {
            Filter f = (Filter)filterItr.next();
            try {
                f.process(stage, endpoint, context);
            }
            catch (Exception e) {
                _logger.fine("Filter execution for endpoint " + endpoint + " failed: " + e.getMessage());
            }
        }
    }

    public static synchronized FilterRouter getInstance() {
        if (fr == null) {
            fr = new FilterRouter();
        }
        return fr;
    }

    private FilterRouter() {
    }
}

