/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.config.impl;

import com.sun.enterprise.admin.wsmgmt.config.impl.WebServiceConfigImpl;
import com.sun.enterprise.admin.wsmgmt.config.spi.ConfigProvider;
import com.sun.enterprise.admin.wsmgmt.config.spi.WebServiceConfig;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.config.serverbeans.WebServiceEndpoint;
import com.sun.enterprise.server.ApplicationServer;
import java.util.ArrayList;
import java.util.List;

public class AppServConfigProvider
implements ConfigProvider {
    public String getProviderID() {
        return "com.sun.enterprise.admin.wsmgmt.config.impl.AppServConfigProvider";
    }

    public WebServiceConfig[] getWebserviceConfigs(String appId) {
        WebServiceEndpoint[] wsps = this.getWebServiceEndpoints(appId);
        WebServiceConfig[] wsCfgs = new WebServiceConfig[wsps.length];
        for (int idx = 0; idx < wsps.length; ++idx) {
            wsCfgs[idx] = new WebServiceConfigImpl(wsps[idx]);
        }
        return wsCfgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebServiceEndpoint[] getWebServiceEndpoints(String appId) {
        WebServiceEndpoint[] wsps = null;
        try {
            ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
            ConfigBean cb = ApplicationHelper.findApplication((ConfigContext)ctx, (String)appId);
            if (cb instanceof WebModule) {
                wsps = ((WebModule)cb).getWebServiceEndpoint();
            }
            if (cb instanceof EjbModule) {
                wsps = ((EjbModule)cb).getWebServiceEndpoint();
            }
            if (cb instanceof J2eeApplication) {
                wsps = ((J2eeApplication)cb).getWebServiceEndpoint();
                return wsps;
            }
        }
        catch (ConfigException configException) {}
        finally {
            return wsps;
        }
    }

    public WebServiceConfig getWebServiceConfig(String appId, String modId, boolean isStandalone, String name) {
        WebServiceEndpoint[] wsps = this.getWebServiceEndpoints(appId);
        if (wsps != null) {
            for (int idx = 0; idx < wsps.length; ++idx) {
                String sName = null;
                sName = isStandalone ? name : modId + "#" + name;
                if (!wsps[idx].getName().equals(sName)) continue;
                return new WebServiceConfigImpl(wsps[idx]);
            }
        }
        return null;
    }

    public WebServiceConfig getWebServiceConfig(String fqn) {
        if (fqn == null) {
            return null;
        }
        String appId = null;
        int sepIdx = fqn.indexOf("#");
        appId = fqn.substring(0, sepIdx);
        String partialName = fqn.substring(sepIdx + 1);
        WebServiceEndpoint[] wsps = this.getWebServiceEndpoints(appId);
        for (int idx = 0; idx < wsps.length; ++idx) {
            if (!wsps[idx].getName().equals(partialName)) continue;
            return new WebServiceConfigImpl(wsps[idx]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getManagedWebserviceApplicationIds() {
        ArrayList<String> aList = new ArrayList<String>();
        try {
            ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
            String serverName = ApplicationServer.getServerContext().getInstanceName();
            ApplicationRef[] appRefs = ServerHelper.getApplicationReferences((ConfigContext)ctx, (String)serverName);
            for (int appIdx = 0; appIdx < appRefs.length; ++appIdx) {
                String appName = appRefs[appIdx].getRef();
                ConfigBean cb = ApplicationHelper.findApplication((ConfigContext)ctx, (String)appName);
                int wsSize = 0;
                if (cb instanceof WebModule) {
                    wsSize = ((WebModule)cb).sizeWebServiceEndpoint();
                } else if (cb instanceof EjbModule) {
                    wsSize = ((EjbModule)cb).sizeWebServiceEndpoint();
                } else if (cb instanceof J2eeApplication) {
                    wsSize = ((J2eeApplication)cb).sizeWebServiceEndpoint();
                }
                if (wsSize <= 0) continue;
                aList.add(appName);
            }
        }
        catch (ConfigException configException) {}
        finally {
            return aList;
        }
    }
}

