/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi.reconfig;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.MonitoringThreadContext;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;

public class MonitoringConfigurationHandler {
    private static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static StringManager sm = StringManager.getManager(MonitoringConfigurationHandler.class);

    private MonitoringConfigurationHandler() {
    }

    public static MonitoringLevel getLevel(MonitoredObjectType objType) {
        MonitoringLevel level = null;
        if (objType == MonitoredObjectType.APPLICATION || objType == MonitoredObjectType.EJBMODULE || objType == MonitoredObjectType.ROOT || objType == MonitoredObjectType.STANDALONE_EJBMODULE || objType == MonitoredObjectType.STANDALONE_WEBMODULE) {
            level = MonitoringLevel.HIGH;
        } else if (objType == MonitoredObjectType.ENTITY_BEAN || objType == MonitoredObjectType.BEAN_CACHE || objType == MonitoredObjectType.BEAN_METHOD || objType == MonitoredObjectType.BEAN_POOL || objType == MonitoredObjectType.STATEFUL_BEAN || objType == MonitoredObjectType.STATELESS_BEAN || objType == MonitoredObjectType.MESSAGE_DRIVEN_BEAN || objType == MonitoredObjectType.BEAN_METHODS || objType == MonitoredObjectType.SESSION_STORE || objType == MonitoredObjectType.TIMERS) {
            level = MonitoringConfigurationHandler.getLevelFor("ejb-container");
        } else {
            if (objType == MonitoredObjectType.HTTP_LISTENER || objType == MonitoredObjectType.VIRTUAL_SERVER || objType == MonitoredObjectType.REQUEST || objType == MonitoredObjectType.FILE_CACHE || objType == MonitoredObjectType.PWC_THREAD_POOL || objType == MonitoredObjectType.KEEP_ALIVE || objType == MonitoredObjectType.DNS || objType == MonitoredObjectType.CONNECTION_QUEUE || objType == MonitoredObjectType.HTTP_SERVICE) {
                return MonitoringConfigurationHandler.getLevelFor("http-service");
            }
            if (objType == MonitoredObjectType.SERVLET) {
                level = MonitoringConfigurationHandler.getLevelFor("web-container");
            } else if (objType == MonitoredObjectType.WEBMODULE) {
                level = MonitoringConfigurationHandler.getLevelFor("web-container");
            } else if (objType == MonitoredObjectType.CONNECTOR_CONN_POOL || objType == MonitoredObjectType.CONNECTOR_WORKMGMT || objType == MonitoredObjectType.JMS_SERVICE) {
                level = MonitoringConfigurationHandler.getLevelFor("connector-service");
            } else if (objType == MonitoredObjectType.JDBC_CONN_POOL) {
                level = MonitoringConfigurationHandler.getLevelFor("jdbc-connection-pool");
            } else if (objType == MonitoredObjectType.JVM) {
                level = MonitoringConfigurationHandler.getLevelFor("jvm");
            } else if (objType == MonitoredObjectType.ORB || objType == MonitoredObjectType.CONNECTION_MANAGERS || objType == MonitoredObjectType.CONNECTION_MANAGER) {
                level = MonitoringConfigurationHandler.getLevelFor("orb");
            } else if (objType == MonitoredObjectType.THREAD_POOL) {
                level = MonitoringConfigurationHandler.getLevelFor("thread-pool");
            } else if (objType == MonitoredObjectType.TRANSACTION_SERVICE) {
                level = MonitoringConfigurationHandler.getLevelFor("transaction-service");
            } else if (objType == MonitoredObjectType.JNDI) {
                level = MonitoringConfigurationHandler.getLevelFor("jndi");
            } else if (objType == MonitoredObjectType.WEBSERVICE_ENDPOINT) {
                level = MonitoringConfigurationHandler.getLevelFor("webservice_endpoint");
            } else {
                logger.finer("Received  a MonitoringObjectType: " + objType + " for which there is no configuration in domain.xml - Returning NULL");
            }
        }
        return level;
    }

    public static boolean shouldRegisterMBean(MonitoredObjectType type) {
        MonitoringLevel levelFromConfig = MonitoringConfigurationHandler.getLevel(type);
        return levelFromConfig == MonitoringLevel.LOW || levelFromConfig == MonitoringLevel.HIGH;
    }

    private static MonitoringLevel getLevelFor(String name) {
        if ("ejb-container".equals(name)) {
            return ConfigGetter.getEjbContainerLevel();
        }
        if ("web-container".equals(name)) {
            return ConfigGetter.getWebContainerLevel();
        }
        if ("http-service".equals(name)) {
            return ConfigGetter.getHttpServiceLevel();
        }
        if ("transaction-service".equals(name)) {
            return ConfigGetter.getTransactionServiceLevel();
        }
        if ("orb".equals(name)) {
            return ConfigGetter.getOrbLevel();
        }
        if ("thread-pool".equals(name)) {
            return ConfigGetter.getThreadPoolLevel();
        }
        if ("jdbc-connection-pool".equals(name)) {
            return ConfigGetter.getJdbcConnectionPoolLevel();
        }
        if ("connector-connection-pool".equals(name)) {
            return ConfigGetter.getConnectorServiceLevel();
        }
        if ("connector-service".equals(name)) {
            return ConfigGetter.getConnectorServiceLevel();
        }
        if ("jms-service".equals(name)) {
            return ConfigGetter.getConnectorServiceLevel();
        }
        if ("jvm".equals(name)) {
            return ConfigGetter.getJvmLevel();
        }
        if ("webservice_endpoint".equals(name)) {
            return MonitoringLevel.LOW;
        }
        logger.finer("No configuration in domain.xml for the string: " + name);
        return null;
    }

    private static final class ConfigGetter {
        private ConfigGetter() {
        }

        private static Config getCfg() {
            try {
                AdminEvent event = MonitoringThreadContext.getEventFromThreadLocal();
                ConfigContext ctx = null;
                ctx = event != null ? event.getConfigContext() : ApplicationServer.getServerContext().getConfigContext();
                Config cfg = ServerBeansFactory.getConfigBean((ConfigContext)ctx);
                return cfg;
            }
            catch (Exception e) {
                return null;
            }
        }

        static MonitoringLevel string2Level(String s) {
            MonitoringLevel l = MonitoringLevel.instance(s);
            if (s == null) {
                String msg = sm.getString("mch.invalid_monitoring_level", (Object)s);
                throw new RuntimeException(msg);
            }
            return l;
        }

        static MonitoringLevel getEjbContainerLevel() {
            String l = ConfigGetter.getCfg().getMonitoringService().getModuleMonitoringLevels().getEjbContainer();
            logger.finer("EjbContainer monitoring-level = " + l);
            return ConfigGetter.string2Level(l);
        }

        static MonitoringLevel getWebContainerLevel() {
            String l = ConfigGetter.getCfg().getMonitoringService().getModuleMonitoringLevels().getWebContainer();
            logger.finer("WebContainer monitoring-level = " + l);
            return ConfigGetter.string2Level(l);
        }

        static MonitoringLevel getJdbcConnectionPoolLevel() {
            String l = ConfigGetter.getCfg().getMonitoringService().getModuleMonitoringLevels().getJdbcConnectionPool();
            logger.finer("JdbcConnectionPoolLevel monitoring-level = " + l);
            return ConfigGetter.string2Level(l);
        }

        static MonitoringLevel getConnectorConnectionPoolLevel() {
            String l = ConfigGetter.getCfg().getMonitoringService().getModuleMonitoringLevels().getConnectorConnectionPool();
            logger.finer("ConnectorConnectionPoolLevel monitoring-level = " + l);
            return ConfigGetter.string2Level(l);
        }

        static MonitoringLevel getTransactionServiceLevel() {
            String l = ConfigGetter.getCfg().getMonitoringService().getModuleMonitoringLevels().getTransactionService();
            logger.finer("TransactionService monitoring-level = " + l);
            return ConfigGetter.string2Level(l);
        }

        static MonitoringLevel getHttpServiceLevel() {
            String l = ConfigGetter.getCfg().getMonitoringService().getModuleMonitoringLevels().getHttpService();
            logger.finer("HttpService monitoring-level = " + l);
            return ConfigGetter.string2Level(l);
        }

        static MonitoringLevel getOrbLevel() {
            String l = ConfigGetter.getCfg().getMonitoringService().getModuleMonitoringLevels().getOrb();
            logger.finer("Orb monitoring-level = " + l);
            return ConfigGetter.string2Level(l);
        }

        static MonitoringLevel getThreadPoolLevel() {
            String l = ConfigGetter.getCfg().getMonitoringService().getModuleMonitoringLevels().getThreadPool();
            logger.finer("Thread pool monitoring-level = " + l);
            return ConfigGetter.string2Level(l);
        }

        static MonitoringLevel getConnectorServiceLevel() {
            String l = ConfigGetter.getCfg().getMonitoringService().getModuleMonitoringLevels().getConnectorService();
            logger.finer("ConnectorServiceLevel monitoring-level = " + l);
            return ConfigGetter.string2Level(l);
        }

        static MonitoringLevel getJvmLevel() {
            String l = ConfigGetter.getCfg().getMonitoringService().getModuleMonitoringLevels().getJvm();
            logger.finer("Jvm monitoring-level = " + l);
            return ConfigGetter.string2Level(l);
        }
    }
}

