/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.server.ApplicationServer;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.management.ObjectName;

final class MonitoringObjectNames {
    private static final String SERVER_ID = ApplicationServer.getServerContext().getInstanceName();
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String CATEGORY_PROPERTY = "category";
    private static final String CATEGORY_PROPERTY_VAL = "monitor";
    private static final String SERVER_PROPERTY = "server";

    private MonitoringObjectNames() {
    }

    private static ObjectName formObjectName(Hashtable t) {
        String domain = MonitoringObjectNames.getDomainName();
        t.put(CATEGORY_PROPERTY, CATEGORY_PROPERTY_VAL);
        t.put(SERVER_PROPERTY, SERVER_ID);
        ObjectName on = null;
        try {
            on = new ObjectName(domain, t);
            logger.fine("MonitoringObjectNames:formObjectName - ObjectName = " + on.toString());
        }
        catch (Exception cause) {
            throw new RuntimeException(cause);
        }
        return on;
    }

    private static String getDomainName() {
        AdminContext ac = AdminService.getAdminService().getAdminContext();
        return ac.getDomainName();
    }

    static ObjectName getRootObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.ROOT.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getEjbObjectName(MonitoredObjectType type, String ejb, String module, String app) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", type.getTypeName());
        t.put("name", ejb);
        if (app != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), app);
            t.put(MonitoredObjectType.EJBMODULE.getTypeName(), module);
        } else {
            t.put(MonitoredObjectType.STANDALONE_EJBMODULE.getTypeName(), module);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getWebServiceObjectNameForWeb(String endpoint, String app, String ctxRoot, String virtualServer) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        ObjectName virtualServerObjectName = MonitoringObjectNames.getVirtualServerObjectName(app, ctxRoot, virtualServer);
        t.put("type", MonitoredObjectType.WEBSERVICE_ENDPOINT.getTypeName());
        t.put("name", endpoint);
        t.put(virtualServerObjectName.getKeyProperty("type"), virtualServerObjectName.getKeyProperty("name"));
        String appPropName = MonitoredObjectType.APPLICATION.getTypeName();
        String appName = virtualServerObjectName.getKeyProperty(appPropName);
        if (appName == null) {
            appName = "null";
        }
        t.put(appPropName, appName);
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getWebServiceObjectNameForEjb(String endpoint, String module, String app) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.WEBSERVICE_ENDPOINT.getTypeName());
        t.put("name", endpoint);
        if (app != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), app);
            t.put(MonitoredObjectType.EJBMODULE.getTypeName(), module);
        } else {
            t.put(MonitoredObjectType.STANDALONE_EJBMODULE.getTypeName(), module);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getEjbMethodsObjectName(String app, String module, MonitoredObjectType ejbType, String ejb) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.BEAN_METHODS.getTypeName());
        t.put(ejbType.getTypeName(), ejb);
        if (app != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), app);
            t.put(MonitoredObjectType.EJBMODULE.getTypeName(), module);
        } else {
            t.put(MonitoredObjectType.STANDALONE_EJBMODULE.getTypeName(), module);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getEjbMethodObjectName(String method, MonitoredObjectType ejbType, String ejb, String module, String app) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.BEAN_METHOD.getTypeName());
        t.put("name", method);
        t.put(ejbType.getTypeName(), ejb);
        if (app != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), app);
            t.put(MonitoredObjectType.EJBMODULE.getTypeName(), module);
        } else {
            t.put(MonitoredObjectType.STANDALONE_EJBMODULE.getTypeName(), module);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getEjbPoolObjectName(MonitoredObjectType ejbType, String ejb, String module, String app) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.BEAN_POOL.getTypeName());
        t.put("name", MonitoredObjectType.BEAN_POOL.getTypeName());
        t.put(ejbType.getTypeName(), ejb);
        if (app != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), app);
            t.put(MonitoredObjectType.EJBMODULE.getTypeName(), module);
        } else {
            t.put(MonitoredObjectType.STANDALONE_EJBMODULE.getTypeName(), module);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getEjbCacheObjectName(MonitoredObjectType ejbType, String ejb, String module, String app) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.BEAN_CACHE.getTypeName());
        t.put("name", MonitoredObjectType.BEAN_CACHE.getTypeName());
        t.put(ejbType.getTypeName(), ejb);
        if (app != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), app);
            t.put(MonitoredObjectType.EJBMODULE.getTypeName(), module);
        } else {
            t.put(MonitoredObjectType.STANDALONE_EJBMODULE.getTypeName(), module);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getConnectionPoolObjectName(String name, MonitoredObjectType type) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        if (type == MonitoredObjectType.CONNECTOR_CONN_POOL) {
            t.put("type", MonitoredObjectType.CONNECTOR_CONN_POOL.getTypeName());
        } else {
            t.put("type", MonitoredObjectType.JDBC_CONN_POOL.getTypeName());
        }
        t.put("name", name);
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getOrbConnectionManagerObjectName(String name) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.CONNECTION_MANAGER.getTypeName());
        t.put("name", name);
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getThreadPoolObjectName(String name) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.THREAD_POOL.getTypeName());
        t.put("name", name);
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getTransactionServiceObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.TRANSACTION_SERVICE.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJvmObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JVM.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJndiObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JNDI.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getApplicationsObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.APPLICATIONS.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getThreadPoolsObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.THREAD_POOLS.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getOrbObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.ORB.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getHttpServiceObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.HTTP_SERVICE.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getResourcesObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.RESOURCES.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getConnectionManagersObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.CONNECTION_MANAGERS.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getVirtualServerObjectName(String vs) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.VIRTUAL_SERVER.getTypeName());
        t.put("name", vs);
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getHttpListenerObjectName(String vs, String ls) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.HTTP_LISTENER.getTypeName());
        t.put(MonitoredObjectType.VIRTUAL_SERVER.getTypeName(), vs);
        t.put("name", ls);
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getApplicationObjectName(String app) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.APPLICATION.getTypeName());
        t.put("name", app);
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getEjbModuleObjectName(String app, String module) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("name", module);
        if (app != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), app);
            t.put("type", MonitoredObjectType.EJBMODULE.getTypeName());
        } else {
            t.put("type", MonitoredObjectType.STANDALONE_EJBMODULE.getTypeName());
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getWebModuleObjectName(String app, String ctxRoot, String vs) {
        String module = "//" + (vs == null ? "DEFAULT" : vs) + ("".equals(ctxRoot) ? "/" : ctxRoot);
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("name", module);
        if (app != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), app);
            t.put("type", MonitoredObjectType.WEBMODULE.getTypeName());
        } else {
            t.put("type", MonitoredObjectType.STANDALONE_WEBMODULE.getTypeName());
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getVirtualServerObjectName(String app, String ctxRoot, String vs) {
        String module = "//" + (vs == null ? "DEFAULT" : vs) + ("".equals(ctxRoot) ? "/" : ctxRoot);
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("name", module);
        t.put("type", MonitoredObjectType.WEBAPP_VIRTUAL_SERVER.getTypeName());
        if (app != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), app);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getServletObjectName(String app, String ctxRoot, String vs, String servlet) {
        ObjectName virtualServerObjectName = MonitoringObjectNames.getVirtualServerObjectName(app, ctxRoot, vs);
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("name", servlet);
        t.put("type", MonitoredObjectType.SERVLET.getTypeName());
        t.put(MonitoredObjectType.WEBAPP_VIRTUAL_SERVER.getTypeName(), virtualServerObjectName.getKeyProperty("name"));
        if (app != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), app);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getConnectorServiceObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.CONNECTOR_SERVICE.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJmsServiceObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JMS_SERVICE.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getConnectorModuleObjectName(String j2eeAppName, String moduleName) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        if (j2eeAppName != null) {
            t.put("name", j2eeAppName + "#" + moduleName);
            t.put("type", MonitoredObjectType.CONNECTOR_MODULE.getTypeName());
        } else {
            t.put("name", moduleName);
            t.put("type", MonitoredObjectType.STANDALONE_CONNECTOR_MODULE.getTypeName());
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getConnectorWorkMgmtObjectName(String j2eeAppName, String moduleName, boolean isJms) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.CONNECTOR_WORKMGMT.getTypeName());
        if (!isJms) {
            if (j2eeAppName != null) {
                t.put(MonitoredObjectType.CONNECTOR_MODULE.getTypeName(), j2eeAppName + "#" + moduleName);
            } else {
                t.put(MonitoredObjectType.STANDALONE_CONNECTOR_MODULE.getTypeName(), moduleName);
            }
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getConnectionFactoriesObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.CONNECTION_FACTORIES.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getConnectionFactoryObjectName(String factoryName) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.CONNECTION_FACTORY.getTypeName());
        t.put("name", factoryName);
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getConnectionPoolsObjectName(String j2eeAppName, String moduleName) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.CONNECTION_POOLS.getTypeName());
        if (j2eeAppName != null) {
            t.put(MonitoredObjectType.CONNECTOR_MODULE.getTypeName(), j2eeAppName + "#" + moduleName);
        } else {
            t.put(MonitoredObjectType.STANDALONE_CONNECTOR_MODULE.getTypeName(), moduleName);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getConnectionPoolObjectName(String poolName, String j2eeAppName, String moduleName) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.CONNECTOR_CONN_POOL.getTypeName());
        t.put("name", poolName);
        if (j2eeAppName != null) {
            t.put(MonitoredObjectType.CONNECTOR_MODULE.getTypeName(), j2eeAppName + "#" + moduleName);
        } else {
            t.put(MonitoredObjectType.STANDALONE_CONNECTOR_MODULE.getTypeName(), moduleName);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getConnectionQueueObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.CONNECTION_QUEUE.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getDnsObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.DNS.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getKeepAliveObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.KEEP_ALIVE.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getPWCThreadPoolObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.PWC_THREAD_POOL.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getFileCacheObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.FILE_CACHE.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getRequestObjectName(String vsId) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.REQUEST.getTypeName());
        t.put(MonitoredObjectType.VIRTUAL_SERVER.getTypeName(), vsId);
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getStatefulSessionStoreObjectName(MonitoredObjectType ejbType, String ejbName, String moduleName, String j2eeAppName) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.SESSION_STORE.getTypeName());
        t.put("name", MonitoredObjectType.SESSION_STORE.getTypeName());
        t.put(ejbType.getTypeName(), ejbName);
        if (j2eeAppName != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), j2eeAppName);
            t.put(MonitoredObjectType.EJBMODULE.getTypeName(), moduleName);
        } else {
            t.put(MonitoredObjectType.STANDALONE_EJBMODULE.getTypeName(), moduleName);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getTimerObjectName(MonitoredObjectType ejbType, String ejbName, String moduleName, String j2eeAppName) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.TIMERS.getTypeName());
        t.put("name", MonitoredObjectType.TIMERS.getTypeName());
        t.put(ejbType.getTypeName(), ejbName);
        if (j2eeAppName != null) {
            t.put(MonitoredObjectType.APPLICATION.getTypeName(), j2eeAppName);
            t.put(MonitoredObjectType.EJBMODULE.getTypeName(), moduleName);
        } else {
            t.put(MonitoredObjectType.STANDALONE_EJBMODULE.getTypeName(), moduleName);
        }
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJVMCompilationObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JVM_COMPILATION.getTypeName());
        t.put("name", MonitoredObjectType.JVM_COMPILATION.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJVMClassLoadingObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JVM_CLASSLOADING.getTypeName());
        t.put("name", MonitoredObjectType.JVM_CLASSLOADING.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJVMRuntimeObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JVM_RUNTIME.getTypeName());
        t.put("name", MonitoredObjectType.JVM_RUNTIME.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJVMOSObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JVM_OS.getTypeName());
        t.put("name", MonitoredObjectType.JVM_OS.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJVMGCSSObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JVM_GCS.getTypeName());
        t.put("name", MonitoredObjectType.JVM_GCS.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJVMGCObjectName(String gcName) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JVM_GC.getTypeName());
        t.put("name", gcName);
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJVMMemoryObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JVM_MEMORY.getTypeName());
        t.put("name", MonitoredObjectType.JVM_MEMORY.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJVMThreadObjectName() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JVM_THREAD.getTypeName());
        t.put("name", MonitoredObjectType.JVM_THREAD.getTypeName());
        return MonitoringObjectNames.formObjectName(t);
    }

    static ObjectName getJVMThreadInfoObjectName(String threadName) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("type", MonitoredObjectType.JVM_THREAD_INFO.getTypeName());
        t.put("name", threadName);
        return MonitoringObjectNames.formObjectName(t);
    }
}

