/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss.provider;

import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ASOutputStream
extends OutputStream {
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private SocketChannel sc;
    private final Socket sock;
    private Selector selector;
    private boolean closed = false;
    private ByteBuffer bb = null;
    private byte[] bs = null;
    private byte[] b1 = null;

    ASOutputStream(SocketChannel sc, Socket sock) throws IOException {
        this.sc = sc;
        this.sock = sock;
        this.selector = Selector.open();
        this.sc.register(this.selector, 4);
    }

    public void close() throws IOException {
        block3: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.selector.close();
                this.selector = null;
                this.sc = null;
            }
            catch (Exception ie) {
                if (!logger.isLoggable(Level.FINE)) break block3;
                logger.log(Level.FINE, "" + ie.getMessage(), ie);
            }
        }
    }

    public void flush() throws IOException {
        this.checkClosed();
    }

    private void waitForSelect() throws IOException {
        Socket sock = this.sc.socket();
        if (sock.isClosed()) {
            this.close();
            throw new IOException("Socket closed");
        }
        try {
            Iterator<SelectionKey> it;
            block2: while (true) {
                SelectionKey selKey;
                this.selector.select();
                if (sock.isOutputShutdown() || sock.isClosed()) {
                    throw new IOException("Output Shutdown");
                }
                it = this.selector.selectedKeys().iterator();
                do {
                    if (!it.hasNext()) continue block2;
                } while (!(selKey = it.next()).isValid() || !selKey.isWritable());
                break;
            }
            it.remove();
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public synchronized void write(int b) throws IOException {
        if (this.b1 == null) {
            this.b1 = new byte[1];
        }
        this.b1[0] = (byte)b;
        this.write(this.b1);
    }

    public synchronized void write(byte[] bs, int off, int len) throws IOException {
        this.checkClosed();
        if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        ByteBuffer bb = this.bs == bs ? this.bb : ByteBuffer.wrap(bs);
        bb.limit(Math.min(off + len, bb.capacity()));
        bb.position(off);
        this.bb = bb;
        this.bs = bs;
        this.waitForSelect();
        while (bb.hasRemaining()) {
            this.sc.write(bb);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.sock.isOutputShutdown()) {
            throw new IOException("Output Shutdown");
        }
    }
}

