/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class UIViewRootCopy
extends UIViewRoot {
    public static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String UNIQUE_ID_PREFIX = "j_id";
    private static Lifecycle lifecycle;
    private int lastId = 0;
    private boolean skipPhase;
    private String renderKitId = null;
    private String viewId = null;
    private MethodExpression beforePhase = null;
    private MethodExpression afterPhase = null;
    private List<PhaseListener> phaseListeners = null;
    private transient List[] events = null;
    private Locale locale = null;

    public UIViewRootCopy() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "javax.faces.ViewRoot";
    }

    public String getRenderKitId() {
        String result = null;
        if (null != this.renderKitId) {
            result = this.renderKitId;
        } else {
            ValueExpression vb = this.getValueExpression("renderKitId");
            FacesContext context = this.getFacesContext();
            if (vb != null) {
                try {
                    result = (String)vb.getValue(context.getELContext());
                }
                catch (ELException e) {
                    result = null;
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    public void setRenderKitId(String renderKitId) {
        this.renderKitId = renderKitId;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public MethodExpression getBeforePhaseListener() {
        return this.beforePhase;
    }

    public void setBeforePhaseListener(MethodExpression newBeforePhase) {
        this.beforePhase = newBeforePhase;
    }

    public MethodExpression getAfterPhaseListener() {
        return this.afterPhase;
    }

    public void setAfterPhaseListener(MethodExpression newAfterPhase) {
        this.afterPhase = newAfterPhase;
    }

    public void removePhaseListener(PhaseListener toRemove) {
        if (null != this.phaseListeners) {
            this.phaseListeners.remove(toRemove);
        }
    }

    public void addPhaseListener(PhaseListener newPhaseListener) {
        if (null == this.phaseListeners) {
            this.phaseListeners = new ArrayList<PhaseListener>();
        }
        this.phaseListeners.add(newPhaseListener);
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        int i = 0;
        int len = 0;
        if (this.events == null) {
            len = PhaseId.VALUES.size();
            this.events = new List[len];
            for (i = 0; i < len; ++i) {
                this.events[i] = new ArrayList(5);
            }
        }
        this.events[event.getPhaseId().getOrdinal()].add(event);
    }

    protected void broadcastEvents(FacesContext context, PhaseId phaseId) {
        List eventsForPhaseId = null;
        if (null == this.events) {
            return;
        }
        boolean hasMoreAnyPhaseEvents = true;
        boolean hasMoreCurrentPhaseEvents = true;
        eventsForPhaseId = this.events[PhaseId.ANY_PHASE.getOrdinal()];
        do {
            UIComponent source;
            FacesEvent event;
            int cursor;
            if (null != eventsForPhaseId) {
                cursor = 0;
                while (cursor < eventsForPhaseId.size()) {
                    event = (FacesEvent)eventsForPhaseId.get(cursor);
                    source = event.getComponent();
                    try {
                        source.broadcast(event);
                    }
                    catch (AbortProcessingException e) {
                        // empty catch block
                    }
                    eventsForPhaseId.remove(cursor);
                }
            }
            if (null != (eventsForPhaseId = this.events[phaseId.getOrdinal()])) {
                cursor = 0;
                while (cursor < eventsForPhaseId.size()) {
                    event = (FacesEvent)eventsForPhaseId.get(cursor);
                    source = event.getComponent();
                    try {
                        source.broadcast(event);
                    }
                    catch (AbortProcessingException e) {
                        // empty catch block
                    }
                    eventsForPhaseId.remove(cursor);
                }
            }
            hasMoreAnyPhaseEvents = null != (eventsForPhaseId = this.events[PhaseId.ANY_PHASE.getOrdinal()]) && eventsForPhaseId.size() > 0;
            boolean bl = hasMoreCurrentPhaseEvents = null != this.events[phaseId.getOrdinal()] && this.events[phaseId.getOrdinal()].size() > 0;
        } while (hasMoreAnyPhaseEvents || hasMoreCurrentPhaseEvents);
    }

    public void processDecodes(FacesContext context) {
        this.skipPhase = false;
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(context, PhaseId.APPLY_REQUEST_VALUES, true);
        }
        if (!this.skipPhase) {
            super.processDecodes(context);
            this.broadcastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
        }
        if ((context.getRenderResponse() || context.getResponseComplete()) && this.events != null) {
            for (int i = 0; i < PhaseId.VALUES.size(); ++i) {
                List eventList = this.events[i];
                if (eventList == null) continue;
                eventList.clear();
            }
            this.events = null;
        }
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(context, PhaseId.APPLY_REQUEST_VALUES, false);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.skipPhase = false;
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(context, PhaseId.RENDER_RESPONSE, true);
        }
        if (!this.skipPhase) {
            super.encodeBegin(context);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        if (null != this.afterPhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(context, PhaseId.RENDER_RESPONSE, false);
        }
    }

    private void notifyPhaseListeners(FacesContext context, PhaseId phaseId, boolean isBefore) {
        MethodExpression expression;
        PhaseEvent event = this.createPhaseEvent(context, phaseId);
        boolean hasPhaseMethodExpression = isBefore && null != this.beforePhase || !isBefore && null != this.afterPhase;
        MethodExpression methodExpression = expression = isBefore ? this.beforePhase : this.afterPhase;
        if (hasPhaseMethodExpression) {
            try {
                expression.invoke(context.getELContext(), new Object[]{event});
                this.skipPhase = context.getResponseComplete() || context.getRenderResponse();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null != this.phaseListeners) {
            Iterator<PhaseListener> iter = this.phaseListeners.iterator();
            PhaseListener curListener = null;
            while (iter.hasNext()) {
                curListener = iter.next();
                if (phaseId != curListener.getPhaseId() && PhaseId.ANY_PHASE != curListener.getPhaseId()) continue;
                try {
                    if (isBefore) {
                        curListener.beforePhase(event);
                    } else {
                        curListener.afterPhase(event);
                    }
                    this.skipPhase = context.getResponseComplete() || context.getRenderResponse();
                }
                catch (Exception e) {}
            }
        }
    }

    private PhaseEvent createPhaseEvent(FacesContext context, PhaseId phaseId) throws FacesException {
        if (lifecycle == null) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = context.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        return new PhaseEvent(context, phaseId, lifecycle);
    }

    public void processValidators(FacesContext context) {
        this.skipPhase = false;
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(context, PhaseId.PROCESS_VALIDATIONS, true);
        }
        if (!this.skipPhase) {
            super.processValidators(context);
            this.broadcastEvents(context, PhaseId.PROCESS_VALIDATIONS);
        }
        if ((context.getRenderResponse() || context.getResponseComplete()) && this.events != null) {
            for (int i = 0; i < PhaseId.VALUES.size(); ++i) {
                List eventList = this.events[i];
                if (eventList == null) continue;
                eventList.clear();
            }
            this.events = null;
        }
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(context, PhaseId.PROCESS_VALIDATIONS, false);
        }
    }

    public void processUpdates(FacesContext context) {
        this.skipPhase = false;
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(context, PhaseId.UPDATE_MODEL_VALUES, true);
        }
        if (!this.skipPhase) {
            super.processUpdates(context);
            this.broadcastEvents(context, PhaseId.UPDATE_MODEL_VALUES);
        }
        if ((context.getRenderResponse() || context.getResponseComplete()) && this.events != null) {
            for (int i = 0; i < PhaseId.VALUES.size(); ++i) {
                List eventList = this.events[i];
                if (eventList == null) continue;
                eventList.clear();
            }
            this.events = null;
        }
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(context, PhaseId.UPDATE_MODEL_VALUES, false);
        }
    }

    public void processApplication(FacesContext context) {
        this.skipPhase = false;
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(context, PhaseId.INVOKE_APPLICATION, true);
        }
        if (!this.skipPhase) {
            this.broadcastEvents(context, PhaseId.INVOKE_APPLICATION);
        }
        if ((context.getRenderResponse() || context.getResponseComplete()) && this.events != null) {
            for (int i = 0; i < PhaseId.VALUES.size(); ++i) {
                List eventList = this.events[i];
                if (eventList == null) continue;
                eventList.clear();
            }
            this.events = null;
        }
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(context, PhaseId.INVOKE_APPLICATION, false);
        }
    }

    public String createUniqueId() {
        return UNIQUE_ID_PREFIX + this.lastId++;
    }

    public Locale getLocale() {
        Locale result = null;
        if (null != this.locale) {
            result = this.locale;
        } else {
            ValueExpression vb = this.getValueExpression("locale");
            FacesContext context = this.getFacesContext();
            if (vb != null) {
                Object resultLocale = null;
                try {
                    resultLocale = vb.getValue(context.getELContext());
                }
                catch (ELException e) {
                    // empty catch block
                }
                if (null == resultLocale) {
                    result = context.getApplication().getViewHandler().calculateLocale(context);
                } else if (resultLocale instanceof Locale) {
                    result = (Locale)resultLocale;
                } else if (resultLocale instanceof String) {
                    result = this.getLocaleFromString((String)resultLocale);
                }
            } else {
                result = context.getApplication().getViewHandler().calculateLocale(context);
            }
        }
        return result;
    }

    private Locale getLocaleFromString(String localeExpr) {
        Locale result = Locale.getDefault();
        if (localeExpr.indexOf("_") == -1 || localeExpr.indexOf("-") == -1) {
            if (localeExpr.length() == 2) {
                result = new Locale(localeExpr, "");
            }
        } else if (localeExpr.length() == 5) {
            String language = localeExpr.substring(0, 1);
            String country = localeExpr.substring(3, 4);
            result = new Locale(language, country);
        }
        return result;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        FacesContext.getCurrentInstance().getELContext().setLocale(locale);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.renderKitId, this.viewId, this.locale, new Integer(this.lastId), UIViewRootCopy.saveAttachedState((FacesContext)context, (Object)this.beforePhase), UIViewRootCopy.saveAttachedState((FacesContext)context, (Object)this.afterPhase), UIViewRootCopy.saveAttachedState((FacesContext)context, this.phaseListeners)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.renderKitId = (String)values[1];
        this.viewId = (String)values[2];
        this.locale = (Locale)values[3];
        this.lastId = (Integer)values[4];
        this.beforePhase = (MethodExpression)UIViewRootCopy.restoreAttachedState((FacesContext)context, (Object)values[5]);
        this.afterPhase = (MethodExpression)UIViewRootCopy.restoreAttachedState((FacesContext)context, (Object)values[6]);
        this.phaseListeners = (List)UIViewRootCopy.restoreAttachedState((FacesContext)context, (Object)values[7]);
    }
}

