/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.services.administration.providers.glassfish;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.clientreg.InstanceRegistry;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.jbi.jsf.framework.services.administration.providers.ServerEventBroadcaster;
import com.sun.jbi.jsf.framework.services.administration.providers.ServerEventListener;
import com.sun.jbi.jsf.framework.services.administration.providers.glassfish.ServerInformation;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerInformationImpl
implements ServerInformation,
NotificationListener,
ServerEventBroadcaster,
Serializable {
    private boolean mSupportsMultipleServers;
    private transient Logger mLog;
    private transient MBeanServer mMBeanServer;
    private transient MBeanServerConnection mbeanServerConnection;
    private transient InstanceRegistry mInstanceRegistry;
    private transient List<ServerEventListener> mListeners;
    private static final String SERVER = "server";
    private static final String INSTANCE_ROOT_KEY = "com.sun.aas.instanceRoot";
    private static final String INSTALL_ROOT_KEY = "com.sun.aas.installRoot";
    static final long serialVersionUID = -7234860345825372291L;

    public ServerInformationImpl() {
    }

    public ServerInformationImpl(MBeanServerConnection connection) throws InstanceNotFoundException, MalformedObjectNameException, NullPointerException, IOException {
        this.mbeanServerConnection = connection;
        this.initialize();
    }

    public ServerInformationImpl(MBeanServer server) throws InstanceNotFoundException, MalformedObjectNameException, NullPointerException, IOException {
        this.mMBeanServer = server;
        this.initialize();
    }

    private void initialize() throws InstanceNotFoundException, MalformedObjectNameException, NullPointerException, IOException {
        this.mLog = Logger.getLogger("com.sun.jbi.jsf.framework.services.administration.providers.glassfish");
        if (this.isDAS()) {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServer)mbeanServer).getDomainRoot();
            this.mSupportsMultipleServers = domainRoot.getSystemInfo().supportsFeature("SupportsMultipleServers");
            if (this.supportsMultipleServers()) {
                this.mInstanceRegistry = InstanceRegistry.getInstanceRegistry();
                if (this.mMBeanServer != null) {
                    this.mMBeanServer.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, null);
                } else {
                    this.mbeanServerConnection.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, null);
                }
            }
        }
    }

    @Override
    public Set<String> getClusterNames() throws ConfigException {
        ConfigContext context = this.getConfigContext();
        Cluster[] clusters = null;
        if (context != null) {
            clusters = ClusterHelper.getClustersInDomain((ConfigContext)context);
        }
        if (clusters != null) {
            return this.getClusterNames(clusters);
        }
        return Collections.synchronizedSet(new HashSet());
    }

    @Override
    public Set<String> getClusteredServerNames() throws ConfigException {
        Set<String> clusteredServers = Collections.synchronizedSet(new HashSet());
        Set<String> allClusters = this.getClusterNames();
        for (String clusterName : allClusters) {
            clusteredServers.addAll(this.getServersInCluster(clusterName));
        }
        this.mLog.fine("Clustered servers in the domain are " + clusteredServers.toString());
        return clusteredServers;
    }

    @Override
    public String getInstallRootKey() {
        return INSTALL_ROOT_KEY;
    }

    @Override
    public String getInstanceName() {
        return System.getProperty("com.sun.aas.instanceName");
    }

    @Override
    public String getInstanceRootKey() {
        return INSTANCE_ROOT_KEY;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(String instanceName, boolean forceNew) throws IOException {
        MBeanServerConnection connection;
        block5: {
            connection = null;
            try {
                if (instanceName == null) break block5;
                if (SERVER.equals(instanceName)) {
                    connection = this.mMBeanServer != null ? this.mMBeanServer : this.mbeanServerConnection;
                    break block5;
                }
                if ("domain".equals(instanceName)) break block5;
                if (this.isInstanceClustered(instanceName)) {
                    String clusterName = this.getTargetName(instanceName);
                    Set<String> serverNames = this.getServersInCluster(clusterName);
                    if (serverNames == null) break block5;
                    for (String serverName : serverNames) {
                        if (!instanceName.equalsIgnoreCase(serverName)) continue;
                        connection = InstanceRegistry.getInstanceConnection((String)serverName);
                        break block5;
                    }
                    break block5;
                }
                connection = InstanceRegistry.getInstanceConnection((String)instanceName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return connection;
    }

    @Override
    public Set<String> getServersInCluster(String clusterName) throws ConfigException {
        Server[] servers = ServerHelper.getServersInCluster((ConfigContext)this.getConfigContext(), (String)clusterName);
        Set<String> serverNames = this.getServerNames(servers);
        this.mLog.fine("Servers in cluster " + clusterName + " are " + serverNames.toString());
        return serverNames;
    }

    @Override
    public Set<String> getStandaloneServerNames() throws ConfigException {
        ConfigContext context = this.getConfigContext();
        Server[] servers = null;
        Set<String> serverNames = null;
        if (context != null && (servers = ServerHelper.getUnclusteredServers((ConfigContext)context, (boolean)false)) != null && (serverNames = this.getServerNames(servers)) != null) {
            this.mLog.fine("Unclustered servers in the domain are " + serverNames.toString());
            return serverNames;
        }
        return Collections.synchronizedSet(new HashSet());
    }

    @Override
    public String getTargetName() throws ConfigException {
        String instanceName = this.getInstanceName();
        return this.getTargetName(instanceName);
    }

    @Override
    public String getTargetName(String instanceName) throws ConfigException {
        String targetName = instanceName;
        if (this.isInstanceClustered(instanceName)) {
            targetName = this.getClusterForInstance(instanceName);
        }
        return targetName;
    }

    @Override
    public boolean isCluster(String targetName) throws ConfigException {
        return this.getClusterNames().contains(targetName);
    }

    @Override
    public boolean isClusteredServer(String targetName) throws ConfigException {
        return this.getClusteredServerNames().contains(targetName);
    }

    @Override
    public boolean isDAS() {
        AdminService adminService = AdminService.getAdminService();
        boolean isDAS = false;
        if (adminService != null) {
            isDAS = adminService.isDas();
        }
        return isDAS;
    }

    @Override
    public boolean isInstanceUp(String instanceName) throws MalformedObjectNameException, NullPointerException, IOException {
        boolean isRunning = false;
        if (SERVER.equals(instanceName)) {
            isRunning = true;
        } else {
            String instanceObjName = "amx:J2EEServer=" + instanceName + ",j2eeType=JVM,*";
            ObjectName objName = null;
            objName = new ObjectName(instanceObjName);
            Set<ObjectName> nameSet = null;
            nameSet = this.mMBeanServer != null ? this.mMBeanServer.queryNames(objName, null) : this.mbeanServerConnection.queryNames(objName, null);
            if (nameSet != null && !nameSet.isEmpty()) {
                isRunning = true;
            }
        }
        return isRunning;
    }

    @Override
    public boolean isStandaloneServer(String targetName) throws ConfigException {
        return this.getStandaloneServerNames().contains(targetName);
    }

    @Override
    public boolean isValidTarget(String targetName) throws ConfigException {
        boolean isValid = false;
        if (this.isCluster(targetName) || this.isStandaloneServer(targetName)) {
            isValid = true;
        }
        return isValid;
    }

    @Override
    public boolean supportsMultipleServers() {
        return this.mSupportsMultipleServers;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification mbnEvent = (MBeanServerNotification)notification;
            ObjectName objectName = mbnEvent.getMBeanName();
            if (this.isInstanceMBean(objectName)) {
                String instanceName = objectName.getKeyProperty("name");
                try {
                    if (this.isStandaloneServer(instanceName)) {
                        this.broadcastInstanceEvent(mbnEvent, instanceName);
                    }
                }
                catch (ConfigException e) {
                    e.printStackTrace();
                }
            } else if (this.isClusterMBean(objectName)) {
                String clusterName = objectName.getKeyProperty("name");
                this.broadcastClusterEvent(mbnEvent, clusterName);
            }
        }
    }

    @Override
    public void addListener(ServerEventListener listener) {
        this.getServerListeners().add(listener);
    }

    @Override
    public void removeListener(ServerEventListener listener) {
        List<ServerEventListener> listeners = this.getServerListeners();
        if (listeners.contains(listener)) {
            listeners.remove(listener);
        }
    }

    private List<ServerEventListener> getServerListeners() {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<ServerEventListener>();
        }
        return this.mListeners;
    }

    private boolean isInstanceMBean(ObjectName objectName) {
        return objectName.toString().startsWith("amx:j2eeType=J2EEServer,name=");
    }

    private boolean isClusterMBean(ObjectName objectName) {
        return objectName.toString().startsWith("amx:j2eeType=X-J2EECluster,name=");
    }

    private void broadcastInstanceEvent(MBeanServerNotification notification, String instanceName) {
        block7: {
            List<ServerEventListener> listeners;
            block6: {
                listeners = this.getServerListeners();
                if (!notification.getType().equalsIgnoreCase("JMX.mbean.registered")) break block6;
                for (ServerEventListener listener : listeners) {
                    try {
                        listener.createdStandaloneInstance(instanceName);
                    }
                    catch (Exception ex) {
                        this.mLog.warning(ex.getMessage());
                    }
                }
                break block7;
            }
            if (!notification.getType().equalsIgnoreCase("JMX.mbean.unregistered")) break block7;
            for (ServerEventListener listener : listeners) {
                try {
                    listener.deletedStandaloneInstance(instanceName);
                }
                catch (Exception ex) {
                    this.mLog.warning(ex.getMessage());
                }
            }
        }
    }

    private void broadcastClusterEvent(MBeanServerNotification notification, String clusterName) {
        block7: {
            List<ServerEventListener> listeners;
            block6: {
                listeners = this.getServerListeners();
                if (!notification.getType().equalsIgnoreCase("JMX.mbean.registered")) break block6;
                for (ServerEventListener listener : listeners) {
                    try {
                        listener.createdCluster(clusterName);
                    }
                    catch (Exception ex) {
                        this.mLog.warning(ex.getMessage());
                    }
                }
                break block7;
            }
            if (!notification.getType().equalsIgnoreCase("JMX.mbean.unregistered")) break block7;
            for (ServerEventListener listener : listeners) {
                try {
                    listener.deletedCluster(clusterName);
                }
                catch (Exception ex) {
                    this.mLog.warning(ex.getMessage());
                }
            }
        }
    }

    private boolean isInstanceClustered(String instanceName) throws ConfigException {
        boolean isClustered = false;
        ConfigContext context = this.getConfigContext();
        if (context != null) {
            isClustered = ServerHelper.isServerClustered((ConfigContext)context, (String)instanceName);
        }
        return isClustered;
    }

    private String getClusterForInstance(String instanceName) throws ConfigException {
        String clusterName = null;
        if (this.isInstanceClustered(instanceName)) {
            Cluster cluster = ClusterHelper.getClusterForInstance((ConfigContext)this.getConfigContext(), (String)instanceName);
            clusterName = cluster.getName();
        }
        return clusterName;
    }

    private ConfigContext getConfigContext() {
        ConfigContext context = null;
        if (this.isDAS()) {
            if (AdminService.getAdminService() != null) {
                context = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            }
        } else if (ApplicationServer.getServerContext() != null) {
            context = ApplicationServer.getServerContext().getConfigContext();
        }
        return context;
    }

    private Set<String> getServerNames(Server[] servers) {
        Set<String> unclusteredServers = Collections.synchronizedSet(new HashSet());
        for (int index = 0; index < servers.length; ++index) {
            unclusteredServers.add(servers[index].getName());
        }
        return unclusteredServers;
    }

    private Set<String> getClusterNames(Cluster[] clusters) {
        Set<String> domainClusters = Collections.synchronizedSet(new HashSet());
        for (int index = 0; index < clusters.length; ++index) {
            domainClusters.add(clusters[index].getName());
        }
        return domainClusters;
    }

    public static boolean registerMBean(MBeanServerConnection connection) {
        boolean result = false;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("com.sun.ebi:ServiceName=GlassFishServerInformation");
            if (!connection.isRegistered(objectName)) {
                Object[] params = new Object[]{connection};
                String[] signature = new String[]{MBeanServerConnection.class.getName()};
                connection.createMBean(ServerInformationImpl.class.getName(), objectName, params, signature);
            }
            result = true;
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
        catch (MBeanException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean registerMBean(MBeanServer connection) {
        boolean result = false;
        StandardMBean mbean = null;
        ServerInformationImpl serverInfo = null;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("com.sun.ebi:ServiceName=GlassFishServerInformation");
            if (!connection.isRegistered(objectName)) {
                serverInfo = new ServerInformationImpl(connection);
                mbean = new StandardMBean(serverInfo, ServerInformation.class);
                connection.registerMBean(mbean, objectName);
            }
            result = true;
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean unregisterMBean(MBeanServerConnection connection) {
        boolean result = false;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("com.sun.ebi:ServiceName=GlassFishServerInformation");
            if (connection.isRegistered(objectName)) {
                connection.unregisterMBean(objectName);
            }
            result = true;
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean unregisterMBean(MBeanServer connection) {
        boolean result = false;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("com.sun.ebi:ServiceName=GlassFishServerInformation");
            if (connection.isRegistered(objectName)) {
                connection.unregisterMBean(objectName);
            }
            result = true;
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return result;
    }

    static MBeanServer getMBeanServer() {
        MBeanServer server = null;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.size() > 0) {
            server = servers.get(0);
        }
        return server;
    }
}

