/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.services;

import com.sun.jbi.jsf.framework.connectors.ServerConnector;
import com.sun.jbi.jsf.framework.services.Service;
import com.sun.jbi.jsf.framework.services.administration.providers.glassfish.ServerInformation;
import com.sun.jbi.jsf.framework.services.administration.providers.glassfish.ServerInformationImpl;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class BaseServiceProvider
implements Service {
    protected ServerConnector serverConnector;
    protected MBeanServerConnection serverConnection = null;
    protected String targetName;
    protected ServerInformation serverInfo;
    private Logger logger = Logger.getLogger(BaseServiceProvider.class.getName());

    public BaseServiceProvider(ServerConnector connector, String targetName) {
        this.serverConnector = connector;
        this.serverConnection = this.serverConnector.getConnection();
        this.targetName = targetName;
        this.setup();
    }

    protected void setup() {
        try {
            this.serverInfo = new ServerInformationImpl(this.serverConnection);
            if (this.serverInfo.isDAS()) {
                this.serverConnection = this.serverInfo.getMBeanServerConnection(this.targetName, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object invoke(ObjectName objectName, String operationName) {
        String resultObject = null;
        try {
            if (this.serverConnection != null && this.serverConnection.isRegistered(objectName)) {
                resultObject = (String)this.serverConnection.invoke(objectName, operationName, null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultObject;
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] parameters) {
        Object result = null;
        String[] signature = this.getSignatures(parameters);
        try {
            if (this.serverConnection != null && this.serverConnection.isRegistered(objectName)) {
                result = this.serverConnection.invoke(objectName, operationName, parameters, signature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] parameters, String[] signatures) {
        Object result = null;
        try {
            if (this.serverConnection != null && this.serverConnection.isRegistered(objectName)) {
                result = this.serverConnection.invoke(objectName, operationName, parameters, signatures);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public long invokeLong(ObjectName objectName, String operationName, Object[] parameters) {
        Long result = (Long)this.invoke(objectName, operationName, parameters);
        long value = -1L;
        if (result != null) {
            value = result;
        }
        return value;
    }

    public Object getAttribute(ObjectName objectName, String attrName) {
        Object attrValue = null;
        try {
            if (this.serverConnection != null && this.serverConnection.isRegistered(objectName)) {
                attrValue = this.serverConnection.getAttribute(objectName, attrName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attrValue;
    }

    protected String[] getSignatures(Object[] params) {
        if (params == null || params.length == 0) {
            return null;
        }
        String[] signatures = new String[params.length];
        for (int index = 0; index < params.length; ++index) {
            signatures[index] = params[index] == null ? "java.lang.Object" : params[index].getClass().getName();
        }
        return signatures;
    }
}

