/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.model;

import com.sun.jbi.jsf.framework.common.Util;
import com.sun.jbi.jsf.framework.common.XmlUtils;
import com.sun.jbi.jsf.framework.model.JBIDescriptor;
import com.sun.jbi.jsf.framework.model.JBIEndpoint;
import com.sun.jbi.jsf.util.JBILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIServiceUnitDescriptor
extends JBIDescriptor {
    private List<JBIEndpoint> consumesEndpointList = new ArrayList<JBIEndpoint>();
    private List<JBIEndpoint> providesEndpointList = new ArrayList<JBIEndpoint>();
    private static Logger logger = JBILogger.getInstance();

    public JBIServiceUnitDescriptor() {
    }

    public JBIServiceUnitDescriptor(String xmlText) {
        super(xmlText);
    }

    public List<JBIEndpoint> getConsumesEndpointList() {
        return this.consumesEndpointList;
    }

    public List<JBIEndpoint> getProvidesEndpointList() {
        return this.providesEndpointList;
    }

    @Override
    public void parse() {
        Element servicesElement;
        super.parse();
        if (this.jbiElement != null && (servicesElement = XmlUtils.getChildElement(this.jbiElement, "services")) != null) {
            NodeList providesNodeList;
            this.consumesEndpointList.clear();
            this.providesEndpointList.clear();
            NodeList consumesNodeList = XmlUtils.getChildElements(servicesElement, "consumes");
            if (consumesNodeList != null) {
                for (int i = 0; i < consumesNodeList.getLength(); ++i) {
                    Element consumesElement = (Element)consumesNodeList.item(i);
                    JBIEndpoint consumesEndpoint = JBIEndpoint.create2(consumesElement);
                    this.consumesEndpointList.add(consumesEndpoint);
                }
            }
            if ((providesNodeList = XmlUtils.getChildElements(servicesElement, "provides")) != null) {
                for (int i = 0; i < providesNodeList.getLength(); ++i) {
                    Element providesElement = (Element)providesNodeList.item(i);
                    JBIEndpoint providesEndpoint = JBIEndpoint.create2(providesElement);
                    this.providesEndpointList.add(providesEndpoint);
                }
            }
        }
    }

    public Map getEndpoints(boolean isConsumer) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<JBIEndpoint> list = isConsumer ? this.consumesEndpointList : this.providesEndpointList;
        for (JBIEndpoint endpoint : list) {
            String endpointName = endpoint.getEndpointName();
            String serviceName = endpoint.getServiceName();
            String namespace = this.getNamespaceValue(Util.trimRight(serviceName, ":"));
            if (namespace == null) {
                namespace = "";
            }
            String localServiceName = Util.trimLeft(serviceName, ":");
            String fqEndpointName = namespace + "," + localServiceName + "," + endpointName;
            logger.finest(">>>> " + fqEndpointName);
            map.put(fqEndpointName, fqEndpointName);
        }
        return map;
    }

    public static void main(String[] args) {
        String xmlText = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><jbi xmlns=\"http://java.sun.com/xml/ns/jbi\" xmlns:ns1=\"http://localhost/SynchronousSample/SynchronousSample\" xmlns:ns2=\"http://enterprise.netbeans.org/bpel/SynchronousSample/SynchronousSample_1\" version=\"1.0\"> <services binding-component=\"true\"> <consumes endpoint-name=\"port1\" interface-name=\"ns1:portType1\" service-name=\"ns1:service1\"/> </services> </jbi>";
        JBIServiceUnitDescriptor desc = new JBIServiceUnitDescriptor(xmlText);
        desc.parse();
        Logger logger = JBILogger.getInstance();
        List<JBIEndpoint> list = desc.getConsumesEndpointList();
        for (JBIEndpoint ep : list) {
            logger.info("Consumes Endpoint: " + ep);
        }
        List<JBIEndpoint> pList = desc.getProvidesEndpointList();
        for (JBIEndpoint ep : pList) {
            logger.info("Provides Endpoint: " + ep);
        }
        logger.info(">>>> Consumes: " + desc.getEndpoints(true));
        logger.info(">>>> Provides: " + desc.getEndpoints(false));
    }
}

