/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.configuration.xml.schema;

import com.sun.jbi.jsf.util.JBILogger;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlDecimal;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class SchemaInstanceParser
implements Serializable {
    File[] schemaFiles;
    String[] schemaStrings;
    boolean allowNetworkDownloadsFlag;
    boolean disableParticleValidRestrictionFlag;
    boolean diableUniqueParticleAttributionFlag;
    SchemaTypeSystem schemaTypeSystem;
    SchemaType[] globalElements;
    private static Logger sLog = JBILogger.getInstance();

    public SchemaInstanceParser(File[] schemaFilesObjects, boolean allowNetworkDownloads, boolean disableParticleValidRestriction, boolean diableUniqueParticleAttribution) {
        this.schemaFiles = schemaFilesObjects;
        this.allowNetworkDownloadsFlag = allowNetworkDownloads;
        this.disableParticleValidRestrictionFlag = disableParticleValidRestriction;
        this.diableUniqueParticleAttributionFlag = diableUniqueParticleAttribution;
        this.initialize();
    }

    public SchemaInstanceParser(String[] schemaStringsObjects, boolean allowNetworkDownloads, boolean disableParticleValidRestriction, boolean diableUniqueParticleAttribution) {
        this.schemaStrings = schemaStringsObjects;
        this.allowNetworkDownloadsFlag = allowNetworkDownloads;
        this.disableParticleValidRestrictionFlag = disableParticleValidRestriction;
        this.diableUniqueParticleAttributionFlag = diableUniqueParticleAttribution;
        this.initialize();
    }

    void initialize() {
        XmlObject[] schemas = null;
        if (this.schemaFiles != null && this.schemaFiles.length > 0) {
            schemas = SchemaInstanceParser.processSchemaFiles(this.schemaFiles);
        } else if (this.schemaStrings != null && this.schemaStrings.length > 0) {
            schemas = SchemaInstanceParser.processSchemaStrings(this.schemaStrings);
        } else {
            return;
        }
        if (schemas != null && schemas.length > 0) {
            this.schemaTypeSystem = SchemaInstanceParser.compileSchema(schemas, this.allowNetworkDownloadsFlag, this.disableParticleValidRestrictionFlag, this.diableUniqueParticleAttributionFlag);
        }
        if (this.schemaTypeSystem != null) {
            this.globalElements = this.schemaTypeSystem.documentTypes();
        }
    }

    public static String[] getEnumeratedStringValues(SchemaType type) {
        XmlAnySimpleType[] enumeratedValues;
        String[] returnValues = null;
        if (type.hasStringEnumValues() && (enumeratedValues = type.getEnumerationValues()) != null && enumeratedValues.length > 0) {
            returnValues = new String[enumeratedValues.length];
            for (int index = 0; index < enumeratedValues.length; ++index) {
                returnValues[index] = enumeratedValues[index].getStringValue();
            }
        }
        return returnValues;
    }

    public SchemaType getGlobalSchemaTypeForName(String elementName) {
        if (this.globalElements == null || this.globalElements.length <= 0) {
            return null;
        }
        SchemaType element = null;
        for (int index = 0; index < this.globalElements.length; ++index) {
            if (!elementName.equals(this.globalElements[index].getDocumentElementName().getLocalPart())) continue;
            element = this.globalElements[index];
            break;
        }
        if (element == null) {
            sLog.fine("Could not find a global element with name \"" + elementName + "\"");
        }
        return element;
    }

    public static SchemaType getCoreType(QName elementName, SchemaType rootType) {
        SchemaType returnValue = null;
        SchemaProperty[] schemaProperties = rootType.getElementProperties();
        if (schemaProperties != null && schemaProperties.length > 0) {
            for (int index = 0; index < schemaProperties.length; ++index) {
                SchemaProperty[] innerProperties = schemaProperties[index].getType().getElementProperties();
                if (innerProperties == null || innerProperties.length <= 0) continue;
                for (int inner = 0; inner < innerProperties.length; ++inner) {
                    if (!elementName.equals(innerProperties[inner].getName())) continue;
                    returnValue = SchemaInstanceParser.findCoreType(innerProperties[inner].getType());
                }
            }
        }
        return returnValue;
    }

    public static SchemaType findCoreType(SchemaType elementType) {
        SchemaProperty[] properties = elementType.getElementProperties();
        SchemaType type = null;
        if (properties != null && properties.length > 0) {
            for (int index = 0; index < properties.length; ++index) {
                type = properties[index].getType();
                if (type == null) continue;
                type = SchemaInstanceParser.findCoreType(type);
            }
        } else {
            type = elementType.getBaseType();
        }
        return type;
    }

    public static XmlObject[] processSchemaFiles(File[] schemaFileArray) {
        if (schemaFileArray == null || schemaFileArray.length <= 0) {
            return null;
        }
        ArrayList<XmlObject> schemaDocuments = new ArrayList<XmlObject>();
        for (int index = 0; index < schemaFileArray.length; ++index) {
            try {
                schemaDocuments.add(XmlObject.Factory.parse((File)schemaFileArray[index], (XmlOptions)new XmlOptions().setLoadLineNumbers().setLoadMessageDigest()));
                continue;
            }
            catch (Exception exception) {
                sLog.fine("Can not load schema file: " + schemaFileArray[index] + ": ");
                exception.printStackTrace();
            }
        }
        XmlObject[] schemas = schemaDocuments.toArray(new XmlObject[schemaDocuments.size()]);
        return schemas;
    }

    public static XmlObject[] processSchemaStrings(String[] schemaFileArray) {
        if (schemaFileArray == null || schemaFileArray.length <= 0) {
            return null;
        }
        ArrayList<XmlObject> schemaDocuments = new ArrayList<XmlObject>();
        for (int index = 0; index < schemaFileArray.length; ++index) {
            try {
                schemaDocuments.add(XmlObject.Factory.parse((String)schemaFileArray[index], (XmlOptions)new XmlOptions().setLoadLineNumbers().setLoadMessageDigest()));
                continue;
            }
            catch (Exception exception) {
                sLog.fine("Can not load schema file: " + schemaFileArray[index] + ": ");
                exception.printStackTrace();
            }
        }
        XmlObject[] schemas = schemaDocuments.toArray(new XmlObject[schemaDocuments.size()]);
        return schemas;
    }

    public static SchemaTypeSystem compileSchema(XmlObject[] schemas, boolean allowNetworkDownloads, boolean disableParticleValidRestriction, boolean diableUniqueParticleAttribution) {
        if (schemas == null || schemas.length <= 0) {
            return null;
        }
        SchemaTypeSystem typeSystem = null;
        if (schemas.length > 0) {
            ArrayList errors = new ArrayList();
            XmlOptions compileOptions = new XmlOptions();
            if (allowNetworkDownloads) {
                compileOptions.setCompileDownloadUrls();
            }
            if (disableParticleValidRestriction) {
                compileOptions.setCompileNoPvrRule();
            }
            if (diableUniqueParticleAttribution) {
                compileOptions.setCompileNoUpaRule();
            }
            try {
                typeSystem = XmlBeans.compileXsd((XmlObject[])schemas, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)compileOptions);
            }
            catch (Exception exception) {
                if (errors.isEmpty() || !(exception instanceof XmlException)) {
                    exception.printStackTrace();
                }
                sLog.fine("Schema compilation errors: ");
                Iterator iterator = errors.iterator();
                while (iterator.hasNext()) {
                    sLog.fine((String)iterator.next());
                }
            }
        }
        if (typeSystem == null) {
            sLog.fine("No Schemas to process.");
        }
        return typeSystem;
    }

    public boolean isAllowNetworkDownloadsFlag() {
        return this.allowNetworkDownloadsFlag;
    }

    public void setAllowNetworkDownloadsFlag(boolean allowNetworkDownloadsFlag) {
        this.allowNetworkDownloadsFlag = allowNetworkDownloadsFlag;
    }

    public boolean isDiableUniqueParticleAttributionFlag() {
        return this.diableUniqueParticleAttributionFlag;
    }

    public void setDiableUniqueParticleAttributionFlag(boolean diableUniqueParticleAttributionFlag) {
        this.diableUniqueParticleAttributionFlag = diableUniqueParticleAttributionFlag;
    }

    public boolean isDisableParticleValidRestrictionFlag() {
        return this.disableParticleValidRestrictionFlag;
    }

    public void setDisableParticleValidRestrictionFlag(boolean disableParticleValidRestrictionFlag) {
        this.disableParticleValidRestrictionFlag = disableParticleValidRestrictionFlag;
    }

    public SchemaType[] getGlobalElements() {
        return this.globalElements;
    }

    public void setGlobalElements(SchemaType[] globalElements) {
        this.globalElements = globalElements;
    }

    public File[] getSchemaFiles() {
        return this.schemaFiles;
    }

    public void setSchemaFiles(File[] schemaFiles) {
        this.schemaFiles = schemaFiles;
    }

    public SchemaTypeSystem getSchemaTypeSystem() {
        return this.schemaTypeSystem;
    }

    public void setSchemaTypeSystem(SchemaTypeSystem schemaTypeSystem) {
        this.schemaTypeSystem = schemaTypeSystem;
    }

    public static int getDecimalFacet(SchemaType elementType, int facetType) {
        int value = -1;
        XmlDecimal decimal = (XmlDecimal)elementType.getFacet(facetType);
        if (decimal != null) {
            value = decimal.getBigDecimalValue().intValue();
        }
        return value;
    }

    public static void main(String[] args) {
        File[] schemaFiles = null;
        String fileLocation = args[0];
        File file = new File(fileLocation);
        schemaFiles = new File[]{file};
        boolean allowNetworkDownloadsFlag = false;
        boolean disableParticleValidRestrictionFlag = false;
        boolean diableUniqueParticleAttributionFlag = false;
        SchemaInstanceParser parser = new SchemaInstanceParser(schemaFiles, allowNetworkDownloadsFlag, disableParticleValidRestrictionFlag, diableUniqueParticleAttributionFlag);
        SchemaType[] types = parser.getGlobalElements();
        if (types != null) {
            for (int index = 0; index < types.length; ++index) {
                sLog.fine("QName: " + types[index].getDocumentElementName());
            }
        }
        QName qName = null;
        String prefix = types[0].getDocumentElementName().getPrefix();
        String namespaceURI = types[0].getDocumentElementName().getNamespaceURI();
        SchemaType coreType = null;
        String[] enumValues = null;
        String[] attributeNames = new String[]{"CachingStrategy", "MaximumEntries"};
        for (int count = 0; count < attributeNames.length; ++count) {
            qName = new QName(namespaceURI, attributeNames[count], prefix);
            coreType = SchemaInstanceParser.getCoreType(qName, types[0]);
            if (coreType == null) continue;
            sLog.fine(attributeNames[count] + " Core Type is:" + coreType.getName());
            sLog.fine(attributeNames[count] + " Core Base type is:" + coreType.getBaseType().getName());
            enumValues = SchemaInstanceParser.getEnumeratedStringValues(coreType);
            if (enumValues != null && enumValues.length > 0) {
                for (int index = 0; index < enumValues.length; ++index) {
                    sLog.fine(enumValues[index]);
                }
            }
            int totalDigits = 0;
            int minInclusive = 0;
            int maxInclusive = 0;
            totalDigits = SchemaInstanceParser.getDecimalFacet(coreType, 7);
            minInclusive = SchemaInstanceParser.getDecimalFacet(coreType, 4);
            maxInclusive = SchemaInstanceParser.getDecimalFacet(coreType, 5);
            sLog.fine("totalDigits=" + totalDigits + ", minInclusive=" + minInclusive + ", maxInclusive=" + maxInclusive);
            sLog.fine("////////////////////");
        }
    }
}

