/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.ClusterManager;
import com.sun.enterprise.jxtamgmt.ClusterViewEvent;
import com.sun.enterprise.jxtamgmt.ClusterViewEvents;
import com.sun.enterprise.jxtamgmt.HealthMessage;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import com.sun.enterprise.jxtamgmt.MasterNode;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.peer.PeerID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthMonitor
implements PipeMsgListener,
Runnable {
    private static final Logger LOG = JxtaUtil.getLogger(HealthMonitor.class.getName());
    private long timeout = 10000L;
    private long verifyTimeout = 10000L;
    private int maxMissedBeats = 3;
    private final String threadLock = new String("threadLock");
    private final Hashtable<PeerID, HealthMessage.Entry> cache = new Hashtable();
    private MasterNode masterNode = null;
    private ClusterManager manager = null;
    private final PeerID localPeerID;
    InputPipe inputPipe = null;
    private OutputPipe outputPipe = null;
    private PipeAdvertisement pipeAdv = null;
    private final PipeService pipeService;
    private volatile boolean started = false;
    private volatile boolean stop = false;
    private Thread healthMonitorThread = null;
    private Thread failureDetectorThread = null;
    private InDoubtPeerDetector inDoubtPeerDetector;
    private final String[] states = new String[]{"starting", "started", "alive", "clusterstopping", "peerstopping", "stopped", "dead", "indoubt", "unknown"};
    private static final short ALIVE = 2;
    private static final short CLUSTERSTOPPING = 3;
    private static final short PEERSTOPPING = 4;
    private static final short STOPPED = 5;
    private static final short DEAD = 6;
    private static final short INDOUBT = 7;
    private static final short UNKNOWN = 8;
    private static final String HEALTHM = "HM";
    private static final String NAMESPACE = "HEALTH";
    private static final String cacheLock = "cacheLock";
    private static final String verifierLock = "verifierLock";
    private Message aliveMsg = null;
    private transient Map<ID, OutputPipe> pipeCache = new Hashtable<ID, OutputPipe>();

    public HealthMonitor(ClusterManager manager, long timeout, int maxMissedBeats, long verifyTimeout) {
        this.timeout = timeout;
        this.maxMissedBeats = maxMissedBeats;
        this.verifyTimeout = verifyTimeout;
        this.manager = manager;
        this.masterNode = manager.getMasterNode();
        this.localPeerID = manager.getNetPeerGroup().getPeerID();
        this.pipeService = manager.getNetPeerGroup().getPipeService();
    }

    private Message createHealthMessage(short state) {
        Message msg = this.createMessage(state, HEALTHM, this.manager.getSystemAdvertisement());
        this.masterNode.addRoute(msg);
        return msg;
    }

    private Message createMessage(short state, String tag, SystemAdvertisement adv) {
        Message msg = new Message();
        HealthMessage hm = new HealthMessage();
        hm.setSrcID(this.localPeerID);
        HealthMessage.Entry entry = new HealthMessage.Entry(adv, this.states[state]);
        hm.add(entry);
        msg.addMessageElement(NAMESPACE, (MessageElement)new TextDocumentMessageElement(tag, (TextDocument)((XMLDocument)hm.getDocument(MimeMediaType.XMLUTF8)), null));
        return msg;
    }

    private Message getAliveMessage() {
        if (this.aliveMsg == null) {
            this.aliveMsg = this.createHealthMessage((short)2);
        }
        return this.aliveMsg;
    }

    private PipeAdvertisement createPipeAdv() {
        PipeAdvertisement pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        pipeAdv.setPipeID((ID)this.manager.getNetworkManager().getHealthPipeID());
        pipeAdv.setType("JxtaPropagate");
        return pipeAdv;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        if (this.manager.isStopping()) {
            return;
        }
        if (this.started) {
            try {
                Message msg = event.getMessage();
                if (msg != null) {
                    Message.ElementIterator iter = msg.getMessageElements();
                    while (iter.hasNext()) {
                        MessageElement msgElement = iter.next();
                        if (msgElement == null || !msgElement.getElementName().equals(HEALTHM)) continue;
                        HealthMessage hm = HealthMonitor.getHealthMessage(msgElement);
                        if (!hm.getSrcID().equals(this.localPeerID)) {
                            this.masterNode.processRoute(msg);
                        }
                        this.process(hm);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                LOG.log(Level.WARNING, "HealthMonitor:Caught IOException : " + ex.getLocalizedMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOG.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
    }

    private void process(HealthMessage hm) {
        if (!hm.getSrcID().equals(this.localPeerID)) {
            for (HealthMessage.Entry entry : hm.getEntries()) {
                this.cache.put(entry.id, entry);
                if (!this.manager.getClusterViewManager().containsKey((ID)entry.id)) {
                    try {
                        this.masterNode.probeNode(entry);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        LOG.warning("IOException occured while sending probeNode() Message in HealthMonitor:" + e.getLocalizedMessage());
                    }
                }
                if (entry.state.equals(this.states[4]) || entry.state.equals(this.states[3])) {
                    this.handleStopEvent(entry);
                }
                if (!entry.state.equals(this.states[7]) && !entry.state.equals(this.states[6])) continue;
                if (entry.id.equals(this.localPeerID)) {
                    this.reportMyState((short)2, hm.getSrcID());
                    continue;
                }
                if (entry.state.equals(this.states[7])) {
                    LOG.log(Level.FINE, "Peer " + entry.id.toString() + " is suspected failed. Its state is " + entry.state);
                    this.notifyLocalListeners(entry.state, entry.adv);
                }
                if (!entry.state.equals(this.states[6])) continue;
                LOG.log(Level.FINE, "Peer " + entry.id.toString() + " has failed. Its state is " + entry.state);
            }
        }
    }

    private void handleStopEvent(HealthMessage.Entry entry) {
        LOG.log(Level.FINEST, MessageFormat.format("Handling Stop Event for peer :{0}", entry.adv.getName()));
        short stateByte = 4;
        if (entry.state.equals(this.states[3])) {
            stateByte = 3;
        }
        if (entry.adv.getID().equals(this.masterNode.getMasterNodeID())) {
            LOG.log(Level.FINER, MessageFormat.format("Removing master node {0} from view as it has stopped.", entry.adv.getName()));
            this.removeMasterAdv(entry, stateByte);
            this.masterNode.resetMaster();
            this.masterNode.appointMasterNode();
        } else if (this.masterNode.isMaster() && this.masterNode.isMasterAssigned()) {
            this.removeMasterAdv(entry, stateByte);
            LOG.log(Level.FINE, "Announcing Peer Stop Event of " + entry.adv.getName() + " to group ...");
            ClusterViewEvent cvEvent = entry.state.equals(this.states[3]) ? new ClusterViewEvent(ClusterViewEvents.CLUSTER_STOP_EVENT, entry.adv) : new ClusterViewEvent(ClusterViewEvents.PEER_STOP_EVENT, entry.adv);
            this.masterNode.viewChanged(cvEvent);
        }
    }

    private Map<PeerID, HealthMessage.Entry> getCacheCopy() {
        Hashtable<PeerID, HealthMessage.Entry> clone = new Hashtable<PeerID, HealthMessage.Entry>();
        clone.putAll(this.cache);
        return clone;
    }

    private void reportMyState(short state, PeerID id) {
        if (state == 2) {
            this.send(id, this.getAliveMessage());
        } else {
            this.send(id, this.createHealthMessage(state));
        }
    }

    private void reportOtherPeerState(short state, SystemAdvertisement adv) {
        Message msg = this.createMessage(state, HEALTHM, adv);
        LOG.log(Level.FINEST, MessageFormat.format("Reporting {0} health state as {1}", adv.getName(), this.states[state]));
        this.send(null, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long actualto = this.timeout;
        this.reportMyState((short)2, null);
        while (!this.stop) {
            try {
                String string = this.threadLock;
                synchronized (string) {
                    this.threadLock.wait(actualto);
                }
                if (actualto < this.timeout) {
                    actualto = this.timeout;
                }
                this.reportMyState((short)2, null);
            }
            catch (InterruptedException e) {
                this.stop = true;
                LOG.log(Level.FINEST, "Shoal Health Monitor Thread Stopping as the thread is now interrupted...:" + e.getLocalizedMessage());
                break;
            }
            catch (Throwable all) {
                LOG.log(Level.WARNING, "Uncaught Throwable in healthMonitorThread " + Thread.currentThread().getName() + ":" + all);
            }
        }
    }

    private void send(PeerID peerid, Message msg) {
        try {
            if (peerid != null) {
                OutputPipe output;
                LOG.log(Level.FINE, "Unicasting Message to :" + peerid.toString());
                if (!this.pipeCache.containsKey(peerid)) {
                    output = this.pipeService.createOutputPipe(this.pipeAdv, Collections.singleton(peerid), 1L);
                    this.pipeCache.put((ID)peerid, output);
                } else {
                    output = this.pipeCache.get(peerid);
                    if (output.isClosed()) {
                        output = this.pipeService.createOutputPipe(this.pipeAdv, Collections.singleton(peerid), 1L);
                        this.pipeCache.put((ID)peerid, output);
                    }
                }
                output.send(msg);
            } else {
                this.outputPipe.send(msg);
            }
        }
        catch (IOException io) {
            LOG.log(Level.WARNING, "Failed to send message", io);
        }
    }

    void start() {
        if (!this.started) {
            LOG.log(Level.FINE, "Starting HealthMonitor");
            try {
                this.pipeAdv = this.createPipeAdv();
                this.inputPipe = this.pipeService.createInputPipe(this.pipeAdv, (PipeMsgListener)this);
                this.outputPipe = this.pipeService.createOutputPipe(this.pipeAdv, 1L);
                this.healthMonitorThread = new Thread((Runnable)this, "HealthMonitor");
                this.healthMonitorThread.start();
                this.inDoubtPeerDetector = new InDoubtPeerDetector();
                this.inDoubtPeerDetector.start();
                this.started = true;
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "Failed to create health monitoring pipe advertisement :" + ioe);
            }
        }
    }

    void announceStop(boolean isClusterShutdown) {
        LOG.log(Level.FINE, MessageFormat.format("Announcing stop event to group with clusterShutdown set to {0}", isClusterShutdown));
        if (isClusterShutdown) {
            this.reportMyState((short)3, null);
        } else {
            this.reportMyState((short)4, null);
        }
    }

    void stop() {
        this.reportMyState((short)5, null);
        LOG.log(Level.FINE, "Stopping HealthMonitor");
        this.stop = true;
        this.started = false;
        Thread tmpThread = this.healthMonitorThread;
        this.healthMonitorThread = null;
        if (tmpThread != null) {
            tmpThread.interrupt();
        }
        this.inDoubtPeerDetector.stop();
        this.inputPipe.close();
        this.outputPipe.close();
        this.pipeCache.clear();
    }

    private static HealthMessage getHealthMessage(MessageElement msgElement) throws IOException {
        HealthMessage hm = new HealthMessage((Element)HealthMonitor.getStructuredDocument(msgElement));
        return hm;
    }

    private static StructuredTextDocument getStructuredDocument(MessageElement msgElement) throws IOException {
        return (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)MimeMediaType.XMLUTF8, (InputStream)msgElement.getStream());
    }

    private void notifyLocalListeners(String state, SystemAdvertisement adv) {
        if (state.equals(this.states[7])) {
            this.manager.getClusterViewManager().setInDoubtPeerState(adv);
        } else if (state.equals(this.states[2])) {
            this.manager.getClusterViewManager().setPeerNoLongerInDoubtState(adv);
        } else if (state.equals(this.states[3])) {
            this.manager.getClusterViewManager().setClusterStoppingState(adv);
        } else if (state.equals(this.states[4])) {
            this.manager.getClusterViewManager().setPeerStoppingState(adv);
        }
    }

    public String getState(ID peerID) {
        HealthMessage.Entry entry = this.cache.get((PeerID)peerID);
        if (entry != null) {
            return entry.state;
        }
        return this.states[6];
    }

    private void assignAndReportFailure(HealthMessage.Entry entry) {
        if (entry != null) {
            entry.state = this.states[6];
            this.cache.put(entry.id, entry);
            if (this.masterNode.isMaster()) {
                LOG.log(Level.FINE, MessageFormat.format("Reporting Failed Node {0}", entry.id.toString()));
                this.reportOtherPeerState((short)6, entry.adv);
            }
            boolean masterFailed = this.masterNode.getMasterNodeID().equals(entry.id);
            if (this.masterNode.isMaster() && this.masterNode.isMasterAssigned()) {
                LOG.log(Level.FINE, MessageFormat.format("Removing System Advertisement :{0} for name {1}", entry.id.toString(), entry.adv.getName()));
                this.removeMasterAdv(entry, (short)6);
                LOG.log(Level.FINE, MessageFormat.format("Announcing Failure Event of {0} for name {1}...", entry.id, entry.adv.getName()));
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.FAILURE_EVENT, entry.adv);
                this.masterNode.viewChanged(cvEvent);
            } else if (masterFailed) {
                LOG.log(Level.FINE, MessageFormat.format("Master Failed. Removing System Advertisement :{0} for master named {1}", entry.id.toString(), entry.adv.getName()));
                this.removeMasterAdv(entry, (short)6);
                this.masterNode.resetMaster();
                this.masterNode.appointMasterNode();
            }
        }
    }

    private void removeMasterAdv(HealthMessage.Entry entry, short state) {
        this.manager.getClusterViewManager().remove(entry.adv);
        if (entry.adv != null) {
            switch (state) {
                case 6: {
                    LOG.log(Level.FINER, "FV: Notifying local listeners of Failure of " + entry.adv.getName());
                    this.manager.getClusterViewManager().notifyListeners(new ClusterViewEvent(ClusterViewEvents.FAILURE_EVENT, entry.adv));
                    break;
                }
                case 4: {
                    LOG.log(Level.FINER, "FV: Notifying local listeners of Shutdown of " + entry.adv.getName());
                    this.manager.getClusterViewManager().notifyListeners(new ClusterViewEvent(ClusterViewEvents.PEER_STOP_EVENT, entry.adv));
                    break;
                }
                case 3: {
                    this.manager.getClusterViewManager().notifyListeners(new ClusterViewEvent(ClusterViewEvents.CLUSTER_STOP_EVENT, entry.adv));
                    break;
                }
                default: {
                    LOG.log(Level.FINEST, MessageFormat.format("Invalid State for removing adv from view {0}", state));
                    break;
                }
            }
        } else {
            LOG.log(Level.WARNING, this.states[state] + " peer: " + entry.id + " does not exist in local ClusterView");
        }
    }

    public boolean isConnected(PeerID pid) {
        return this.masterNode.getRouteControl().isConnected(pid);
    }

    private class FailureVerifier
    implements Runnable {
        private final long buffer = 500L;

        private FailureVerifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String string = HealthMonitor.verifierLock;
                synchronized (HealthMonitor.verifierLock) {
                    while (!HealthMonitor.this.stop) {
                        LOG.log(Level.FINER, "FV: Entering verifierLock Wait....");
                        HealthMonitor.verifierLock.wait();
                        LOG.log(Level.FINER, "FV: Woken up from verifierLock Wait by a notify ....");
                        if (HealthMonitor.this.stop) continue;
                        LOG.log(Level.FINER, "FV: Calling verify() ....");
                        this.verify();
                        LOG.log(Level.FINER, "FV: Done verifying ....");
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (InterruptedException ex) {
                LOG.log(Level.FINEST, MessageFormat.format("failure Verifier Thread stopping as it is now interrupted: {0}", ex.getLocalizedMessage()));
            }
            {
                return;
            }
        }

        void verify() throws InterruptedException {
            Thread.sleep(HealthMonitor.this.verifyTimeout + 500L);
            Iterator i$ = HealthMonitor.this.getCacheCopy().values().iterator();
            while (i$.hasNext()) {
                HealthMessage.Entry entry1;
                HealthMessage.Entry entry = entry1 = (HealthMessage.Entry)i$.next();
                LOG.log(Level.FINER, "FV: Verifying state of " + entry.adv.getName() + " state = " + entry.state);
                if (!entry.state.equals(HealthMonitor.this.states[7]) || HealthMonitor.this.isConnected(entry.id)) continue;
                LOG.log(Level.FINER, "FV: Assigning and reporting failure ....");
                HealthMonitor.this.assignAndReportFailure(entry);
            }
        }

        private void reportLiveStateToLocalListeners(HealthMessage.Entry entry) {
        }
    }

    private class InDoubtPeerDetector
    implements Runnable {
        private static final long buffer = 500L;
        private final long maxTime;

        private InDoubtPeerDetector() {
            this.maxTime = HealthMonitor.this.timeout + 500L;
        }

        void start() {
            HealthMonitor.this.failureDetectorThread = new Thread((Runnable)this, "InDoubtPeerDetector Thread");
            LOG.log(Level.FINE, "Starting InDoubtPeerDetector Thread");
            HealthMonitor.this.failureDetectorThread.start();
            FailureVerifier fverifier = new FailureVerifier();
            Thread fvThread = new Thread((Runnable)fverifier, "FailureVerifier Thread");
            LOG.log(Level.FINE, "Starting FailureVerifier Thread");
            fvThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            Thread tmpThread = HealthMonitor.this.failureDetectorThread;
            HealthMonitor.this.failureDetectorThread = null;
            if (tmpThread != null) {
                tmpThread.interrupt();
            }
            String string = HealthMonitor.verifierLock;
            synchronized (HealthMonitor.verifierLock) {
                HealthMonitor.verifierLock.notify();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (!HealthMonitor.this.stop) {
                String string = HealthMonitor.cacheLock;
                // MONITORENTER : "cacheLock"
                try {
                    HealthMonitor.cacheLock.wait(HealthMonitor.this.timeout);
                    if (!HealthMonitor.this.manager.isStopping()) {
                        this.processCacheUpdate();
                    }
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.FINEST, "InDoubtPeerDetector Thread stopping as it is now interrupted :" + ex.getLocalizedMessage());
                    // MONITOREXIT : string
                    return;
                }
                catch (Throwable all) {
                    LOG.warning("Uncaught Throwable in failureDetectorThread " + Thread.currentThread().getName() + ":" + all);
                }
            }
        }

        int computeMissedBeat(HealthMessage.Entry entry) {
            return (int)((System.currentTimeMillis() - entry.timestamp) / HealthMonitor.this.timeout);
        }

        private void processCacheUpdate() {
            Map cacheCopy = HealthMonitor.this.getCacheCopy();
            for (HealthMessage.Entry entry : cacheCopy.values()) {
                if (!entry.state.equals(HealthMonitor.this.states[2])) continue;
                try {
                    this.determineInDoubtPeers(entry);
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.WARNING, "Exception occurred during time stamp conversion : " + nfe.getLocalizedMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void determineInDoubtPeers(HealthMessage.Entry entry) {
            if (!HealthMonitor.this.stop) {
                if (this.computeMissedBeat(entry) >= HealthMonitor.this.maxMissedBeats && !HealthMonitor.this.isConnected(entry.id)) {
                    LOG.log(Level.FINEST, "timeDiff > maxTime");
                    if (this.canProcessInDoubt(entry)) {
                        LOG.log(Level.FINER, "Designating InDoubtState");
                        this.designateInDoubtState(entry);
                        LOG.log(Level.FINER, "Notifying FailureVerifier for " + entry.adv.getName());
                        String string = HealthMonitor.verifierLock;
                        synchronized (HealthMonitor.verifierLock) {
                            HealthMonitor.verifierLock.notify();
                            LOG.log(Level.FINER, "Done Notifying FailureVerifier for " + entry.adv.getName());
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                        }
                    }
                } else if (!entry.id.equals(HealthMonitor.this.localPeerID) && this.canProcessInDoubt(entry)) {
                    LOG.log(Level.FINE, MessageFormat.format("For instance = {0}; last recorded heart-beat = {1}ms ago, heart-beat # {2} out of a max of {3}", entry.adv.getName(), System.currentTimeMillis() - entry.timestamp, this.computeMissedBeat(entry), HealthMonitor.this.maxMissedBeats));
                }
            }
        }

        private boolean canProcessInDoubt(HealthMessage.Entry entry) {
            boolean canProcessIndoubt = false;
            if (HealthMonitor.this.masterNode.getMasterNodeID().equals(entry.id)) {
                canProcessIndoubt = true;
            } else if (HealthMonitor.this.masterNode.isMaster()) {
                canProcessIndoubt = true;
            }
            return canProcessIndoubt;
        }

        private void designateInDoubtState(HealthMessage.Entry entry) {
            entry.state = HealthMonitor.this.states[7];
            HealthMonitor.this.cache.put(entry.id, entry);
            if (HealthMonitor.this.masterNode.isMaster()) {
                LOG.log(Level.FINE, "Sending INDOUBT state message about node ID: " + entry.id + " to the cluster...");
                HealthMonitor.this.reportOtherPeerState((short)7, entry.adv);
            }
            LOG.log(Level.FINEST, "Notifying Local Listeners of designated indoubt state for " + entry.adv.getName());
            HealthMonitor.this.notifyLocalListeners(entry.state, entry.adv);
        }
    }
}

