/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.GMSMember;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveryTargetSelector {
    static final String CORETYPE = GroupManagementService.MemberType.CORE.toString();
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");

    private RecoveryTargetSelector() {
    }

    public static boolean resolveRecoveryTarget(RecoverySelectorMode mode, List<GMSMember> members, String failedMemberToken, GMSContext ctx) {
        boolean recoveryServer = mode != null && mode.equals((Object)RecoverySelectorMode.HOSTSELECT) ? RecoveryTargetSelector.resolveWithHostSelectionAlgorithm(members, failedMemberToken, ctx.getGroupName()) : RecoveryTargetSelector.resolveWithSimpleSelectionAlgorithm(members, failedMemberToken, ctx.getGroupName());
        return recoveryServer;
    }

    private static boolean resolveWithHostSelectionAlgorithm(List<GMSMember> members, String failedMember, String groupName) {
        return false;
    }

    private static boolean resolveWithSimpleSelectionAlgorithm(List<GMSMember> viewCache, String failedMember, String groupName) {
        boolean recover = false;
        String recoverer = null;
        GMSContext ctx = GMSContextFactory.getGMSContext(groupName);
        String self = ctx.getServerIdentityToken();
        List<String> liveCache = RecoveryTargetSelector.getMemberTokens(viewCache, ctx.getSuspectList());
        logger.log(Level.FINE, "LiveCache = " + liveCache);
        List<String> vCache = RecoveryTargetSelector.getCoreMembers(viewCache);
        logger.log(Level.FINE, "vCache = " + vCache);
        for (int i = 0; i < vCache.size(); ++i) {
            block4: {
                block3: {
                    if (!vCache.get(i).equals(failedMember)) continue;
                    if (i != vCache.size() - 1) break block3;
                    String member = vCache.get(0);
                    logger.log(Level.FINEST, "Failed Member was last member of the previous view, The first live core member will be selected as recoverer");
                    logger.log(Level.FINEST, "First Core Member is " + member);
                    logger.log(Level.FINEST, "Live members are :" + liveCache.toString());
                    if (!liveCache.contains(member)) break block4;
                    recoverer = member;
                    break block4;
                }
                List<String> subset = vCache.subList(i + 1, vCache.size());
                for (String mem : subset) {
                    if (!liveCache.contains(mem)) continue;
                    recoverer = mem;
                    break;
                }
            }
            if (recoverer == null) continue;
            if (recoverer.equals(self)) {
                recover = true;
            }
            RecoveryTargetSelector.setRecoverySelectionState(recoverer, failedMember, groupName);
        }
        return recover;
    }

    private static List<String> getCoreMembers(List<GMSMember> viewCache) {
        ArrayList<String> temp = new ArrayList<String>();
        for (GMSMember member : viewCache) {
            if (!member.getMemberType().equals(CORETYPE)) continue;
            temp.add(member.getMemberToken());
        }
        return temp;
    }

    private static void dWait(long damperWaitOnMultiFails) {
        try {
            Thread.sleep(damperWaitOnMultiFails);
        }
        catch (InterruptedException e) {
            logger.log(Level.FINEST, e.getLocalizedMessage());
        }
    }

    public static void setRecoverySelectionState(String recovererMemberToken, String failedMemberToken, String groupName) {
        logger.log(Level.INFO, new StringBuffer().append("Appointed Recovery Server:").append(recovererMemberToken).append(":for failed member:").append(failedMemberToken).append(":for group:").append(groupName).toString());
        GMSContext ctx = GMSContextFactory.getGMSContext(groupName);
        DistributedStateCache dsc = ctx.getDistributedStateCache();
        Hashtable<String, FailureRecoveryActionFactory> reg = ctx.getRouter().getFailureRecoveryAFRegistrations();
        for (String component : reg.keySet()) {
            try {
                dsc.addToCache(component, recovererMemberToken, (Serializable)((Object)failedMemberToken), (Serializable)((Object)RecoveryTargetSelector.setStateAndTime()));
            }
            catch (GMSException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
    }

    private static String setStateAndTime() {
        return GroupManagementService.RECOVERY_STATE.RECOVERY_SERVER_APPOINTED.toString() + '|' + System.currentTimeMillis();
    }

    private static List<String> getMemberTokens(List<GMSMember> members, List<String> exclusionList) {
        ArrayList<String> temp = new ArrayList<String>();
        for (GMSMember member : members) {
            String token = member.getMemberToken();
            if (!member.getMemberType().equals(CORETYPE) || exclusionList.contains(token)) continue;
            temp.add(token);
        }
        logger.log(Level.FINEST, "SuspectedMembers: " + exclusionList.toString());
        logger.log(Level.FINEST, "LiveMembers: " + ((Object)temp).toString());
        return temp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecoverySelectorMode {
        SIMPLESELECT,
        HOSTSELECT;

    }
}

