/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.servicetags;

import com.sun.scn.servicetags.SvcTag;
import com.sun.scn.servicetags.util.XMLUtil;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent
implements Comparable<Agent> {
    private ArrayList<SvcTag> svcTags = new ArrayList();
    private ArrayList<String> svcTagURNs = new ArrayList();
    public String agentURN;
    public String receivedIPAddress;
    public Date receivedTimestamp;
    public Date timestamp = new Date();
    private int port;
    public String ipAddress;
    public String host;
    public String system;
    public String release;
    public String machine;
    public String architecture;
    public String platform;
    public String manufacturer;
    public String cpuManufacturer;
    public String serialNumber;
    public String hostid;
    public String agentVersion;
    public String helperVersion;

    public Agent(String agentURN) {
        this.agentURN = agentURN;
    }

    public static Agent getNew(String agentURN) {
        return new Agent(agentURN);
    }

    public void setState(Element e) {
        this.ipAddress = XMLUtil.getOptionalTextValue(e, "ip_address");
        NodeList sysInfoNodeList = e.getElementsByTagName("system_info");
        assert (sysInfoNodeList.getLength() == 1);
        Element e2 = (Element)sysInfoNodeList.item(0);
        this.host = XMLUtil.getRequiredTextValue(e2, "host");
        this.system = XMLUtil.getRequiredTextValue(e2, "system");
        this.release = XMLUtil.getRequiredTextValue(e2, "release");
        this.architecture = XMLUtil.getRequiredTextValue(e2, "architecture");
        this.platform = XMLUtil.getRequiredTextValue(e2, "platform");
        this.manufacturer = XMLUtil.getRequiredTextValue(e2, "manufacturer");
        if (this.manufacturer != null) {
            this.manufacturer = this.manufacturer.replace("_", " ");
        }
        this.cpuManufacturer = XMLUtil.getOptionalTextValue(e2, "cpu_manufacturer");
        if (this.cpuManufacturer != null) {
            this.cpuManufacturer = this.cpuManufacturer.replace("_", " ");
        }
        this.serialNumber = XMLUtil.getOptionalTextValue(e2, "serial_number");
        if (this.serialNumber == null) {
            this.serialNumber = "";
        }
        this.hostid = XMLUtil.getOptionalTextValue(e2, "hostid");
        if (this.hostid == null) {
            this.hostid = "";
        }
    }

    public void addSvcTagURN(String svcTagURN) {
        this.svcTagURNs.add(svcTagURN);
    }

    public synchronized void addSvcTag(SvcTag svcTag) {
        this.svcTags.add(svcTag);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getAgentURN() {
        return this.agentURN;
    }

    public String getHostid() {
        return this.hostid;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getCPUManufacturer() {
        return this.cpuManufacturer;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getHelperVersion() {
        return this.helperVersion;
    }

    public String getReceivedIPAddress() {
        return this.receivedIPAddress;
    }

    public Date getReceivedTimestamp() {
        return (Date)this.receivedTimestamp.clone();
    }

    public Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    public String getTimestampString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        return df.format(this.timestamp);
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public String getHost() {
        return this.host;
    }

    public String getSystem() {
        return this.system;
    }

    public String getRelease() {
        return this.release;
    }

    public String getMachine() {
        return this.machine;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public List<String> getSvcTagURNs() {
        return new ArrayList<String>(this.svcTagURNs);
    }

    public List<SvcTag> getSvcTags() {
        return new ArrayList<SvcTag>(this.svcTags);
    }

    public Element toXMLElement() throws Exception {
        return this.toXMLElement(false);
    }

    public Element toXMLElement(boolean deep) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<st1:request xmlns:st1=\"http://www.sun.com/stv1/agent\">\n").append(this.toXMLString(deep)).append("</st1:request>\n");
        InputSource is = new InputSource(new StringReader(sb.toString()));
        Document doc = builder.parse(is);
        return doc.getDocumentElement();
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean deep) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("<agent>\n", new Object[0]);
        fmt.format("  <agent_urn>%s</agent_urn>\n", this.agentURN);
        fmt.format("  <agent_timestamp>%s</agent_timestamp>\n", this.getTimestampString());
        fmt.format("  <system_info>\n", new Object[0]);
        fmt.format("    <system>%s</system>\n", this.encode(this.system));
        fmt.format("    <host>%s</host>\n", this.encode(this.host));
        fmt.format("    <release>%s</release>\n", this.encode(this.release));
        fmt.format("    <architecture>%s</architecture>\n", this.encode(this.architecture));
        fmt.format("    <platform>%s</platform>\n", this.encode(this.platform));
        fmt.format("    <manufacturer>%s</manufacturer>\n", this.encode(this.manufacturer));
        fmt.format("    <cpu_manufacturer>%s</cpu_manufacturer>\n", this.encode(this.cpuManufacturer));
        if (this.serialNumber != null && !this.serialNumber.equals("")) {
            fmt.format("    <serial_number>%s</serial_number>\n", this.encode(this.serialNumber));
        }
        if (this.hostid != null && !this.hostid.equals("")) {
            fmt.format("    <hostid>%s</hostid>\n", this.encode(this.hostid));
        }
        fmt.format("  </system_info>\n", new Object[0]);
        if (!deep) {
            for (String svcTagURN : this.svcTagURNs) {
                fmt.format("    <service_tag_urn>%s</service_tag_urn>\n", svcTagURN);
            }
        } else {
            for (SvcTag svcTag : this.svcTags) {
                fmt.format("%s", svcTag.toXMLString());
            }
        }
        fmt.format("</agent>\n", new Object[0]);
        return sb.toString();
    }

    public String toXMLString(List<SvcTag> tags) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("<agent>\n", new Object[0]);
        fmt.format("  <agent_urn>%s</agent_urn>\n", this.agentURN);
        fmt.format("  <agent_timestamp>%s</agent_timestamp>\n", this.getTimestampString());
        fmt.format("  <system_info>\n", new Object[0]);
        fmt.format("    <system>%s</system>\n", this.encode(this.system));
        fmt.format("    <host>%s</host>\n", this.encode(this.host));
        fmt.format("    <release>%s</release>\n", this.encode(this.release));
        fmt.format("    <architecture>%s</architecture>\n", this.encode(this.architecture));
        fmt.format("    <platform>%s</platform>\n", this.encode(this.platform));
        fmt.format("    <manufacturer>%s</manufacturer>\n", this.encode(this.manufacturer));
        fmt.format("    <cpu_manufacturer>%s</cpu_manufacturer>\n", this.encode(this.cpuManufacturer));
        fmt.format("  </system_info>\n", new Object[0]);
        for (SvcTag svcTag : tags) {
            fmt.format(svcTag.toXMLString(), new Object[0]);
        }
        fmt.format("</agent>\n", new Object[0]);
        return sb.toString();
    }

    @Override
    public int compareTo(Agent agent) {
        return this.getHost().compareTo(agent.getHost());
    }

    public String encode(String s) {
        if (s == null) {
            return s;
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return s;
        }
    }
}

