/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.helper;

import com.sun.appserv.management.ext.logging.LogModuleNames;
import com.sun.appserv.management.ext.logging.LogQuery;
import com.sun.appserv.management.ext.logging.LogQueryResult;
import com.sun.appserv.management.ext.logging.LogQueryResultImpl;
import com.sun.appserv.management.ext.logging.Logging;
import com.sun.appserv.management.helper.Helper;
import com.sun.appserv.management.util.misc.GSetUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggingHelper
extends Helper {
    private final Logging mLogging;

    public LoggingHelper(Logging logging) {
        super(logging.getDomainRoot());
        this.mLogging = logging;
    }

    public Logging getLogging() {
        return this.mLogging;
    }

    public LogQueryResult queryServerLog(String logLevel, Set<String> modules) {
        String name = "MostRecentLogFileName";
        boolean startIndex = false;
        boolean searchForward = true;
        int maxRecords = -1;
        Long startTime = null;
        Long stopTime = null;
        List<Attribute> attrs = null;
        assert (this.getLogging() != null);
        LogQueryResult result = this.getLogging().queryServerLog("MostRecentLogFileName", 0L, true, -1, startTime, stopTime, logLevel, modules, attrs);
        return result;
    }

    public LogQueryResult queryServerLog(String logLevel, String moduleID) {
        return this.queryServerLog(logLevel, GSetUtil.newSet(moduleID));
    }

    public LogQueryResult queryServerLog(String logLevel) {
        return this.queryServerLog(logLevel, LogModuleNames.ALL_NAMES);
    }

    public LogQueryResult queryAllCurrent() {
        return this.queryAllInFile("MostRecentLogFileName");
    }

    private long now() {
        return System.currentTimeMillis();
    }

    public LogQueryResult queryServerLogRecent(long seconds) {
        return this.queryServerLogRecent(seconds, LogModuleNames.ALL_NAMES);
    }

    public LogQueryResult queryServerLogRecent(long seconds, Set<String> modules) {
        String name = "MostRecentLogFileName";
        int startIndex = -1;
        boolean searchForward = false;
        int maxRecords = -1;
        Long startTime = this.now();
        Long stopTime = this.now() - seconds * 1000L;
        List<Attribute> attrs = null;
        LogQueryResult result = this.getLogging().queryServerLog("MostRecentLogFileName", -1L, false, -1, startTime, stopTime, LogQuery.LOWEST_SUPPORTED_QUERY_LEVEL, modules, attrs);
        return result;
    }

    public LogQueryResult queryAllInFile(String name) {
        boolean startIndex = false;
        boolean searchForward = true;
        int maxRecords = -1;
        Long startTime = null;
        Long stopTime = null;
        List<Attribute> attrs = null;
        LogQueryResult result = this.getLogging().queryServerLog(name, 0L, true, -1, startTime, stopTime, LogQuery.LOWEST_SUPPORTED_QUERY_LEVEL, LogModuleNames.ALL_NAMES, attrs);
        return result;
    }

    public LogQueryResult[] queryAll() {
        String[] names = this.getLogging().getLogFileNames("server");
        ArrayList<LogQueryResult> all = new ArrayList<LogQueryResult>(names.length);
        for (String name : names) {
            try {
                LogQueryResult result = this.queryAllInFile(name);
                all.add(result);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        LogQueryResultImpl[] results = new LogQueryResultImpl[all.size()];
        return all.toArray(results);
    }
}

