/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class StringHelper {
    private static final char BACKSLASH = '\\';
    private static final char QUOTE = '\"';

    public static String arrayToSeparatedList(List list, int beginIndex, int endIndex, String separator) {
        StringBuffer result = new StringBuffer();
        if (list != null) {
            int count = endIndex + 1;
            if (count > beginIndex && list.size() >= count) {
                result.append(list.get(beginIndex));
            }
            for (int i = beginIndex + 1; i < count; ++i) {
                result.append(separator + list.get(i));
            }
        }
        return result.toString();
    }

    public static String arrayToSeparatedList(List list, int beginIndex, int endIndex) {
        return StringHelper.arrayToSeparatedList(list, beginIndex, endIndex, ",");
    }

    public static String arrayToSeparatedList(List list, String separator) {
        return StringHelper.arrayToSeparatedList(list, 0, list != null ? list.size() - 1 : 0, separator);
    }

    public static String arrayToSeparatedList(List list) {
        return StringHelper.arrayToSeparatedList(list, 0, list != null ? list.size() - 1 : 0);
    }

    public static List separatedListToArray(String list, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (list != null) {
            StringTokenizer st = new StringTokenizer(list, separator);
            int size = st.countTokens();
            for (int i = 0; i < size; ++i) {
                result.add(st.nextToken());
            }
        }
        return result;
    }

    public static List separatedListToArray(String list) {
        return StringHelper.separatedListToArray(list, ",");
    }

    public static String intArrayToSeparatedList(int[] intArray, String separator) {
        return StringHelper.intArrayToSeparatedList(intArray, 0, intArray != null ? intArray.length - 1 : 0, separator);
    }

    public static String intArrayToSeparatedList(int[] intArray, int beginIndex, int endIndex, String separator) {
        StringBuffer result = new StringBuffer();
        if (intArray != null) {
            int count = endIndex + 1;
            if (count > beginIndex && intArray.length >= count) {
                result.append(intArray[beginIndex]);
            }
            for (int i = beginIndex + 1; i < count; ++i) {
                result.append(separator);
                result.append(intArray[i]);
            }
        }
        return result.toString();
    }

    public static boolean isEmpty(String aString) {
        return aString == null || aString.trim().length() == 0;
    }

    public static String getCapitalizedString(String aString) {
        if (StringHelper.isEmpty(aString)) {
            return aString;
        }
        return Character.toUpperCase(aString.charAt(0)) + aString.substring(1);
    }

    public static String replaceFirst(String string, String oldString, String newString) {
        int index = string.indexOf(oldString);
        if (index != -1) {
            StringBuffer sb = new StringBuffer(string.length());
            sb.append(string.substring(0, index));
            sb.append(newString);
            sb.append(string.substring(index + oldString.length()));
            return sb.toString();
        }
        return string;
    }

    public static String replace(String string, String oldString, String newString) {
        int index;
        StringBuffer sb = null;
        int l = oldString.length();
        int beginIndex = 0;
        while ((index = string.indexOf(oldString, beginIndex)) > -1) {
            if (sb == null) {
                sb = new StringBuffer(string.length());
            }
            sb.append(string.substring(beginIndex, index));
            sb.append(newString);
            beginIndex = index + l;
        }
        if (sb != null) {
            sb.append(string.substring(beginIndex));
        }
        return sb != null ? sb.toString() : string;
    }

    public static String rtrim(String input) {
        String retVal = input;
        if (input != null) {
            int lastCharIndex;
            int originalLastCharIndex = lastCharIndex = input.length() - 1;
            while (lastCharIndex >= 0 && Character.isSpaceChar(input.charAt(lastCharIndex))) {
                --lastCharIndex;
            }
            if (lastCharIndex != originalLastCharIndex) {
                retVal = input.substring(0, lastCharIndex + 1);
            }
        }
        return retVal;
    }

    public static String escape(String str) {
        if (str == null) {
            return str;
        }
        int indS = str.indexOf(92);
        int indQ = str.indexOf(34);
        if (indS == -1 && indQ == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        char[] data = str.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if ('\\' == data[i] || '\"' == data[i]) {
                buf.append('\\');
            }
            buf.append(data[i]);
        }
        return buf.toString();
    }
}

