/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.BaseProcessor;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.DeploymentHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Set;

public class CMPProcessor
extends BaseProcessor {
    public CMPProcessor(DeploymentEventInfo info, boolean create, String cliCreateTables, String cliDropAndCreateTables, String cliDropTables) {
        super(info, create, cliCreateTables, cliDropAndCreateTables, cliDropTables);
    }

    protected void processApplication() {
        Set bundleCollection = this.application.getEjbBundleDescriptors();
        if (bundleCollection == null) {
            return;
        }
        Iterator bundleItr = bundleCollection.iterator();
        while (bundleItr.hasNext()) {
            this.processAppBundle((EjbBundleDescriptor)bundleItr.next());
        }
    }

    private void processAppBundle(EjbBundleDescriptor bundle) {
        if (!bundle.containsCMPEntity()) {
            return;
        }
        ResourceReferenceDescriptor cmpResource = bundle.getCMPResourceReference();
        if (!DeploymentHelper.isJavaToDatabase(cmpResource.getSchemaGeneratorProperties())) {
            return;
        }
        boolean createTables = this.getCreateTablesValue(cmpResource);
        boolean dropTables = this.getDropTablesValue(cmpResource);
        if (this.debug) {
            logger.fine("ejb.CMPProcessor.createanddroptables", new Object[]{new Boolean(createTables), new Boolean(dropTables)});
        }
        if (!createTables && !dropTables) {
            return;
        }
        this.setApplicationLocation();
        this.setGeneratedLocation();
        this.constructJdbcFileNames(bundle);
        if (this.debug) {
            logger.fine("ejb.CMPProcessor.createanddropfilenames", this.createJdbcFileName, this.dropJdbcFileName);
        }
        String resourceName = cmpResource.getJndiName();
        if (dropTables) {
            this.executeStatements(this.dropJdbcFileName, resourceName);
        } else {
            this.executeStatements(this.createJdbcFileName, resourceName);
        }
    }

    protected boolean getCreateTablesValue(ResourceReferenceDescriptor cmpResource) {
        boolean createTables = this.create && (this.cliCreateTables.equals("true") || cmpResource.isCreateTablesAtDeploy() && this.cliCreateTables.equals("undefined"));
        return createTables;
    }

    protected boolean getDropTablesValue(ResourceReferenceDescriptor cmpResource) {
        boolean dropTables = !this.create && (this.cliDropAndCreateTables.equals("true") || this.cliDropTables.equals("true") || cmpResource.isDropTablesAtUndeploy() && this.cliDropAndCreateTables.equals("undefined") && this.cliDropTables.equals("undefined"));
        return dropTables;
    }

    private void constructJdbcFileNames(EjbBundleDescriptor ejbBundle) {
        String filePrefix = EJBHelper.getDDLNamePrefix(ejbBundle);
        this.createJdbcFileName = filePrefix + "_createDDL.jdbc";
        this.dropJdbcFileName = filePrefix + "_dropDDL.jdbc";
    }

    private void executeStatements(String fileName, String resourceName) {
        File file = this.getDDLFile(this.appGeneratedLocation + fileName, false);
        if (file.exists()) {
            this.executeDDLStatement(file, resourceName);
        } else {
            this.logI18NWarnMessage(this.create ? "ejb.BaseProcessor.cannotcreatetables" : "ejb.BaseProcessor.cannotdroptables", this.appRegisteredName, file.getName(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeDDLStatement(File fileName, String resourceName) {
        boolean result = false;
        Connection conn = null;
        Statement sql = null;
        try {
            try {
                conn = DeploymentHelper.getConnection(resourceName);
                sql = conn.createStatement();
                result = true;
            }
            catch (SQLException ex) {
                this.cannotConnect(resourceName, ex);
            }
            catch (JDOFatalUserException ex) {
                this.cannotConnect(resourceName, ex);
            }
            if (result) {
                this.executeDDLs(fileName, sql);
            }
        }
        catch (IOException e) {
            this.fileIOError(this.application.getRegistrationName(), e);
        }
        finally {
            CMPProcessor.closeConn(conn);
        }
        return result;
    }
}

