/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import com.sun.appserv.ProxyHandler;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.CoyotePrincipal;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UEncoder;

public class CoyoteAdapter
implements Adapter {
    private static Log log = LogFactory.getLog(CoyoteAdapter.class);
    public static final int ADAPTER_NOTES = 1;
    static final String JVM_ROUTE = System.getProperty("jvmRoute");
    protected static final boolean ALLOW_BACKSLASH = Boolean.valueOf(System.getProperty("org.apache.coyote.tomcat5.CoyoteAdapter.ALLOW_BACKSLASH", "false"));
    private static final boolean COLLAPSE_ADJACENT_SLASHES = Boolean.valueOf(System.getProperty("com.sun.enterprise.web.collapseAdjacentSlashes", "true"));
    private boolean compatWithTomcat = false;
    private String serverName = System.getProperty("product.name");
    private CoyoteConnector connector = null;
    private int debug = 0;
    private UEncoder urlEncoder = new UEncoder();
    protected StringManager sm = StringManager.getManager("org.apache.coyote.tomcat5");

    public CoyoteAdapter(CoyoteConnector connector) {
        this.connector = connector;
        this.debug = connector.getDebug();
        this.urlEncoder.addSafeCharacter('/');
    }

    public void service(Request req, Response res) throws Exception {
        block13: {
            CoyoteRequest request = (CoyoteRequest)req.getNote(1);
            CoyoteResponse response = (CoyoteResponse)res.getNote(1);
            if (request == null) {
                request = (CoyoteRequest)this.connector.createRequest();
                request.setCoyoteRequest(req);
                response = (CoyoteResponse)this.connector.createResponse();
                response.setCoyoteResponse(res);
                request.setResponse(response);
                response.setRequest(request);
                req.setNote(1, request);
                res.setNote(1, response);
                req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
            }
            if (!this.connector.isEnabled()) {
                String msg = this.sm.getString("coyoteAdapter.listenerOff", String.valueOf(this.connector.getPort()));
                if (log.isDebugEnabled()) {
                    log.debug(msg);
                }
                response.sendError(404, msg);
                return;
            }
            if (this.connector.isXpoweredBy()) {
                response.addHeader("X-Powered-By", "Servlet/2.5");
            }
            try {
                if (!this.postParseRequest(req, request, res, response)) break block13;
                boolean authPassthroughEnabled = this.connector.getAuthPassthroughEnabled();
                ProxyHandler proxyHandler = this.connector.getProxyHandler();
                if (authPassthroughEnabled && proxyHandler != null) {
                    if (proxyHandler.getSSLKeysize(request.getRequest()) > 0) {
                        request.setSecure(true);
                    }
                    X509Certificate[] certs = null;
                    try {
                        certs = proxyHandler.getSSLClientCertificateChain(request.getRequest());
                    }
                    catch (CertificateException ce) {
                        log.error(this.sm.getString("coyoteAdapter.proxyAuthCertError"), ce);
                    }
                    if (certs != null) {
                        request.setAttribute("javax.servlet.request.X509Certificate", certs);
                    }
                }
                response.addHeader("Server", this.serverName);
                this.connector.getContainer().invoke(request, response);
            }
            catch (IOException e) {
                request.recycle();
                response.recycle();
            }
            catch (Throwable t) {
                log.error(this.sm.getString("coyoteAdapter.service"), t);
                request.recycle();
                response.recycle();
            }
        }
        if (this.compatWithTomcat) {
            this.afterService(req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterService(Request req, Response res) throws Exception {
        CoyoteRequest request = (CoyoteRequest)req.getNote(1);
        CoyoteResponse response = (CoyoteResponse)res.getNote(1);
        if (request == null || response == null) {
            return;
        }
        try {
            response.finishResponse();
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (Throwable t) {
            log.error(this.sm.getString("coyoteAdapter.service"), t);
        }
        finally {
            request.recycle();
            response.recycle();
        }
    }

    protected boolean postParseRequest(Request req, CoyoteRequest request, Response res, CoyoteResponse response) throws Exception {
        String authtype;
        if (!req.scheme().isNull()) {
            request.setSecure(req.scheme().equals("https"));
        } else {
            req.scheme().setString(this.connector.getScheme());
            request.setSecure(this.connector.getSecure());
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            req.setServerPort(proxyPort);
        }
        if (proxyName != null) {
            req.serverName().setString(proxyName);
        }
        MessageBytes decodedURI = req.decodedURI();
        decodedURI.duplicate(req.requestURI());
        try {
            req.getURLDecoder().convert(decodedURI, false);
        }
        catch (IOException ioe) {
            res.setStatus(400);
            res.setMessage("Invalid URI: " + ioe.getMessage());
            return false;
        }
        String principal = req.getRemoteUser().toString();
        if (principal != null) {
            request.setUserPrincipal(new CoyotePrincipal(principal));
        }
        if ((authtype = req.getAuthType().toString()) != null) {
            request.setAuthType(authtype);
        }
        request.convertURI(decodedURI);
        if (!CoyoteAdapter.normalize(decodedURI)) {
            res.setStatus(400);
            res.setMessage("Invalid URI");
            return false;
        }
        request.parseSessionId();
        CharChunk uriCC = decodedURI.getCharChunk();
        int semicolon = uriCC.indexOf(';');
        String sessionVersionString = null;
        if (semicolon > 0) {
            sessionVersionString = request.parseSessionVersion();
            decodedURI.setChars(uriCC.getBuffer(), uriCC.getStart(), semicolon);
        }
        this.connector.getMapper().map(req.serverName(), decodedURI, request.getMappingData());
        request.setDefaultContext(request.getMappingData().isDefaultContext);
        Context ctx = (Context)request.getMappingData().context;
        request.setContext(ctx);
        request.setWrapper((Wrapper)request.getMappingData().wrapper);
        if (!this.connector.getAllowTrace() && req.method().equalsIgnoreCase("TRACE")) {
            String[] methods;
            Wrapper wrapper = request.getWrapper();
            String header = null;
            if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                for (int i = 0; i < methods.length; ++i) {
                    if ("TRACE".equals(methods[i])) continue;
                    header = header == null ? methods[i] : header + ", " + methods[i];
                }
            }
            res.setStatus(405);
            res.addHeader("Allow", header);
            res.setMessage("TRACE method is not allowed");
            return false;
        }
        MessageBytes redirectPathMB = request.getMappingData().redirectPath;
        if (!(redirectPathMB.isNull() || ctx.hasAdHocPaths() && ctx.getAdHocServletName(request.getRequest().getServletPath()) != null)) {
            String redirectPath = redirectPathMB.toString();
            String query = request.getQueryString();
            if (request.isRequestedSessionIdFromURL()) {
                redirectPath = redirectPath + ";jsessionid=" + request.getRequestedSessionId();
            }
            redirectPath = this.urlEncoder.encodeURL(redirectPath);
            if (query != null) {
                redirectPath = redirectPath + "?" + query;
            }
            boolean authPassthroughEnabled = this.connector.getAuthPassthroughEnabled();
            ProxyHandler proxyHandler = this.connector.getProxyHandler();
            if (authPassthroughEnabled && proxyHandler != null && proxyHandler.getSSLKeysize(request.getRequest()) > 0) {
                request.setSecure(true);
            }
            response.sendRedirect(redirectPath);
            return false;
        }
        request.parseSessionCookiesId();
        request.parseJrouteCookie();
        if (sessionVersionString != null) {
            request.parseSessionVersionString(sessionVersionString);
        }
        return true;
    }

    public static boolean normalize(MessageBytes uriMB) {
        int type = uriMB.getType();
        if (type == 3) {
            return CoyoteAdapter.normalizeChars(uriMB);
        }
        return CoyoteAdapter.normalizeBytes(uriMB);
    }

    private static boolean normalizeBytes(MessageBytes uriMB) {
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        int end = uriBC.getEnd();
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                if (ALLOW_BACKSLASH) {
                    b[pos] = 47;
                } else {
                    return false;
                }
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (b[pos] != 47) continue;
                while (pos + 1 < end && b[pos + 1] == 47) {
                    CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    private static boolean normalizeChars(MessageBytes uriMB) {
        CharChunk uriCC = uriMB.getCharChunk();
        char[] c = uriCC.getChars();
        int start = uriCC.getStart();
        int end = uriCC.getEnd();
        if (end - start == 1 && c[start] == '*') {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                if (ALLOW_BACKSLASH) {
                    c[pos] = 47;
                } else {
                    return false;
                }
            }
            if (c[pos] != '\u0000') continue;
            return false;
        }
        if (c[start] != '/') {
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (c[pos] != '/') continue;
                while (pos + 1 < end && c[pos + 1] == '/') {
                    CoyoteAdapter.copyChars(c, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            c[end] = 47;
            ++end;
        }
        uriCC.setEnd(end);
        index = 0;
        while ((index = uriCC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyChars(c, start + index, start + index + 2, end - start - index - 2);
            uriCC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriCC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (c[pos] != '/') continue;
                index2 = pos;
            }
            CoyoteAdapter.copyChars(c, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriCC.setEnd(end);
            index = index2;
        }
        uriCC.setChars(c, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    private static void copyChars(char[] c, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            c[pos + dest] = c[pos + src];
        }
    }

    protected void log(String message) {
        log.info(message);
    }

    protected void log(String message, Throwable throwable) {
        log.error(message, throwable);
    }

    public void fireAdapterEvent(String type, Object data) {
        if (this.connector != null && this.connector.getContainer() != null) {
            try {
                ((ContainerBase)this.connector.getContainer()).fireContainerEvent(type, data);
            }
            catch (Throwable t) {
                log.error(this.sm.getString("coyoteAdapter.service"), t);
            }
        }
    }

    public boolean isCompatWithTomcat() {
        return this.compatWithTomcat;
    }

    public void setCompatWithTomcat(boolean compatWithTomcat) {
        this.compatWithTomcat = compatWithTomcat;
        this.serverName = compatWithTomcat ? "Apache/" + this.serverName : System.getProperty("product.name");
    }
}

