/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.PWCKeepAliveStats;
import com.sun.enterprise.web.stats.StatsUtil;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public final class PWCKeepAliveStatsImpl
implements PWCKeepAliveStats {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private GenericStatsImpl baseStatsImpl = new GenericStatsImpl(PWCKeepAliveStats.class, (Object)this);
    private MBeanServer server;
    private ObjectName keepAliveName;
    private MutableCountStatistic countConnections;
    private MutableCountStatistic maxConnections;
    private MutableCountStatistic countHits;
    private MutableCountStatistic countFlushes;
    private MutableCountStatistic countRefusals;
    private MutableCountStatistic countTimeouts;
    private MutableCountStatistic secondsTimeouts;

    public PWCKeepAliveStatsImpl(String domain) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        String objNameStr = domain + ":type=PWCKeepAlive,*";
        try {
            this.keepAliveName = new ObjectName(objNameStr);
        }
        catch (Throwable t) {
            String msg = _logger.getResourceBundle().getString("webcontainer.objectNameCreationError");
            msg = MessageFormat.format(msg, objNameStr);
            _logger.log(Level.SEVERE, msg, t);
        }
        this.initializeStatistics();
    }

    public CountStatistic getCountConnections() {
        this.countConnections.setCount((long)StatsUtil.getAggregateStatistic(this.server, this.keepAliveName, "countConnections"));
        return (CountStatistic)this.countConnections.unmodifiableView();
    }

    public CountStatistic getMaxConnections() {
        this.maxConnections.setCount((long)StatsUtil.getConstant(this.server, this.keepAliveName, "maxConnections"));
        return (CountStatistic)this.maxConnections.unmodifiableView();
    }

    public CountStatistic getCountHits() {
        this.countHits.setCount((long)StatsUtil.getAggregateStatistic(this.server, this.keepAliveName, "countHits"));
        return (CountStatistic)this.countHits.unmodifiableView();
    }

    public CountStatistic getCountFlushes() {
        this.countFlushes.setCount((long)StatsUtil.getAggregateStatistic(this.server, this.keepAliveName, "countFlushes"));
        return (CountStatistic)this.countFlushes.unmodifiableView();
    }

    public CountStatistic getCountRefusals() {
        this.countRefusals.setCount((long)StatsUtil.getAggregateStatistic(this.server, this.keepAliveName, "countRefusals"));
        return (CountStatistic)this.countRefusals.unmodifiableView();
    }

    public CountStatistic getCountTimeouts() {
        this.countTimeouts.setCount((long)StatsUtil.getAggregateStatistic(this.server, this.keepAliveName, "countTimeouts"));
        return (CountStatistic)this.countTimeouts.unmodifiableView();
    }

    public CountStatistic getSecondsTimeouts() {
        this.secondsTimeouts.setCount((long)StatsUtil.getConstant(this.server, this.keepAliveName, "secondsTimeouts"));
        return (CountStatistic)this.secondsTimeouts.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String name) {
        return this.baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl c = null;
        c = new CountStatisticImpl("CountConnections");
        this.countConnections = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxConnections");
        this.maxConnections = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountHits");
        this.countHits = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountFlushes");
        this.countFlushes = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountRefusals");
        this.countRefusals = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountTimeouts");
        this.countTimeouts = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("SecondsTimeouts");
        this.secondsTimeouts = new MutableCountStatisticImpl((CountStatistic)c);
    }
}

