/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.Management;
import com.sun.enterprise.web.connector.grizzly.SecureSelector;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.blocking.SelectorBlockingThread;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLSelectorThread;
import com.sun.enterprise.web.portunif.HttpProtocolFinder;
import com.sun.enterprise.web.portunif.HttpProtocolHandler;
import com.sun.enterprise.web.portunif.PortUnificationPipeline;
import com.sun.enterprise.web.portunif.ProtocolFinder;
import com.sun.enterprise.web.portunif.ProtocolHandler;
import com.sun.enterprise.web.portunif.TlsProtocolFinder;
import com.sun.org.apache.commons.modeler.Registry;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.apache.coyote.http11.Http11Protocol;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;

public class GrizzlyHttpProtocol
extends Http11Protocol {
    private int socketBuffer = 9000;
    private SelectorThread selectorThread;
    private Management jmxManagement = null;
    private String compression = "off";
    private String noCompressionUserAgents = null;
    private String restrictedUserAgents = null;
    private String compressableMimeTypes = "text/html,text/xml,text/plain";
    private int compressionMinSize = 2048;
    private String proxiedProtocols;
    private static final ConcurrentLinkedQueue<String> supportedHandlers = new ConcurrentLinkedQueue();
    private static final ConcurrentHashMap<String, String> supportedProtocols = new ConcurrentHashMap();
    private static final String TLS = "tls";
    private static final String HTTP = "http";

    public GrizzlyHttpProtocol(boolean secure, boolean blocking, String selectorThreadImpl) {
        super(secure, blocking, selectorThreadImpl);
    }

    protected void create() {
        if (this.blocking) {
            this.selectorThread = new SelectorBlockingThread();
            ((SelectorBlockingThread)this.selectorThread).setSecure(this.secure);
        } else if (!this.secure) {
            if (this.selectorThreadImpl != null) {
                try {
                    Class<?> clazz = Class.forName(this.selectorThreadImpl);
                    this.selectorThread = (SelectorThread)clazz.newInstance();
                }
                catch (Throwable t) {
                    GrizzlyHttpProtocol grizzlyHttpProtocol = this;
                    grizzlyHttpProtocol.selectorThread.logger().log(Level.WARNING, "Unable to load SelectorThread: " + this.selectorThreadImpl, t);
                }
            }
            if (this.selectorThread == null) {
                this.selectorThread = new SelectorThread();
            }
        } else {
            this.selectorThread = new SSLSelectorThread();
        }
        this.setSoLinger(-1);
        this.setSoTimeout(30000);
        this.setServerSoTimeout(0);
        this.setTcpNoDelay(true);
    }

    public void init() throws Exception {
        try {
            this.checkSocketFactory();
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "grizzlyHttpProtocol.socketfactory.initerror", ex);
            throw ex;
        }
        if (this.socketFactory != null) {
            Enumeration attE = this.attributes.keys();
            while (attE.hasMoreElements()) {
                String key = (String)attE.nextElement();
                Object v = this.attributes.get(key);
                this.socketFactory.setAttribute(key, v);
            }
        }
        if (this.secure && !this.blocking) {
            this.socketFactory.init();
            ((SSLSelectorThread)this.selectorThread).setSSLContext(this.socketFactory.getSSLContext());
        }
        try {
            this.selectorThread.setAdapter(this.adapter);
            if (this.proxiedProtocols != null || System.getProperty("com.sun.enterprise.web.connector.grizzly.protocolHandlers") != null) {
                this.selectorThread.pipelineClassName = PortUnificationPipeline.class.getName();
            }
            this.selectorThread.initEndpoint();
            if (this.proxiedProtocols != null && !this.blocking) {
                this.configureProxiedProtocols();
            }
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.initerror", ex);
            throw ex;
        }
    }

    public void start() throws Exception {
        try {
            if (this.oname != null) {
                this.jmxManagement = new ModelerManagement();
                this.selectorThread.setManagement(this.jmxManagement);
                try {
                    ObjectName sname = new ObjectName(this.domain + ":type=Selector,name=http" + this.selectorThread.getPort());
                    this.jmxManagement.registerComponent(this.selectorThread, sname, null);
                }
                catch (Exception ex) {
                    SelectorThread.logger().log(Level.SEVERE, "grizzlyHttpProtocol.selectorRegistrationFailed", ex);
                }
            } else {
                SelectorThread.logger().log(Level.INFO, "grizzlyHttpProtocol.selectorRegisterProtocol");
            }
            this.selectorThread.start();
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.starterror", ex);
            throw ex;
        }
        SelectorThread.logger().log(Level.INFO, "grizzlyHttpProtocol.start", String.valueOf(this.getPort()));
    }

    public void destroy() throws Exception {
        SelectorThread.logger().log(Level.INFO, "grizzlyHttpProtocol.stop", String.valueOf(this.getPort()));
        if (this.domain != null) {
            this.jmxManagement.unregisterComponent(new ObjectName(this.domain, "type", "Selector"));
        }
        this.selectorThread.stopEndpoint();
    }

    public int getMaxThreads() {
        return this.selectorThread.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.selectorThread.setMaxThreads(maxThreads);
        this.setAttribute("maxThreads", "" + maxThreads);
    }

    public void setMaxPostSize(int maxPostSize) {
        this.selectorThread.setMaxPostSize(maxPostSize);
        this.setAttribute("maxPostSize", maxPostSize);
    }

    public int getProcessorThreadsIncrement() {
        return this.selectorThread.getThreadsIncrement();
    }

    public void setProcessorThreadsIncrement(int threadsIncrement) {
        this.selectorThread.setThreadsIncrement(threadsIncrement);
        this.setAttribute("threadsIncrement", "" + threadsIncrement);
    }

    public void setProcessorWorkerThreadsTimeout(int timeout) {
        this.selectorThread.setThreadsTimeout(timeout);
        this.setAttribute("threadsTimeout", "" + timeout);
    }

    public int getProcessorWorkerThreadsTimeout() {
        return this.selectorThread.getThreadsTimeout();
    }

    public int getBacklog() {
        return this.selectorThread.getSsBackLog();
    }

    public void setBacklog(int i) {
    }

    public int getPort() {
        return this.selectorThread.getPort();
    }

    public void setPort(int port) {
        this.selectorThread.setPort(port);
        this.setAttribute("port", "" + port);
    }

    public InetAddress getAddress() {
        return this.selectorThread.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.selectorThread.setAddress(ia);
        this.setAttribute("address", "" + ia);
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "http-" + encodedAddr + this.selectorThread.getPort();
    }

    public boolean getTcpNoDelay() {
        return this.selectorThread.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean b) {
        this.selectorThread.setTcpNoDelay(b);
        this.setAttribute("tcpNoDelay", "" + b);
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
        this.selectorThread.setDisableUploadTimeout(this.disableUploadTimeout);
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int valueI) {
        this.socketBuffer = valueI;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        super.setMaxHttpHeaderSize(maxHttpHeaderSize);
        this.selectorThread.setMaxHttpHeaderSize(maxHttpHeaderSize);
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
        this.selectorThread.setCompression(this.compression);
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
        this.selectorThread.setRestrictedUserAgents(valueS);
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
        this.selectorThread.setNoCompressionUserAgents(valueS);
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
        this.selectorThread.setCompressableMimeTypes(valueS);
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
        this.selectorThread.setCompressionMinSize(valueI);
    }

    public int getSoLinger() {
        return this.selectorThread.getSoLinger();
    }

    public void setSoLinger(int i) {
        this.selectorThread.setSoLinger(i);
        this.setAttribute("soLinger", "" + i);
    }

    public int getSoTimeout() {
        return this.selectorThread.getSoTimeout();
    }

    public void setSoTimeout(int i) {
        this.selectorThread.setSoTimeout(i);
        this.setAttribute("soTimeout", "" + i);
    }

    public int getServerSoTimeout() {
        return this.selectorThread.getServerSoTimeout();
    }

    public void setServerSoTimeout(int i) {
        this.selectorThread.setServerSoTimeout(i);
        this.setAttribute("serverSoTimeout", "" + i);
    }

    public void setSecure(boolean b) {
        super.setSecure(b);
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.selectorThread.setMaxKeepAliveRequests(mkar);
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.selectorThread.setKeepAliveTimeoutInSeconds(timeout);
    }

    public void setKeepAliveThreadCount(int threadCount) {
        this.selectorThread.setKeepAliveThreadCount(threadCount);
    }

    public void setMinThreads(int minThreads) {
        this.selectorThread.setMinThreads(minThreads);
    }

    public void setBufferSize(int requestBufferSize) {
        super.setBufferSize(requestBufferSize);
        this.selectorThread.setBufferSize(requestBufferSize);
    }

    public void setSelectorTimeout(int selectorTimeout) {
        SelectorThread.setSelectorTimeout(selectorTimeout);
    }

    public int getSelectorTimeout() {
        GrizzlyHttpProtocol grizzlyHttpProtocol = this;
        return grizzlyHttpProtocol.selectorThread.getSelectorTimeout();
    }

    public void setTimeout(int timeout) {
        this.selectorThread.setUploadTimeout(timeout);
    }

    public int getTimeout() {
        return this.selectorThread.getTimeout();
    }

    public void setMaxReadWorkerThreads(int maxReadWorkerThreads) {
        this.selectorThread.setMaxReadWorkerThreads(maxReadWorkerThreads);
    }

    public int getMaxReadWorkerThreads() {
        return this.selectorThread.getMaxReadWorkerThreads();
    }

    public void setDisplayConfiguration(boolean displayConfiguration) {
        this.selectorThread.setDisplayConfiguration(displayConfiguration);
    }

    public boolean getDisplayConfiguration() {
        return this.selectorThread.isDisplayConfiguration();
    }

    public void setRecycleTasks(boolean recycleTasks) {
        this.selectorThread.setRecycleTasks(recycleTasks);
    }

    public boolean getRecycleTasks() {
        return this.selectorThread.isRecycleTasks();
    }

    public void setUseByteBufferView(boolean useByteBufferView) {
        this.selectorThread.setUseByteBufferView(useByteBufferView);
    }

    public boolean getUseByteBufferView() {
        return this.selectorThread.isUseByteBufferView();
    }

    public void setMaxProcessorWorkerThreads(int maxProcessorWorkerThreads) {
        this.selectorThread.setMaxProcessorWorkerThreads(maxProcessorWorkerThreads);
    }

    public int getMaxProcessorWorkerThreads() {
        return this.selectorThread.getMaxProcessorWorkerThreads();
    }

    public void setMinReadQueueLength(int minReadQueueLength) {
        this.selectorThread.setMinReadQueueLength(minReadQueueLength);
    }

    public int getMinReadQueueLength() {
        return this.selectorThread.getMinReadQueueLength();
    }

    public void setMinProcessorQueueLength(int minProcessorQueueLength) {
        this.selectorThread.setMinProcessorQueueLength(minProcessorQueueLength);
    }

    public int getMinProcessorQueueLength() {
        return this.selectorThread.getMinProcessorQueueLength();
    }

    public void setUseDirectByteBuffer(boolean useDirectByteBuffer) {
        this.selectorThread.setUseDirectByteBuffer(useDirectByteBuffer);
    }

    public boolean getUseDirectByteBuffer() {
        return this.selectorThread.isUseDirectByteBuffer();
    }

    public void setQueueSizeInBytes(int maxQueueSizeInBytes) {
        this.selectorThread.setMaxQueueSizeInBytes(maxQueueSizeInBytes);
    }

    public void setSocketServerBacklog(int ssBackLog) {
        this.selectorThread.setSsBackLog(ssBackLog);
    }

    public void setSelectorReadThreadsCount(int selectorReadThreadsCount) {
        this.selectorThread.setSelectorReadThreadsCount(selectorReadThreadsCount);
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.selectorThread.setDefaultResponseType(defaultResponseType);
    }

    public String getDefaultResponseType() {
        return this.selectorThread.getDefaultResponseType();
    }

    public void setForcedRequestType(String forcedResponseType) {
        this.selectorThread.setForcedRequestType(forcedResponseType);
    }

    public String getForcedRequestType() {
        return this.selectorThread.getForcedRequestType();
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.selectorThread.secondsMaxAge = sMaxAges;
    }

    public void setMaxCacheEntries(int mEntries) {
        this.selectorThread.maxCacheEntries = mEntries;
    }

    public int getMaxCacheEntries() {
        return this.selectorThread.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.selectorThread.minEntrySize = mSize;
    }

    public long getMinEntrySize() {
        return this.selectorThread.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.selectorThread.maxEntrySize = mEntrySize;
    }

    public long getMaxEntrySize() {
        return this.selectorThread.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.selectorThread.maxLargeFileCacheSize = mCacheSize;
    }

    public long getMaxLargeCacheSize() {
        return this.selectorThread.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.selectorThread.maxSmallFileCacheSize = mCacheSize;
    }

    public long getMaxSmallCacheSize() {
        return this.selectorThread.maxSmallFileCacheSize;
    }

    public boolean isFileCacheEnabled() {
        return this.selectorThread.isFileCacheEnabled;
    }

    public void setFileCacheEnabled(boolean isFileCacheEnabled) {
        this.selectorThread.isFileCacheEnabled = isFileCacheEnabled;
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.selectorThread.isLargeFileCacheEnabled = isLargeEnabled;
    }

    public boolean getLargeFileCacheEnabled() {
        return this.selectorThread.isLargeFileCacheEnabled;
    }

    public void setWebAppRootPath(String rootFolder) {
        SelectorThread.setRootFolder(rootFolder);
    }

    public String getWebAppRootPath() {
        GrizzlyHttpProtocol grizzlyHttpProtocol = this;
        return grizzlyHttpProtocol.selectorThread.getRootFolder();
    }

    public static void setLogger(Logger logger) {
        if (logger != null) {
            SelectorThread.setLogger(logger);
        }
    }

    public static Logger getLogger() {
        return SelectorThread.getLogger();
    }

    public SelectorThread selectorThread() {
        return this.selectorThread;
    }

    public void setCometSupport(boolean cometSupport) {
        this.selectorThread.enableCometSupport(cometSupport);
    }

    public void setRcmSupport(boolean rcmSupport) {
        this.selectorThread.enableRcmSupport(rcmSupport);
    }

    private void checkSocketFactory() throws Exception {
        if (!this.blocking && !this.secure) {
            return;
        }
        SecureSelector secureSel = (SecureSelector)((Object)this.selectorThread);
        if (this.secure) {
            this.sslImplementation = SSLImplementation.getInstance(this.sslImplementationName);
            this.socketFactory = this.sslImplementation.getServerSocketFactory();
            secureSel.setSSLImplementation(this.sslImplementation);
            secureSel.setEnabledCipherSuites(GrizzlyHttpProtocol.toStringArray(this.getCiphers()));
            secureSel.setEnabledProtocols(GrizzlyHttpProtocol.toStringArray(this.getProtocols()));
            String clientAuthStr = (String)this.getAttribute("clientauth");
            if (clientAuthStr != null) {
                secureSel.setNeedClientAuth(Boolean.valueOf(clientAuthStr));
            }
        } else if (this.socketFactoryName != null) {
            this.socketFactory = GrizzlyHttpProtocol.string2SocketFactory(this.socketFactoryName);
        }
        if (this.socketFactory == null) {
            this.socketFactory = ServerSocketFactory.getDefault();
        }
        secureSel.setServerSocketFactory(this.socketFactory);
    }

    private static final String[] toStringArray(String list) {
        if (list == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(list, ",");
        String[] array = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            array[i++] = st.nextToken();
        }
        return array;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.selectorThread.setReuseAddress(reuseAddress);
    }

    public boolean getReuseAddress() {
        return this.selectorThread.getReuseAddress();
    }

    public String getProxiedProtocols() {
        return this.proxiedProtocols;
    }

    public void setProxiedProtocols(String proxiedProtocols) {
        this.proxiedProtocols = proxiedProtocols;
    }

    private void configureProxiedProtocols() {
        PortUnificationPipeline pipeline = (PortUnificationPipeline)this.selectorThread.getProcessorPipeline();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        StringTokenizer st = new StringTokenizer(this.proxiedProtocols, ",");
        if (this.secure) {
            this.addProtocol(TLS, pipeline, classLoader);
        }
        while (st.hasMoreTokens()) {
            String protocol = st.nextToken().toLowerCase();
            if (protocol.equals(TLS) && this.secure || protocol.equals(HTTP)) continue;
            this.addProtocol(protocol, pipeline, classLoader);
        }
        this.addProtocol(HTTP, pipeline, classLoader);
        Iterator<String> iterator = supportedHandlers.iterator();
        while (iterator.hasNext()) {
            ProtocolHandler handler = (ProtocolHandler)this.loadInstance(iterator.next(), classLoader);
            if (handler == null) continue;
            pipeline.addProtocolHandler(handler);
        }
    }

    private void addProtocol(String protocol, PortUnificationPipeline pipeline, ClassLoader classLoader) {
        String className = supportedProtocols.get(protocol);
        if (className == null) {
            SelectorThread.logger().log(Level.WARNING, "Invalid proxied protocol value: " + protocol);
            return;
        }
        ProtocolFinder finder = (ProtocolFinder)this.loadInstance(className, classLoader);
        if (finder != null) {
            pipeline.addProtocolFinder(finder);
        }
    }

    private Object loadInstance(String name, ClassLoader classLoader) {
        if (name == null) {
            return null;
        }
        Class<?> className = null;
        try {
            className = Class.forName(name, true, classLoader);
            return className.newInstance();
        }
        catch (Throwable t) {
            SelectorThread.logger().log(Level.WARNING, "Error loading proxied protocol " + name, t);
            return null;
        }
    }

    static {
        supportedProtocols.put(HTTP, HttpProtocolFinder.class.getName());
        supportedProtocols.put(TLS, TlsProtocolFinder.class.getName());
        supportedProtocols.put("ws/tcp", "com.sun.xml.ws.transport.tcp.grizzly.WSTCPProtocolFinder");
        supportedHandlers.add(HttpProtocolHandler.class.getName());
        supportedHandlers.add("com.sun.xml.ws.transport.tcp.grizzly.WSTCPProtocolHandler");
    }

    class ModelerManagement
    implements Management {
        ModelerManagement() {
        }

        public void registerComponent(Object bean, ObjectName oname, String type) throws Exception {
            Registry.getRegistry().registerComponent(bean, oname, type);
        }

        public void unregisterComponent(ObjectName oname) throws Exception {
            Registry.getRegistry().unregisterComponent(oname);
        }
    }
}

