/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class FileLister {
    private ArrayList fileList = null;
    private File mainRoot = null;
    private boolean copySymLinks = true;
    private boolean copyEmptyDirs = false;

    FileLister(File root) {
        this.mainRoot = root;
        this.fileList = new ArrayList();
    }

    protected abstract boolean relativePath();

    public void setCopySymLinks(boolean b) {
        this.copySymLinks = b;
    }

    public void setCopyEmptyDirs(boolean b) {
        this.copyEmptyDirs = b;
    }

    public String[] getFiles() {
        this.getFilesInternal(this.mainRoot);
        String[] files = new String[this.fileList.size()];
        if (files.length <= 0) {
            return files;
        }
        int len = 0;
        if (this.relativePath()) {
            len = this.mainRoot.getPath().length() + 1;
        }
        for (int i = 0; i < files.length; ++i) {
            files[i] = ((File)this.fileList.get(i)).getPath().substring(len).replace('\\', '/');
        }
        Arrays.sort(files, String.CASE_INSENSITIVE_ORDER);
        return files;
    }

    public void getFilesInternal(File root) {
        File[] files = FileUtils.listFiles(root);
        if (files.length <= 0 && this.copyEmptyDirs) {
            this.fileList.add(root);
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                if (!this.copySymLinks && !FileUtils.safeIsRealDirectory(files[i])) continue;
                this.getFilesInternal(files[i]);
                continue;
            }
            this.fileList.add(files[i]);
        }
    }
}

