/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;

public class EJBEndpointIsSLSBCheck
extends WSTest
implements WSCheck {
    public Result check(WebServiceEndpoint wsdescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (wsdescriptor.implementedByEjbComponent()) {
            EjbDescriptor ejbdesc = wsdescriptor.getEjbComponentImpl();
            if (ejbdesc == null) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "Service Implementation bean Could Not be Resolved from the ejb-link specified"));
                return result;
            }
            if (ejbdesc instanceof EjbSessionDescriptor) {
                EjbSessionDescriptor session = (EjbSessionDescriptor)ejbdesc;
                if ("Stateless".equals(session.getSessionType())) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Service Implementation bean defined in ejb-jar.xml using {0} session element", new Object[]{"stateless"}));
                } else {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Service Implementation bean cannot be Stateful Session Bean"));
                }
            } else {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "Service Implementation bean Should be a Session Bean"));
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "This is a JAX-RPC Service Endpoint"));
        }
        return result;
    }
}

