/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.timer;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;

public class HasValidEjbTimeoutDescriptor
extends EjbTest {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.isTimedObject() && descriptor.getTransactionType().equals("Container")) {
            MethodDescriptor methodDesc = descriptor.getEjbTimeoutMethod();
            ContainerTransaction txAttr = descriptor.getContainerTransactionFor(methodDesc);
            String version = this.getVerifierContext().getJavaEEVersion();
            if (txAttr != null) {
                String ta = txAttr.getTransactionAttribute();
                if (!(version.compareTo("5") < 0 || "RequiresNew".equals(ta) || "NotSupported".equals(ta) || "Required".equals(ta))) {
                    this.addErrorDetails(this.result, this.compName);
                    this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "Error : Bean [ {0} ] Transaction attribute for timeout methodmust be Required, RequiresNew or NotSupported", new Object[]{descriptor.getName()}));
                } else if (version.compareTo("5") < 0 && !"RequiresNew".equals(ta) && !"NotSupported".equals(ta)) {
                    this.addErrorDetails(this.result, this.compName);
                    this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "Error : Bean [ {0} ] Transaction attribute for ejbTimeout must be RequiresNew or NotSupported", new Object[]{descriptor.getName()}));
                }
            } else if (version.compareTo("5") < 0) {
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "Transaction attribute for Timeout is not specified for [ {0} ]", new Object[]{descriptor.getName()}));
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Transaction attributes are properly specified"));
        }
        return this.result;
    }
}

