/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;

public abstract class ExtendsRightInterface
extends EjbTest
implements EjbCheck {
    protected abstract String getInterfaceName(EjbDescriptor var1);

    protected abstract String getSuperInterface();

    protected abstract String getInterfaceType();

    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String str = null;
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        if (this.getInterfaceName(descriptor) == null || "".equals(this.getInterfaceName(descriptor))) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceTest.notApplicable", "Not Applicable because, EJB [ {0} ] does not have {1} Interface.", new Object[]{descriptor.getEjbClassName(), this.getInterfaceType()}));
            return result;
        }
        try {
            ClassLoader jcl = this.getVerifierContext().getClassLoader();
            Class<?> c = Class.forName(this.getClassName(descriptor), false, jcl);
            str = this.getSuperInterface();
            if (ExtendsRightInterface.isImplementorOf(c, str)) {
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] " + this.getInterfaceType() + " interface properly extends the" + str + " interface.", new Object[]{this.getClassName(descriptor)}));
            } else {
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly extend the EJBObject interface.  All enterprise bean" + this.getInterfaceType() + " interfaces must extend the" + str + "  interface." + " [ {1} ] is not a valid " + this.getInterfaceType() + "interface within bean [ {2} ]", new Object[]{this.getClassName(descriptor), this.getClassName(descriptor), descriptor.getName()}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{this.getClassName(descriptor)}));
        }
        return result;
    }

    private String getClassName(EjbDescriptor descriptor) {
        return this.getInterfaceName(descriptor);
    }
}

