/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbql;

import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLC;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLException;
import java.lang.reflect.Method;

public class EjbQLChecker {
    protected static final LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public static boolean checkSyntax(EjbDescriptor ejbDesc, EJBQLC ejbqlDriver, Result result, String ownerClassName) {
        boolean hasError = false;
        String query = null;
        PersistenceDescriptor desc = ((EjbCMPEntityDescriptor)ejbDesc).getPersistenceDescriptor();
        for (MethodDescriptor method : desc.getQueriedMethods()) {
            try {
                QueryDescriptor qDesc = desc.getQueryFor(method);
                query = qDesc.getQuery();
                if (!qDesc.getIsEjbQl()) continue;
                Method m = method.getMethod(ejbDesc);
                int retypeMapping = EjbQLChecker.mapRetType(qDesc.getReturnTypeMapping());
                boolean finder = false;
                if (method.getName().startsWith("find")) {
                    finder = true;
                    retypeMapping = 2;
                }
                ejbqlDriver.compile(query, m, retypeMapping, finder, ejbDesc.getName());
            }
            catch (EJBQLException ex) {
                ex.printStackTrace();
                if (!hasError) {
                    hasError = true;
                }
                result.addErrorDetails(smh.getLocalString(ownerClassName + ".parseError", "Error: [ {0} ] has parsing error(s)", new Object[]{query}));
                result.addErrorDetails(smh.getLocalString(ownerClassName + ".SAXParseException", "Exception occured : [{0}]", new Object[]{ex.toString()}));
            }
        }
        if (!hasError) {
            result.addGoodDetails(smh.getLocalString(ownerClassName + ".passed", " Syntax and Semantics of the Queries are correct", new Object[0]));
        }
        return hasError;
    }

    private static int mapRetType(int rettype) {
        switch (rettype) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 2;
    }
}

