/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.createmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Vector;

public class HomeInterfaceCreateMethodMatchArgs
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;
    boolean foundAtLeastOneCreate = false;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor.getLocalHomeClassName(), descriptor);
            if (!this.foundAtLeastOneCreate) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".debug3", "In Home Interface ", new Object[0]));
                this.result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "No create method was found, test not applicable."));
                this.result.setStatus(3);
            } else if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String component, String local, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        boolean found = false;
        this.foundAtLeastOneCreate = false;
        try {
            int i;
            Method[] homeMethods;
            Class<?> home;
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            boolean signaturesMatch = false;
            Vector<Method> createMethodSuffix = new Vector<Method>();
            if (component != null) {
                home = Class.forName(component, false, this.getVerifierContext().getClassLoader());
                homeMethods = home.getDeclaredMethods();
                for (i = 0; i < homeMethods.length; ++i) {
                    if (!homeMethods[i].getName().startsWith("create")) continue;
                    this.foundAtLeastOneCreate = true;
                    createMethodSuffix.addElement(homeMethods[i]);
                }
            }
            if (local != null) {
                home = Class.forName(local, false, this.getVerifierContext().getClassLoader());
                homeMethods = home.getDeclaredMethods();
                for (i = 0; i < homeMethods.length; ++i) {
                    if (!homeMethods[i].getName().startsWith("create")) continue;
                    this.foundAtLeastOneCreate = true;
                    createMethodSuffix.addElement(homeMethods[i]);
                }
            }
            if (!this.foundAtLeastOneCreate) {
                return false;
            }
            Class<?> EJBClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
            block4: do {
                Method[] methods = EJBClass.getDeclaredMethods();
                for (int j = 0; j < methods.length; ++j) {
                    found = false;
                    if (!methods[j].getName().startsWith("ejbCreate")) continue;
                    found = true;
                    String matchSuffix = methods[j].getName().substring(9);
                    for (int k = 0; k < createMethodSuffix.size(); ++k) {
                        Object[] businessMethodParameterTypes;
                        Object[] methodParameterTypes;
                        signaturesMatch = false;
                        if (!matchSuffix.equals(((Method)createMethodSuffix.elementAt(k)).getName().substring(6)) || !Arrays.equals(methodParameterTypes = ((Method)createMethodSuffix.elementAt(k)).getParameterTypes(), businessMethodParameterTypes = methods[j].getParameterTypes())) continue;
                        signaturesMatch = true;
                        this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface Method [ {0} ]", new Object[]{((Method)createMethodSuffix.elementAt(k)).getName()}));
                        this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding ejbCreate method with matching parameters was found."));
                        break;
                    }
                    if (signaturesMatch) continue;
                    oneFailed = true;
                    this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug3", "For Home Interface ", new Object[0]));
                    this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: No corresponding ejbCreate<Method> method with matching parameters was found."));
                    continue block4;
                }
            } while (!oneFailed && (EJBClass = EJBClass.getSuperclass()) != null && !signaturesMatch);
            if (!found && this.foundAtLeastOneCreate) {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: ejbPostCreate<Method> method corresponding to the ejbCreate<Method> method does not exist!", new Object[0]));
            }
            if (!found && !this.foundAtLeastOneCreate) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "No create method was found, test not applicable."));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface (Remote/Local) or bean class [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

