/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Iterator;
import java.util.Vector;

public class UniqueAbstractSchemaName
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        String abstractSchema = null;
        if (descriptor instanceof EjbEntityDescriptor) {
            if (((EjbEntityDescriptor)descriptor).getPersistenceType().equals("Container") && ((EjbCMPEntityDescriptor)descriptor).getCMPVersion() == 2 && (abstractSchema = ((EjbCMPEntityDescriptor)descriptor).getAbstractSchemaName()) == null) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "No Abstract Schema Name specified for a CMP 2.0 Entity Bean {0} ", new Object[]{descriptor.getName()}));
                return result;
            }
            if (abstractSchema == null) {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "This test is only for CMP 2.0 beans. Abstract Schema Names should be unique within an ejb JAR file."));
                return result;
            }
            EjbBundleDescriptor bundle = descriptor.getEjbBundleDescriptor();
            Iterator iterator = bundle.getEjbs().iterator();
            Vector<String> schemaNames = new Vector<String>();
            while (iterator.hasNext()) {
                EjbDescriptor entity = (EjbDescriptor)iterator.next();
                if (!(entity instanceof EjbEntityDescriptor) || entity.equals(descriptor) || !((EjbEntityDescriptor)entity).getPersistenceType().equals("Container")) continue;
                schemaNames.addElement(((EjbCMPEntityDescriptor)entity).getAbstractSchemaName());
            }
            for (int i = 0; i < schemaNames.size(); ++i) {
                if (!abstractSchema.equals(schemaNames.elementAt(i))) continue;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Abstract Schema Names should be unique within an ejb JAR file. Abstract Schema Name [ {0} ] is not unique.", new Object[]{abstractSchema}));
                oneFailed = true;
            }
            if (!oneFailed) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED : Abstract Schema Names for all beans within the ejb JAR file are unique."));
            } else {
                result.setStatus(1);
            }
        } else {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "This test is only for CMP 2.0 beans. Abstract Schema Names should be unique within an ejb JAR file."));
        }
        return result;
    }
}

