/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;

public abstract class EjbTest
extends VerifierTest
implements VerifierCheck,
EjbCheck {
    public Result check(Descriptor descriptor) {
        try {
            return this.check((EjbDescriptor)descriptor);
        }
        catch (Throwable t) {
            ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
            Result r = this.getInitializedResult();
            if (t instanceof NoClassDefFoundError) {
                String s = t.toString();
                String className = s.substring(s.indexOf(":"));
                this.addWarningDetails(r, compName);
                r.warning(smh.getLocalString("com.sun.enterprise.tools.verifier.checkinclasspath", "The class [ {0} ] was not found, check manifest classpath, or make sure it is available in classpath at runtime.", new Object[]{className}));
                return r;
            }
            throw new RuntimeException(t);
        }
    }

    public abstract Result check(EjbDescriptor var1);

    protected Class loadEjbClass(EjbDescriptor descriptor, Result result) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        try {
            return Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.EjbTest.failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            return null;
        }
    }

    protected String getAbstractArchiveUri(EjbDescriptor desc) {
        String archBase = this.getVerifierContext().getAbstractArchive().getArchiveUri();
        ModuleDescriptor moduleDescriptor = desc.getEjbBundleDescriptor().getModuleDescriptor();
        if (moduleDescriptor.isStandalone()) {
            return archBase;
        }
        return archBase + File.separator + FileUtils.makeFriendlyFileName(moduleDescriptor.getArchiveUri());
    }

    public boolean implementsEndpoints(EjbDescriptor descriptor) {
        WebServicesDescriptor wdesc;
        EjbBundleDescriptor bdesc = descriptor.getEjbBundleDescriptor();
        return bdesc.hasWebServices() && (wdesc = bdesc.getWebServices()).hasEndpointsImplementedBy(descriptor);
    }

    public String getArchiveURI(EjbDescriptor desc) {
        return this.getAbstractArchiveUri(desc);
    }
}

