/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AppWebContextUnique
extends ApplicationTest
implements AppCheck {
    public Result check(Application descriptor) {
        Result result = this.getInitializedResult();
        Set webs = descriptor.getWebBundleDescriptors();
        if (webs.size() <= 1) {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There is one or less web component in application [ {0} ]", new Object[]{descriptor.getName()}));
            return result;
        }
        HashSet<String> contexts = new HashSet<String>();
        Iterator itr = webs.iterator();
        boolean oneFailed = false;
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            String ctx = wbd.getContextRoot();
            if (contexts.add(ctx)) continue;
            oneFailed = true;
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: There is already a web module with context-root [ {0} ] within application [ {1} ]", new Object[]{ctx, descriptor.getName()}));
        }
        if (!oneFailed) {
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All the context-root values are unique within application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

