/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.corba.ee.org.objectweb.asm.Label;
import com.sun.corba.ee.org.objectweb.asm.commons.EmptyVisitor;
import com.sun.corba.ee.org.objectweb.asm.util.AbstractVisitor;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Method;
import com.sun.enterprise.tools.verifier.apiscan.classfile.MethodRef;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Util;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ASMMethod
extends EmptyVisitor
implements Method {
    private static String resourceBundleName = "com.sun.enterprise.tools.verifier.apiscan.LocalStrings";
    private static Logger logger = Logger.getLogger("apiscan.classfile", resourceBundleName);
    private SoftReference<ClassFile> owningClass;
    private String descriptor;
    private int access;
    private String signature;
    private String[] exceptions;
    private String name;
    private Set<MethodRef> referencedMethods = new HashSet<MethodRef>();
    private Set<String> referencedClasses = new HashSet<String>();
    private MethodRef methodRef;

    public ASMMethod(ClassFile owningClass, String name, String descriptor, int access, String signature, String[] exceptions) {
        this.owningClass = new SoftReference<ClassFile>(owningClass);
        this.name = name;
        this.descriptor = descriptor;
        this.access = access;
        this.signature = signature;
        this.exceptions = exceptions == null ? new String[0] : exceptions;
    }

    @Override
    public ClassFile getOwningClass() {
        return this.owningClass.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Collection<MethodRef> getReferencedMethods() {
        return Collections.unmodifiableCollection(this.referencedMethods);
    }

    @Override
    public Collection<String> getReferencedClasses() {
        return Collections.unmodifiableCollection(this.referencedClasses);
    }

    @Override
    public MethodRef getSelfReference() {
        if (this.methodRef == null) {
            this.methodRef = new MethodRef(this.owningClass.get().getInternalName(), this.name, this.descriptor);
        }
        return this.methodRef;
    }

    @Override
    public boolean isNative() {
        return (this.access & 0x100) == 256;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        logger.entering("com.sun.enterprise.tools.verifier.apiscan.classfile.ASMMethod", "visitFieldInsn", new Object[]{AbstractVisitor.OPCODES[opcode], owner, name, desc});
        this.addClass(owner);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        logger.entering("com.sun.enterprise.tools.verifier.apiscan.classfile.ASMMethod", "visitTryCatchBlock", new Object[]{type});
        if (type != null) {
            this.addClass(type);
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        logger.entering("com.sun.enterprise.tools.verifier.apiscan.classfile.ASMMethod", "visitMethodInsn", new Object[]{AbstractVisitor.OPCODES[opcode], owner, name, desc});
        this.addMethod(owner, name, desc);
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        logger.entering("com.sun.enterprise.tools.verifier.apiscan.classfile.ASMMethod", "visitTypeInsn", new Object[]{AbstractVisitor.OPCODES[opcode], desc});
        switch (opcode) {
            case 189: 
            case 192: 
            case 193: {
                this.addClass(desc);
                break;
            }
            case 187: {
                break;
            }
            case 188: {
                break;
            }
            default: {
                logger.logp(Level.WARNING, "com.sun.enterprise.tools.verifier.apiscan.classfile.ASMMethod", "visitTypeInsn", this.getClass().getName() + ".warning1", AbstractVisitor.OPCODES[opcode]);
            }
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        logger.entering("com.sun.enterprise.tools.verifier.apiscan.classfile.ASMMethod", "visitMultiANewArrayInsn", new Object[]{desc});
        this.addClass(desc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ASMMethod.decodeAccessFlag(this.access) + this.name + " " + this.descriptor + "{\n");
        for (MethodRef mr : this.referencedMethods) {
            sb.append(mr).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int getAccess() {
        return this.access;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public String[] getExceptions() {
        return this.exceptions;
    }

    private void addClass(String nameOrTypeDescriptor) {
        if (nameOrTypeDescriptor.indexOf(59) != -1 || nameOrTypeDescriptor.indexOf(91) != -1) {
            this.referencedClasses.addAll(ASMMethod.typeDescriptorToClassNames(nameOrTypeDescriptor));
        } else {
            this.referencedClasses.add(nameOrTypeDescriptor);
        }
    }

    private void addMethod(String owner, String name, String desc) {
        this.addClass(owner);
        this.referencedMethods.add(new MethodRef(owner, name, desc));
    }

    public static String decodeAccessFlag(int access) {
        StringBuilder result = new StringBuilder("");
        if ((access & 2) == 2) {
            result.append("private ");
        } else if ((access & 4) == 4) {
            result.append("protected ");
        } else if ((access & 1) == 1) {
            result.append("public ");
        }
        if ((access & 0x400) == 1024) {
            result.append("abstract ");
        } else if ((access & 0x10) == 16) {
            result.append("final ");
        } else if ((access & 8) == 8) {
            result.append("static ");
        }
        if ((access & 0x100) == 256) {
            result.append("native ");
        }
        return result.toString();
    }

    private static List<String> typeDescriptorToClassNames(String signature) {
        int j;
        logger.entering("com.sun.enterprise.tools.verifier.apiscan.classfile.ASMMethod", "typeDescriptorToClassNames", new Object[]{signature});
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while ((i = signature.indexOf(76, i)) != -1 && (j = signature.indexOf(59, i)) > i) {
            String className = signature.substring(i + 1, j);
            if (!Util.isPrimitive(className)) {
                result.add(className);
            }
            i = j + 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer("Class Names are {");
            int size = result.size();
            for (int k = 0; k < size; ++k) {
                sb.append((String)result.get(k));
                if (k == size - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
            logger.finer(sb.toString());
        }
        return result;
    }
}

