/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.repository.IASJ2EEResourceFactoryImpl;
import com.sun.enterprise.repository.PMFResource;
import com.sun.enterprise.resource.JdbcResourceDeployer;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;

public class PersistenceManagerFactoryResourceDeployer
implements ResourceDeployer {
    private static final StringManager localStrings = StringManager.getManager("com.sun.enterprise.resource");
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public synchronized void deployResource(Object resource) throws Exception {
        PersistenceManagerFactoryResource configPMFRes = (PersistenceManagerFactoryResource)resource;
        if (configPMFRes.isEnabled()) {
            this.loadJdbcResource(configPMFRes);
            PMFResource j2eeResource = (PMFResource)IASJ2EEResourceFactoryImpl.toPMFJ2EEResource(configPMFRes);
            ResourceInstaller installer = Switch.getSwitch().getResourceInstaller();
            installer.installPersistenceManagerResource(j2eeResource);
            installer.addResource(j2eeResource);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{configPMFRes.getJndiName(), "persistence-manager-factory-resource"});
        }
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        NamingManager namingMgr = Switch.getSwitch().getNamingManager();
        PersistenceManagerFactoryResource configPMFRes = (PersistenceManagerFactoryResource)resource;
        namingMgr.unpublishObject(configPMFRes.getJndiName());
        ResourceInstaller installer = Switch.getSwitch().getResourceInstaller();
        installer.removeResource(IASJ2EEResourceFactoryImpl.toPMFJ2EEResource(configPMFRes));
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public Object getResource(String name, Resources rbeans) throws Exception {
        PersistenceManagerFactoryResource res = rbeans.getPersistenceManagerFactoryResourceByJndiName(name);
        if (res == null) {
            String msg = localStrings.getString("resource.no_resource", name);
            throw new Exception(msg);
        }
        return res;
    }

    private void loadJdbcResource(PersistenceManagerFactoryResource cr) throws Exception {
        String resName = cr.getJdbcResourceJndiName();
        Resources resources = (Resources)cr.parent();
        JdbcResource cb = resources.getJdbcResourceByJndiName(resName);
        if (cb != null) {
            try {
                InitialContext ic = new InitialContext();
                ic.lookup(resName);
            }
            catch (Exception e) {
                JdbcResourceDeployer deployer = new JdbcResourceDeployer();
                deployer.deployResource(cb);
            }
        }
    }
}

