/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.impl.legacy.connection.DefaultSocketFactory;
import com.sun.corba.ee.impl.legacy.connection.EndPointInfoImpl;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.transport.SocketInfo;
import com.sun.enterprise.iiop.AlternateIIOPAddressComponent;
import com.sun.enterprise.iiop.AlternateIIOPAddressComponentHelper;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;

public class SocketFactory
extends DefaultSocketFactory {
    private static Logger _logger = null;
    private Hashtable endpointTable = new Hashtable();
    private Codec codec;

    public SocketInfo getEndPointInfo(ORB orb, IOR ior, SocketInfo endPointInfo) {
        try {
            IIOPProfileTemplate temp = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
            IIOPAddress primary = temp.getPrimaryAddress();
            String host = primary.getHost().toLowerCase();
            int port = primary.getPort();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "ENDPOINT INFO:host=" + host + ", port=" + port);
            }
            if ((endPointInfo = (EndPointInfoImpl)this.endpointTable.get(host + port)) != null) {
                return endPointInfo;
            }
            TaggedComponent[] alternateAddressTaggedComponents = ior.getProfile().getTaggedProfileTemplate().getIOPComponents((com.sun.corba.ee.spi.orb.ORB)((java.lang.Object)orb), 3);
            if (alternateAddressTaggedComponents.length > 0) {
                this.getCodec(orb);
                for (int i = 0; i < alternateAddressTaggedComponents.length; ++i) {
                    byte[] data = alternateAddressTaggedComponents[i].component_data;
                    Any any = null;
                    try {
                        any = this.codec.decode_value(data, AlternateIIOPAddressComponentHelper.type());
                    }
                    catch (TypeMismatch e) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Exception codec TypeMismatch", e);
                        }
                        throw new RuntimeException(e.toString());
                    }
                    catch (FormatMismatch e) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Exception codec FormatMismatch", e);
                        }
                        throw new RuntimeException(e.toString());
                    }
                    AlternateIIOPAddressComponent iiopAddress = AlternateIIOPAddressComponentHelper.extract(any);
                    endPointInfo = (EndPointInfoImpl)this.endpointTable.get(iiopAddress.host + iiopAddress.port);
                    if (endPointInfo == null) continue;
                    this.endpointTable.put(host + port, endPointInfo);
                    return endPointInfo;
                }
                endPointInfo = new EndPointInfoImpl("IIOP_CLEAR_TEXT", port, host);
                this.endpointTable.put(host + port, endPointInfo);
            } else {
                endPointInfo = new EndPointInfoImpl("IIOP_CLEAR_TEXT", port, host);
                this.endpointTable.put(host + port, endPointInfo);
            }
            return endPointInfo;
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception getting End point info", ex);
            }
            throw new RuntimeException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Codec getCodec(ORB orb) {
        if (this.codec == null) {
            SocketFactory socketFactory = this;
            synchronized (socketFactory) {
                CodecFactory codecFactory = null;
                try {
                    codecFactory = CodecFactoryHelper.narrow((Object)orb.resolve_initial_references("CodecFactory"));
                }
                catch (InvalidName e) {
                    System.out.println("Getting org.omg.CORBA.ORBPackage.InvalidName exception");
                }
                Encoding encoding = new Encoding(0, 1, 2);
                try {
                    this.codec = codecFactory.create_codec(encoding);
                }
                catch (UnknownEncoding e) {
                    System.out.println("Getting org.omg.IOP.CodecFactoryPackage.UnknownEncoding exception");
                }
            }
        }
        return this.codec;
    }

    private int shortToInt(short value) {
        if (value < 0) {
            return value + 65536;
        }
        return value;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
    }
}

