/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.collect.ProcessExecutor;
import com.sun.enterprise.diagnostics.collect.ProcessExecutorException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class ProcessRunner
implements Runnable {
    static final Logger logger = ProcessExecutor.logger;
    long timeout;
    String[] cmd;
    StringBuffer stdout = new StringBuffer();
    StringBuffer stderr = new StringBuffer();
    int exitCode;
    boolean completed = false;
    boolean interrupted = false;
    ProcessExecutorException exception;
    private String cmdString = null;

    ProcessRunner(String[] cmd, long timeout) {
        this.cmd = cmd;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Process process = null;
        InputStream is = null;
        InputStream es = null;
        try {
            try {
                process = Runtime.getRuntime().exec(this.cmd);
            }
            catch (IOException ioe) {
                logger.log(Level.FINE, "process.creation_failed", ioe);
                this.makeOtherException(ioe);
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (es != null) {
                        es.close();
                    }
                    if (process != null) {
                        process.destroy();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return;
            }
            if (this.checkInterrupted()) {
                return;
            }
            is = process.getInputStream();
            es = process.getErrorStream();
            this.readFromStream(es, this.stderr);
            if (this.checkInterrupted()) {
                return;
            }
            this.readFromStream(is, this.stdout);
            if (this.checkInterrupted()) {
                return;
            }
            try {
                is.close();
                es.close();
                is = null;
                es = null;
            }
            catch (IOException ioe) {
                logger.log(Level.FINEST, "process.stream_close_error", ioe);
            }
            this.exitCode = process.waitFor();
            if (this.exitCode != 0) {
                this.makeAbnormalTerminationException();
            }
            process.destroy();
            process = null;
            this.completed = true;
        }
        catch (InterruptedException ie) {
            logger.log(Level.FINEST, "process.interrupted");
            this.interrupted = true;
            this.makeTimeoutException();
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "process.execution_failed", e);
            this.makeOtherException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (es != null) {
                    es.close();
                }
                if (process != null) {
                    process.destroy();
                }
            }
            catch (Throwable t) {}
        }
    }

    void readFromStream(InputStream stream, StringBuffer buffer) {
        byte[] bytes = new byte[1024];
        try {
            int count = 0;
            while ((count = stream.read(bytes)) != -1) {
                buffer.append(new String(bytes, 0, count));
                if (!this.checkInterrupted()) continue;
                return;
            }
        }
        catch (IOException ioe) {
            logger.log(Level.FINEST, "process.stream_read_error", ioe);
        }
    }

    private boolean checkInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            this.interrupted = true;
            this.makeTimeoutException();
        }
        return this.interrupted;
    }

    void makeTimeoutException() {
        String outs = this.stderr.toString() + "\n" + this.stdout.toString();
        this.exception = new ProcessExecutorException("process.timeout", "Process timed out.\nTimeout was {2} msecs\nAttempted command: {0}\nOutput from command: {1}", new Object[]{this.getCommandString(), outs, new Long(this.timeout)});
    }

    void makeAbnormalTerminationException() {
        String outs = this.stderr.toString() + "\n" + this.stdout.toString();
        this.exception = new ProcessExecutorException("process.abnormal_termination", "Abnormal process termination -- process returned: {0}\nAttempted command: {1}\nOutput from command: {2}", new Object[]{new Integer(this.exitCode), this.getCommandString(), outs});
    }

    void makeOtherException(Throwable t) {
        String outs = this.stderr.toString() + "\n" + this.stdout.toString();
        this.exception = new ProcessExecutorException("process.unknown_exception", "Abnormal process termination -- process threw an Exception.\nAttempted command: {0}\nOutput from command: {1}", new Object[]{this.getCommandString(), outs}, t);
    }

    String getCommandString() {
        if (this.cmdString == null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.cmd.length; ++i) {
                buf.append(this.cmd[i] + " ");
            }
            this.cmdString = buf.toString();
        }
        return this.cmdString;
    }
}

