/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.diagnostics.BackendObjectFactory;
import com.sun.enterprise.diagnostics.CLIOptions;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ExecutionContext;
import com.sun.enterprise.diagnostics.ReportConfig;
import com.sun.enterprise.diagnostics.ReportGenerator;
import com.sun.enterprise.diagnostics.ReportTarget;
import com.sun.enterprise.diagnostics.ServiceConfig;
import com.sun.enterprise.diagnostics.TargetResolver;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.report.html.HTMLReportWriter;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class SingleInstanceObjectFactory
implements BackendObjectFactory {
    protected Map input;
    protected CLIOptions options;
    protected ReportConfig config;
    protected ReportTarget target;
    protected ExecutionContext context;
    protected Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public SingleInstanceObjectFactory(Map input) {
        this.input = input;
    }

    public ReportGenerator createReportGenerator() throws DiagnosticException {
        this.analyzeInput();
        Collector harvester = this.createHarvester();
        HTMLReportWriter reportWriter = this.createHTMLReportWriter();
        return this.createReportGenerator(this.config, harvester, reportWriter);
    }

    public abstract ReportGenerator createReportGenerator(ReportConfig var1, Collector var2, HTMLReportWriter var3) throws DiagnosticException;

    public abstract Collector createHarvester() throws DiagnosticException;

    public abstract HTMLReportWriter createHTMLReportWriter() throws DiagnosticException;

    public abstract TargetResolver createTargetResolver(boolean var1) throws DiagnosticException;

    protected ReportConfig getReportConfig() {
        return this.config;
    }

    protected void analyzeInput() throws DiagnosticException {
        if (this.input != null) {
            TargetResolver resolver = null;
            List<ServiceConfig> serviceConfigs = null;
            this.options = new CLIOptions(this.input);
            boolean local = this.isLocal();
            resolver = this.createTargetResolver(local);
            this.target = resolver.resolve();
            this.context = resolver.getExecutionContext();
            serviceConfigs = resolver.getServiceConfigs();
            this.logger = this.context.getLogger();
            this.config = new ReportConfig(this.options, this.target, this.context);
            this.config.addInstanceConfigs(serviceConfigs);
        }
    }

    protected boolean isLocal() {
        return this.options.isLocal() && this.options.getTargetDir() != null;
    }
}

